/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.db;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.output.db.AbstractJDBCTarget;
import org.apache.log.output.db.ColumnInfo;

public class DefaultJDBCTarget
extends AbstractJDBCTarget {
    private final String m_table;
    private final ColumnInfo[] m_columns;
    private PreparedStatement m_statement;

    public DefaultJDBCTarget(DataSource dataSource, String table, ColumnInfo[] columns) {
        super(dataSource);
        this.m_table = table;
        this.m_columns = columns;
        if (null == table) {
            throw new NullPointerException("table property must not be null");
        }
        if (null == columns) {
            throw new NullPointerException("columns property must not be null");
        }
        if (0 == columns.length) {
            throw new NullPointerException("columns must have at least 1 element");
        }
        this.open();
    }

    protected synchronized void output(LogEvent event) {
        try {
            int i = 0;
            while (i < this.m_columns.length) {
                this.specifyColumn(this.m_statement, i, event);
                ++i;
            }
            this.m_statement.executeUpdate();
        }
        catch (SQLException se) {
            this.getErrorHandler().error("Error executing statement", se, event);
        }
    }

    protected synchronized void openConnection() {
        super.openConnection();
        this.m_statement = null;
        try {
            Connection connection = this.getConnection();
            if (null != connection) {
                this.m_statement = connection.prepareStatement(this.getStatementSQL());
            }
        }
        catch (SQLException se) {
            this.getErrorHandler().error("Error preparing statement", se, null);
        }
    }

    protected String getStatementSQL() {
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(this.m_table);
        sb.append(" (");
        sb.append(this.m_columns[0].getName());
        int i = 1;
        while (i < this.m_columns.length) {
            sb.append(", ");
            sb.append(this.m_columns[i].getName());
            ++i;
        }
        sb.append(") VALUES (?");
        int i2 = 1;
        while (i2 < this.m_columns.length) {
            sb.append(", ?");
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    protected boolean isStale() {
        return super.isStale();
    }

    protected synchronized void closeConnection() {
        super.closeConnection();
        if (null != this.m_statement) {
            try {
                this.m_statement.close();
            }
            catch (SQLException se) {
                this.getErrorHandler().error("Error closing statement", se, null);
            }
            this.m_statement = null;
        }
    }

    protected void specifyColumn(PreparedStatement statement, int index, LogEvent event) throws SQLException, IllegalStateException {
        ColumnInfo info = this.m_columns[index];
        switch (info.getType()) {
            case 6: {
                statement.setLong(index + 1, event.getRelativeTime());
                break;
            }
            case 5: {
                statement.setTimestamp(index + 1, new Timestamp(event.getTime()));
                break;
            }
            case 4: {
                statement.setString(index + 1, event.getMessage());
                break;
            }
            case 2: {
                statement.setString(index + 1, event.getCategory());
                break;
            }
            case 8: {
                statement.setString(index + 1, event.getPriority().getName());
                break;
            }
            case 3: {
                statement.setString(index + 1, this.getContextMap(event.getContextMap(), info.getAux()));
                break;
            }
            case 1: {
                statement.setString(index + 1, info.getAux());
                break;
            }
            case 7: {
                statement.setString(index + 1, this.getStackTrace(event.getThrowable()));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ColumnType: " + info.getType());
            }
        }
    }

    protected final String getTable() {
        return this.m_table;
    }

    protected final ColumnInfo getColumn(int index) {
        return this.m_columns[index];
    }

    private String getStackTrace(Throwable throwable) {
        if (null == throwable) {
            return "";
        }
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private String getContextMap(ContextMap map, String aux) {
        if (null == map) {
            return "";
        }
        return map.get(aux, "").toString();
    }
}

