/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.utils;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TempRepository {
    private static TempRepository instance = null;
    private List directories = new Vector();

    private TempRepository() {
    }

    public static TempRepository getInstance() {
        if (instance == null) {
            instance = new TempRepository();
        }
        return instance;
    }

    public void addDir(File file) {
        this.directories.add(file);
    }

    public boolean deleteAll() {
        boolean result = true;
        Iterator i = this.directories.iterator();
        while (i.hasNext()) {
            File dir = (File)i.next();
            i.remove();
            if (!dir.exists()) continue;
            result &= this.delete(dir);
        }
        return result;
    }

    private boolean delete(File f) {
        if (f.isFile()) {
            return f.delete();
        }
        File[] childs = f.listFiles();
        if (childs == null) {
            return f.delete();
        }
        boolean result = true;
        for (int i = 0; i < childs.length; ++i) {
            result &= this.delete(childs[i]);
        }
        return result && f.delete();
    }

    public File createDir() throws IOException {
        return this.createDir(null);
    }

    public File createDir(String extension) throws IOException {
        File tmp = File.createTempFile("genbase", extension);
        if (!tmp.delete()) {
            throw new IOException("Cannot delete temporary file");
        }
        if (!tmp.mkdir()) {
            throw new IOException("Cannot create temporary directory");
        }
        this.addDir(tmp);
        return tmp;
    }
}

