/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.http.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class JOnASServletResponseWrapper {
    private String contentType;
    private String host;
    private OutputStream out;
    private String method;
    private Map parameters;
    private String path;
    private URL uri;
    private int port;
    private Map headers;
    private int statusCode;
    private String statusMessage;
    private HttpServletResponse response;

    public JOnASServletResponseWrapper(HttpServletResponse response) {
        this.response = response;
    }

    public JOnASServletResponseWrapper(String contentType, String host, String path, URL uri, int port, OutputStream out) {
        this.contentType = contentType;
        this.host = host;
        this.parameters = new HashMap();
        this.path = path;
        this.uri = uri;
        this.port = port;
        this.headers = new HashMap();
        this.out = out;
        this.response = null;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setContentLength(int length) {
        if (this.response != null) {
            this.response.setContentLength(length);
        }
    }

    public void setHeader(String name, String value) {
        if (this.response != null) {
            this.response.setHeader(name, value);
        }
    }

    public String getHost() {
        return this.host;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.response != null) {
            return this.response.getOutputStream();
        }
        return this.out;
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public URL getURI() {
        return this.uri;
    }

    public String getContentType() {
        if (this.response != null) {
            return this.response.getContentType();
        }
        return this.contentType;
    }

    public void setStatusCode(int code) {
        if (this.response != null) {
            this.response.setStatus(code);
        } else {
            this.statusCode = code;
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusMessage(String responseString) {
        this.statusMessage = responseString;
    }

    public void setStatus(int code, String responseString) {
        if (this.response != null) {
            this.response.setStatus(code, responseString);
        } else {
            this.statusMessage = responseString;
            this.statusCode = code;
        }
    }
}

