/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.HandlerDesc;
import org.ow2.jonas.deployment.common.xml.Handler;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.JonasInitParam;
import org.ow2.jonas.deployment.common.xml.JonasPortComponentRef;
import org.ow2.jonas.deployment.common.xml.JonasServiceRef;
import org.ow2.jonas.deployment.common.xml.PortComponentRef;
import org.ow2.jonas.deployment.common.xml.ServiceRef;
import org.ow2.jonas.deployment.ws.MappingFile;
import org.ow2.jonas.deployment.ws.PortComponentRefDesc;
import org.ow2.jonas.deployment.ws.WSDLFile;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.deployment.ws.lib.MappingFileManager;
import org.ow2.jonas.deployment.ws.wrapper.MappingFileManagerWrapper;
import org.ow2.jonas.lib.util.BeanNaming;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

public class ServiceRefDesc
implements IServiceRefDesc {
    private static final String JAVAX_XML_RPC_SERVICE = "javax.xml.rpc.Service";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ws");
    private static I18n i18n = I18n.getInstance(ServiceRefDesc.class);
    private Hashtable params = new Hashtable();
    private Vector pcRefs = new Vector();
    private Vector hRefs = new Vector();
    private WSDLFile wsdl;
    private WSDLFile altWsdl;
    private MappingFile mapping;
    private String name;
    private Class serviceInterface;
    private QName serviceQName = null;
    private File moduleFile = null;
    private String wsdlFileName = null;
    private String mappingFileName = null;
    private URL alternateWSDL = null;
    private URL localWSDLURL = null;
    private URL mappingFileURL = null;

    public ServiceRefDesc(ClassLoader classLoader, ServiceRef sref, JonasServiceRef jsref, String filename) throws WSDeploymentDescException {
        String mf;
        String wf;
        if (filename != null) {
            this.moduleFile = new File(filename);
        }
        ClassLoader loader = classLoader;
        this.name = sref.getServiceRefName();
        if (sref.getServiceQname() != null) {
            this.serviceQName = sref.getServiceQname().getQName();
        }
        String si = sref.getServiceInterface().trim();
        try {
            this.serviceInterface = loader.loadClass(si);
        }
        catch (ClassNotFoundException cnf) {
            throw new WSDeploymentDescException(ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.serviceIntfNotFound", (Object)si), cnf);
        }
        if (!Service.class.isAssignableFrom(this.serviceInterface)) {
            String err = ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.mustExtService", (Object)this.serviceInterface.getName());
            throw new WSDeploymentDescException(err);
        }
        if (jsref != null) {
            JLinkedList jipl = jsref.getJonasInitParamList();
            for (int i = 0; i < jipl.size(); ++i) {
                JonasInitParam p = (JonasInitParam)jipl.get(i);
                this.params.put(p.getParamName().trim(), p.getParamValue().trim());
            }
        }
        Map links = this.linkPCR2JPCR(sref, jsref);
        JLinkedList pcrl = sref.getPortComponentRefList();
        for (int i = 0; i < pcrl.size(); ++i) {
            PortComponentRef ref = (PortComponentRef)pcrl.get(i);
            JonasPortComponentRef jref = (JonasPortComponentRef)links.get(ref.getServiceEndpointInterface());
            this.pcRefs.add(new PortComponentRefDesc(loader, ref, jref));
        }
        JLinkedList hl = sref.getHandlerList();
        Handler h = null;
        for (int i = 0; i < hl.size(); ++i) {
            h = (Handler)hl.get(i);
            try {
                this.hRefs.add(new HandlerDesc(loader, h));
                continue;
            }
            catch (DeploymentDescException dde) {
                throw new WSDeploymentDescException(dde);
            }
        }
        if (jsref != null && jsref.getAltWsdl() != null && this.isJonasRuntime()) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("loading alt-wsdl : " + jsref.getAltWsdl()));
            }
            try {
                this.alternateWSDL = new URL(jsref.getAltWsdl());
                this.altWsdl = new WSDLFile(this.alternateWSDL, jsref.getAltWsdl());
            }
            catch (IOException e) {
                String err = "Cannot load alternate WSDL Stream from " + jsref.getAltWsdl();
                throw new WSDeploymentDescException(err);
            }
        }
        if ((wf = sref.getWsdlFile()) != null) {
            this.wsdlFileName = wf.trim();
            this.wsdl = new WSDLFile(loader, this.wsdlFileName);
            this.localWSDLURL = loader.getResource(this.wsdlFileName);
        }
        if (this.getWSDLFile() != null) {
            if (this.getWSDLFile().getNbServices() > 1 && this.serviceQName == null) {
                String err = ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.serviceQnameNotDef", (Object)this.wsdlFileName, (Object)this.name);
                throw new WSDeploymentDescException(err);
            }
            if (this.getWSDLFile().getNbServices() == 1 && this.serviceQName == null) {
                this.serviceQName = this.getWSDLFile().getServiceQname();
            } else if (this.isJonasRuntime() && !this.getWSDLFile().hasService(this.serviceQName)) {
                throw new WSDeploymentDescException(ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.serviceNotFoundInWSDL", (Object)this.serviceQName, (Object)this.wsdlFileName));
            }
        }
        if ((mf = sref.getJaxrpcMappingFile()) != null) {
            this.mappingFileName = mf.trim();
            this.mappingFileURL = loader.getResource(this.mappingFileName);
            this.setMappingFile(loader);
        }
        if (!this.serviceInterface.getName().equals(JAVAX_XML_RPC_SERVICE) && this.mapping == null) {
            throw new WSDeploymentDescException(ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.mappingRequired", (Object)this.serviceInterface.getName()));
        }
        this.validate();
    }

    private boolean isJonasRuntime() {
        String[] TESTED_PACKAGE = new String[]{"org.ow2.jonas.generators.wsgen", "org.ow2.jonas.generators.genclientstub", "org.ow2.jonas.generators.genic"};
        Exception t = new Exception();
        StackTraceElement[] elem = t.getStackTrace();
        for (int i = 0; i < elem.length; ++i) {
            for (int j = 0; j < TESTED_PACKAGE.length; ++j) {
                if (!elem[i].getClassName().startsWith(TESTED_PACKAGE[j])) continue;
                return false;
            }
        }
        return true;
    }

    private Map linkPCR2JPCR(ServiceRef sref, JonasServiceRef jsref) {
        HashMap<String, JonasPortComponentRef> res = new HashMap<String, JonasPortComponentRef>();
        for (PortComponentRef pcr : sref.getPortComponentRefList()) {
            res.put(pcr.getServiceEndpointInterface(), null);
        }
        if (jsref != null) {
            Set keys = res.keySet();
            for (JonasPortComponentRef jpcr : jsref.getJonasPortComponentRefList()) {
                String sei = jpcr.getServiceEndpointInterface();
                if (sei != null && keys.contains(sei)) {
                    res.put(sei, jpcr);
                    continue;
                }
                String err = "jonas-port-component-ref '" + sei + "' is not linked to any port-component-ref. It will be ignored.";
                logger.log(BasicLevel.DEBUG, (Object)err);
            }
        }
        return res;
    }

    public List getPortComponentRefs() {
        return this.pcRefs;
    }

    public List getHandlerRefs() {
        return this.hRefs;
    }

    public String getServiceRefName() {
        return this.name;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public WSDLFile getWSDLFile() {
        WSDLFile file = this.altWsdl;
        if (file == null) {
            file = this.wsdl;
        }
        return file;
    }

    public MappingFile getMappingFile() {
        return this.mapping;
    }

    public Hashtable getParams() {
        return this.params;
    }

    public String getParam(String name) {
        return (String)this.params.get(name);
    }

    public String getWsdlFileName() {
        return this.wsdlFileName;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ServiceRefDesc)) {
            return false;
        }
        ServiceRefDesc sr = (ServiceRefDesc)other;
        if (!this.mapping.equals(sr.getMappingFile())) {
            return false;
        }
        if (!this.wsdl.equals(sr.getWSDLFile())) {
            return false;
        }
        if (!this.params.equals(sr.getParams())) {
            return false;
        }
        for (PortComponentRefDesc pcr : sr.getPortComponentRefs()) {
            if (this.pcRefs.contains(pcr)) continue;
            return false;
        }
        for (HandlerDesc hr : sr.getHandlerRefs()) {
            if (this.hRefs.contains(hr)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMappingFile(ClassLoader loader) throws WSDeploymentDescException {
        if (this.moduleFile != null) {
            this.mapping = this.isRunningInClientContainer() ? MappingFileManager.getInstance(this.moduleFile, this.mappingFileName) : MappingFileManagerWrapper.getMappingFile(this.moduleFile, this.mappingFileName);
            return;
        } else {
            InputStream is = null;
            if (loader == null) throw new WSDeploymentDescException(ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.mappingFileNotFound"));
            is = loader.getResourceAsStream(this.mappingFileName);
            if (is == null) throw new WSDeploymentDescException(ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.mappingFileNotFoundInLoader", (Object)this.mappingFileName));
            this.mapping = this.isRunningInClientContainer() ? MappingFileManager.getInstance(is, this.mappingFileName) : MappingFileManagerWrapper.getMappingFile(is, this.mappingFileName);
        }
    }

    private boolean isRunningInClientContainer() {
        return System.getProperty("jonas.base") == null;
    }

    private void validate() throws WSDeploymentDescException {
        if (this.wsdlFileName != null && (this.mappingFileName == null || "".equals(this.mappingFileName))) {
            throw new WSDeploymentDescException(ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.missingMappingFile", (Object)this.name));
        }
        for (int i = 0; i < this.hRefs.size(); ++i) {
            HandlerDesc myHRef = (HandlerDesc)this.hRefs.get(i);
            List pnl = myHRef.getPortNames();
            for (int j = 0; j < pnl.size(); ++j) {
                if (this.getWSDLFile().hasPort((String)pnl.get(j))) continue;
                throw new WSDeploymentDescException(ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.undefinedPort", (Object)myHRef.getName(), pnl.get(j), (Object)this.wsdlFileName));
            }
        }
        if (!this.serviceInterface.equals(Service.class)) {
            if (this.getWSDLFile() == null || this.getWSDLFile() != null && this.getWSDLFile().getDefinition().getServices().values().size() == 0) {
                throw new WSDeploymentDescException(ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.wsdlMissingInformation", (Object)this.serviceInterface.getName(), (Object)this.name));
            }
            String namespaceURI = this.serviceQName.getNamespaceURI();
            String realPackage = BeanNaming.getPackageName((String)this.serviceInterface.getName());
            if (!realPackage.equals(this.mapping.getMapping(namespaceURI))) {
                throw new WSDeploymentDescException(ServiceRefDesc.getI18n().getMessage("ServiceRefDesc.needPackageMapping", (Object)this.mappingFileName, (Object)realPackage));
            }
        }
    }

    protected static I18n getI18n() {
        return i18n;
    }

    public URL getAlternateWsdlURL() {
        return this.alternateWSDL;
    }

    public URL getLocalWSDLURL() {
        return this.localWSDLURL;
    }

    public URL getMappingFileURL() {
        return this.mappingFileURL;
    }
}

