/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.ow2.util.marshalling.ClassLoaderObjectInputStream;
import org.ow2.util.marshalling.CtxClassLoaderObjectInputStream;
import org.ow2.util.marshalling.SerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Serialization {
    private Serialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] storeObject(Serializable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    public static Object loadObject(byte[] bytes) throws IOException, ClassNotFoundException {
        return Serialization.loadObject(bytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadObject(byte[] bytes, ClassLoader classloader) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ClassLoaderObjectInputStream classLoaderObjectInputStream = null;
        classLoaderObjectInputStream = classloader != null ? new ClassLoaderObjectInputStream(bais, classloader) : new CtxClassLoaderObjectInputStream(bais);
        try {
            Object object = classLoaderObjectInputStream.readObject();
            return object;
        }
        finally {
            if (classLoaderObjectInputStream != null) {
                classLoaderObjectInputStream.close();
            }
            if (classLoaderObjectInputStream != null) {
                bais.close();
            }
        }
    }

    public static <T extends Serializable> T cloneObject(T objectToClone) throws SerializationException {
        byte[] bytes = null;
        try {
            bytes = Serialization.storeObject(objectToClone);
        }
        catch (IOException e) {
            throw new SerializationException("Cannot get array of bytes of the given object " + objectToClone, e);
        }
        Object clonedObject = null;
        try {
            clonedObject = Serialization.loadObject(bytes, objectToClone.getClass().getClassLoader());
        }
        catch (IOException e) {
            throw new SerializationException("Cannot create object from the array of bytes of the given object " + objectToClone, e);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Cannot create object from the array of bytes of the given object " + objectToClone, e);
        }
        return (T)((Serializable)clonedObject);
    }
}

