/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdministeredObject;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.util.monolog.api.BasicLevel;

public class ClusterConnectionFactory
extends AdministeredObject
implements javax.jms.ConnectionFactory {
    private static final long serialVersionUID = 1L;
    protected Hashtable cluster = null;

    public void addConnectionFactory(ConnectionFactory cf) {
        String location = System.getProperty("location");
        this.addConnectionFactory(location, cf);
    }

    public void addConnectionFactory(String location, ConnectionFactory cf) {
        if (this.cluster == null) {
            this.cluster = new Hashtable();
        }
        if (location == null) {
            location = cf.getParameters().getHost();
        }
        this.cluster.put(location, cf);
    }

    protected ConnectionFactory getConnectionFactory() throws JMSException {
        if (this.cluster != null && !this.cluster.isEmpty()) {
            ConnectionFactory cf = null;
            String location = System.getProperty("location");
            if (location == null || location.equals("")) {
                int idx = new Random().nextInt(this.cluster.size());
                Object[] key = this.cluster.keySet().toArray();
                location = (String)key[idx];
                System.setProperty("location", location);
            }
            if ((cf = (ConnectionFactory)this.cluster.get(location)) == null) {
                Enumeration e = this.cluster.elements();
                cf = (ConnectionFactory)e.nextElement();
            }
            return cf;
        }
        return null;
    }

    public final Connection createConnection() throws JMSException {
        ConnectionFactory cf = this.getConnectionFactory();
        return cf.createConnection();
    }

    public final Connection createConnection(String name, String password) throws JMSException {
        ConnectionFactory cf = this.getConnectionFactory();
        return cf.createConnection(name, password);
    }

    public String toString() {
        return "ClusterConnectionFactory:" + this.cluster;
    }

    public Hashtable getCluster() {
        return this.cluster;
    }

    public void toReference(Reference ref) throws NamingException {
        if (this.cluster == null) {
            return;
        }
        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
        this.cluster.entrySet().toArray(entries);
        StringBuffer strbuf = new StringBuffer(15);
        for (int i = 0; i < entries.length; ++i) {
            strbuf.setLength(0);
            strbuf.append("CF#").append(i).append(".key");
            ref.add(new StringRefAddr(strbuf.toString(), (String)entries[i].getKey()));
            ConnectionFactory cf = (ConnectionFactory)entries[i].getValue();
            strbuf.setLength(0);
            strbuf.append("CF#").append(i).append(".class");
            ref.add(new StringRefAddr(strbuf.toString(), cf.getClass().getName()));
            strbuf.setLength(0);
            strbuf.append("CF#").append(i);
            cf.toReference(ref, strbuf.toString());
        }
    }

    public void fromReference(Reference ref) throws NamingException {
        int i = 0;
        StringBuffer strbuf = new StringBuffer(15);
        while (true) {
            block4: {
                strbuf.setLength(0);
                strbuf.append("CF#").append(i).append(".key");
                RefAddr refAddr = ref.get(strbuf.toString());
                if (refAddr == null) break;
                String key = (String)refAddr.getContent();
                strbuf.setLength(0);
                strbuf.append("CF#").append(i).append(".class");
                String classname = (String)ref.get(strbuf.toString()).getContent();
                try {
                    Class<?> clazz = Class.forName(classname);
                    ConnectionFactory cf = (ConnectionFactory)clazz.newInstance();
                    strbuf.setLength(0);
                    strbuf.append("CF#").append(i);
                    cf.fromReference(ref, strbuf.toString());
                    if (this.cluster == null) {
                        this.cluster = new Hashtable();
                    }
                    this.cluster.put(key, cf);
                }
                catch (Exception exc) {
                    if (!JoramTracing.dbgClient.isLoggable(BasicLevel.ERROR)) break block4;
                    JoramTracing.dbgClient.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                }
            }
            ++i;
        }
    }

    public Hashtable code() {
        Hashtable h = new Hashtable();
        if (this.cluster == null) {
            return h;
        }
        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
        this.cluster.entrySet().toArray(entries);
        StringBuffer strbuf = new StringBuffer(15);
        for (int i = 0; i < entries.length; ++i) {
            strbuf.setLength(0);
            strbuf.append("CF#").append(i).append(".key");
            h.put(strbuf.toString(), entries[i].getKey());
            ConnectionFactory cf = (ConnectionFactory)entries[i].getValue();
            strbuf.setLength(0);
            strbuf.append("CF#").append(i).append(".class");
            h.put(strbuf.toString(), cf.getClass().getName());
            strbuf.setLength(0);
            strbuf.append("CF#").append(i);
            cf.code(h, strbuf.toString());
        }
        return h;
    }

    public void decode(Hashtable h) {
        if (this.cluster == null) {
            this.cluster = new Hashtable();
        }
        int i = 0;
        StringBuffer strbuf = new StringBuffer(15);
        while (true) {
            block4: {
                strbuf.setLength(0);
                strbuf.append("CF#").append(i).append(".key");
                String key = (String)h.get(strbuf.toString());
                if (key == null) break;
                strbuf.setLength(0);
                strbuf.append("CF#").append(i).append(".class");
                String classname = (String)h.get(strbuf.toString());
                try {
                    Class<?> clazz = Class.forName(classname);
                    ConnectionFactory cf = (ConnectionFactory)clazz.newInstance();
                    strbuf.setLength(0);
                    strbuf.append("CF#").append(i);
                    cf.decode(h, strbuf.toString());
                    this.cluster.put(key, cf);
                }
                catch (Exception exc) {
                    if (!JoramTracing.dbgClient.isLoggable(BasicLevel.ERROR)) break block4;
                    JoramTracing.dbgClient.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                }
            }
            ++i;
        }
    }
}

