/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteStub;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ow2.carol.irmi.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIObjectOutputStream
extends ObjectOutputStream {
    private Map<Class<?>, Integer> cache = new HashMap();
    private Set<Class<?>> annotated = new HashSet();

    public RMIObjectOutputStream(OutputStream out) throws IOException {
        super(new BufferedOutputStream(out, 4096));
        this.enableReplaceObject(true);
    }

    @Override
    protected void annotateClass(Class<?> cl) throws IOException {
        if (this.annotated.contains(cl)) {
            return;
        }
        String annotation = RMIClassLoader.getClassAnnotation(cl);
        if (annotation == null) {
            annotation = "";
        }
        this.writeUTF(annotation);
        this.annotated.add(cl);
    }

    @Override
    protected void annotateProxyClass(Class<?> cl) throws IOException {
        this.annotateClass(cl);
    }

    @Override
    protected Object replaceObject(Object obj) {
        if (obj instanceof RemoteStub) {
            return obj;
        }
        if (obj instanceof Remote) {
            Collection<Server> servers = Server.getServers();
            for (Server server : servers) {
                RemoteStub stub = server.getStub((Remote)obj);
                if (stub == null) continue;
                return stub;
            }
            return obj;
        }
        return obj;
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        Class<?> klass = desc.forClass();
        Integer num = this.cache.get(klass);
        if (num == null) {
            num = new Integer(this.cache.size());
            this.cache.put(klass, num);
            this.writeShort(-1);
            super.writeClassDescriptor(desc);
        } else {
            this.writeShort(num);
        }
    }

    @Override
    protected void writeStreamHeader() {
    }
}

