/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class Timer {
    private static final List TIMERS = new ArrayList();
    private String name;
    private ThreadLocal start = new ThreadLocal(){

        protected Object initialValue() {
            Slot result = new Slot();
            result.level = 0;
            return result;
        }
    };
    private long total = 0L;
    private int count = 0;

    private static synchronized void dump(String name) throws IOException {
        PrintWriter w;
        boolean close = true;
        if (name.equals("-")) {
            w = new PrintWriter(new OutputStreamWriter(System.err));
            close = false;
        } else {
            w = new PrintWriter(new FileWriter(name, true));
            w.println("--------------------");
        }
        for (int i = 0; i < TIMERS.size(); ++i) {
            Timer t = (Timer)TIMERS.get(i);
            if (t.getCount() <= 0) continue;
            w.println(t.getName() + ": " + t);
        }
        w.flush();
        if (close) {
            w.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer(String name) {
        this.name = name;
        Class<Timer> clazz = Timer.class;
        synchronized (Timer.class) {
            TIMERS.add(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    private Slot getSlot() {
        return (Slot)this.start.get();
    }

    public void start() {
        Slot slot = this.getSlot();
        slot.level++;
        if (slot.level == 1) {
            slot.start = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        long stop = System.currentTimeMillis();
        Slot slot = this.getSlot();
        if (slot.level == 1) {
            long delta = stop - slot.start;
            Timer timer = this;
            synchronized (timer) {
                this.total += delta;
                ++this.count;
            }
        } else if (slot.level < 1) {
            throw new Error("no matching start");
        }
        slot.level--;
    }

    public long getTotal() {
        return this.total;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return this.total + "/" + this.count;
    }

    static {
        final String name = System.getProperty("timer.out");
        if (name != null && !name.equals("")) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        Timer.dump(name);
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
            });
        }
    }

    private static class Slot {
        private long start;
        private int level;

        private Slot() {
        }
    }
}

