/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.soap.SOAPMessage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.SAMLIssuerFactory;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wssec.SOAPUtil;

public class TestWSSecurityST3
extends TestCase
implements CallbackHandler {
    private static Log log = LogFactory.getLog((Class)(class$wssec$TestWSSecurityST3 == null ? (class$wssec$TestWSSecurityST3 = TestWSSecurityST3.class$("wssec.TestWSSecurityST3")) : class$wssec$TestWSSecurityST3));
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"uri:LogTestService2\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    static final Crypto crypto = CryptoFactory.getInstance("crypto.properties");
    MessageContext msgContext;
    Message message;
    static /* synthetic */ Class class$wssec$TestWSSecurityST3;

    public TestWSSecurityST3(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$wssec$TestWSSecurityST3 == null ? (class$wssec$TestWSSecurityST3 = TestWSSecurityST3.class$("wssec.TestWSSecurityST3")) : class$wssec$TestWSSecurityST3);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestWSSecurityST3.suite());
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient((EngineConfiguration)new NullProvider());
        this.msgContext = new MessageContext((AxisEngine)tmpEngine);
        this.message = this.getSOAPMessage();
    }

    protected Message getSOAPMessage() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message((Object)in);
        msg.setMessageContext(this.msgContext);
        return msg;
    }

    public void testSAMLSignedKeyHolder() throws Exception {
        SOAPEnvelope unsignedEnvelope = this.message.getSOAPEnvelope();
        Object envelope = null;
        Document doc = unsignedEnvelope.getAsDocument();
        SAMLIssuer saml = SAMLIssuerFactory.getInstance("saml4.properties");
        saml.setInstanceDoc(doc);
        saml.setUserCrypto(crypto);
        saml.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        SAMLAssertion assertion = saml.newAssertion();
        WSSignEnvelope wsSign = new WSSignEnvelope();
        wsSign.setKeyIdentifierType(1);
        wsSign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        log.info((Object)"Before SAMLSignedKeyHolder....");
        Document signedDoc = wsSign.build(doc, crypto, assertion, null, null, null);
        log.info((Object)"After SAMLSignedKeyHolder....");
        Message signedMsg = (Message)SOAPUtil.toSOAPMessage(signedDoc);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Signed SAML message (key holder):");
            XMLUtils.PrettyElementToWriter((Element)signedMsg.getSOAPEnvelope().getAsDOM(), (Writer)new PrintWriter(System.out));
        }
        String encryptedString = signedMsg.getSOAPPartAsString();
        signedDoc = signedMsg.getSOAPEnvelope().getAsDocument();
        this.verify(signedDoc);
    }

    private void verify(Document doc) throws Exception {
        secEngine.processSecurityHeader(doc, null, this, crypto);
        SOAPUtil.updateSOAPMessage(doc, (SOAPMessage)this.message);
        String decryptedString = this.message.getSOAPPartAsString();
        TestWSSecurityST3.assertTrue((decryptedString.indexOf("LogTestService2") > 0 ? 1 : 0) != 0);
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("security");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

