/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;

public class WaitableInt
extends SynchronizedInt {
    public WaitableInt(int n) {
        super(n);
    }

    public WaitableInt(int n, Object object) {
        super(n, object);
    }

    public int set(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n2 = super.set(n);
            return n2;
        }
    }

    public boolean commit(int n, int n2) {
        Object object = this.lock_;
        synchronized (object) {
            boolean bl = super.commit(n, n2);
            if (bl) {
                this.lock_.notifyAll();
            }
            boolean bl2 = bl;
            return bl2;
        }
    }

    public int increment() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n = super.increment();
            return n;
        }
    }

    public int decrement() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n = super.decrement();
            return n;
        }
    }

    public int add(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n2 = super.add(n);
            return n2;
        }
    }

    public int subtract(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n2 = super.subtract(n);
            return n2;
        }
    }

    public int multiply(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n2 = super.multiply(n);
            return n2;
        }
    }

    public int divide(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            int n2 = super.divide(n);
            return n2;
        }
    }

    public int complement() {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ ^= 0xFFFFFFFF;
            this.lock_.notifyAll();
            int n = this.value_;
            return n;
        }
    }

    public int and(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ &= n;
            this.lock_.notifyAll();
            int n2 = this.value_;
            return n2;
        }
    }

    public int or(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ |= n;
            this.lock_.notifyAll();
            int n2 = this.value_;
            return n2;
        }
    }

    public int xor(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ ^= n;
            this.lock_.notifyAll();
            int n2 = this.value_;
            return n2;
        }
    }

    public void whenEqual(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenNotEqual(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLessEqual(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ > n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLess(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ >= n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreaterEqual(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ < n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreater(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ <= n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }
}

