/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.lob;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;

public class SerializableBlob
implements Serializable,
Blob {
    private final transient Blob blob;

    public SerializableBlob(Blob blob) {
        this.blob = blob;
    }

    public Blob getWrappedBlob() {
        if (this.blob == null) {
            throw new IllegalStateException("Blobs may not be accessed after serialization");
        }
        return this.blob;
    }

    public long length() throws SQLException {
        return this.getWrappedBlob().length();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        return this.getWrappedBlob().getBytes(pos, length);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getWrappedBlob().getBinaryStream();
    }

    public long position(byte[] pattern, long start) throws SQLException {
        return this.getWrappedBlob().position(pattern, start);
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.getWrappedBlob().position(pattern, start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.getWrappedBlob().setBytes(pos, bytes);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return this.getWrappedBlob().setBytes(pos, bytes, offset, len);
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        return this.getWrappedBlob().setBinaryStream(pos);
    }

    public void truncate(long len) throws SQLException {
        this.getWrappedBlob().truncate(len);
    }
}

