/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.NamingException;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBJ2EEManagedObject;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.api.components.EZBComponentRegistry;
import org.ow2.easybeans.api.injection.EasyBeansInjectionException;
import org.ow2.easybeans.api.injection.ResourceInjector;
import org.ow2.easybeans.api.interceptor.EZBInvocationContextFactory;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBStatisticComponent;
import org.ow2.easybeans.component.itf.TimerComponent;
import org.ow2.easybeans.container.JContainer3;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.naming.NamingManager;
import org.ow2.easybeans.naming.interceptors.ENCManager;
import org.ow2.easybeans.rpc.api.EJBRemoteRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.util.Hash;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.api.PoolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsFactory<PoolType extends EasyBeansBean>
implements Factory<PoolType, Long> {
    private static Log logger = LogFactory.getLog(AbsFactory.class);
    private String className = null;
    private EZBContainer container = null;
    private Pool<PoolType, Long> pool = null;
    private Class<PoolType> beanClass = null;
    private Context javaContext = null;
    private NamingManager namingManager = null;
    private List<ResourceInjector> injectors = null;
    private Map<Long, Method> hashes = null;
    private String id = null;
    private TimerService timerService = null;
    private IEventDispatcher dispatcher = null;
    private String j2eeManagedObjectId = null;
    private EZBInvocationContextFactory invocationContextFactory = null;
    private static InheritableThreadLocal<OperationState> operationStateThreadLocal = new InheritableThreadLocal();

    public AbsFactory(String className, EZBContainer container) throws FactoryException {
        EZBStatisticComponent statisticComponent;
        this.className = className;
        this.container = container;
        this.id = String.valueOf(System.identityHashCode(this));
        this.j2eeManagedObjectId = J2EEManagedObjectNamingHelper.getJ2EEManagedObjectId(this);
        Class<?> clazz = null;
        try {
            clazz = this.getContainer().getClassLoader().loadClass(this.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new FactoryException("Cannot load the class for class name '" + this.getClassName() + "'", (Throwable)e);
        }
        this.setBeanClass(clazz);
        this.setHashes(Hash.hashClass(clazz));
        this.dispatcher = ((JContainer3)this.container).getEventDispatcher();
        EZBEventComponent eventComponent = this.getComponent(EZBEventComponent.class);
        if (eventComponent != null) {
            eventComponent.registerJ2EEManagedObject((EZBJ2EEManagedObject)this, this.dispatcher);
        }
        if ((statisticComponent = this.getComponent(EZBStatisticComponent.class)) != null) {
            statisticComponent.registerJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        try {
            this.namingManager = NamingManager.getInstance();
        }
        catch (NamingException e) {
            throw new FactoryException("Cannot get instance of the naming manager", (Throwable)e);
        }
        this.injectors = container.getConfiguration().getInjectors();
        EZBComponentRegistry registry = container.getConfiguration().getEZBServer().getComponentManager().getComponentRegistry();
        List timerComponents = registry.getComponents(TimerComponent.class);
        if (timerComponents.size() > 0) {
            TimerComponent timerComponent = (TimerComponent)timerComponents.get(0);
            if (timerComponents.size() > 1) {
                logger.warn((Object)"There are {0} timer components running on this server. Only the first one will be used", new Object[]{timerComponents.size()});
            }
            this.timerService = timerComponent.getTimerService((Factory)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(PoolType instance) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            this.preDestroy(instance);
        }
        catch (Exception e) {
            logger.error((Object)"Could not complete preDestroy method on instance", new Object[]{e});
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        for (ResourceInjector injector : this.injectors) {
            try {
                injector.postEasyBeansDestroy(instance);
            }
            catch (Throwable t) {
                logger.error((Object)"postEasyBeansDestroy() for {0} failed", new Object[]{injector.getClass().getName(), t});
            }
        }
    }

    protected void injectResources(PoolType instance) throws PoolException {
        for (ResourceInjector injector : this.injectors) {
            try {
                injector.preEasyBeansInject(instance);
            }
            catch (Throwable t) {
                logger.error((Object)"preEasyBeansInject() for {0} failed", new Object[]{injector.getClass().getName(), t});
            }
        }
        OperationState oldState = this.getOperationState();
        this.getOperationStateThreadLocal().set(OperationState.DEPENDENCY_INJECTION);
        try {
            instance.injectedByEasyBeans();
        }
        catch (EasyBeansInjectionException e) {
            throw new PoolException("Cannot inject resources in the created bean", (Throwable)e);
        }
        finally {
            this.getOperationStateThreadLocal().set(oldState);
        }
        for (ResourceInjector injector : this.injectors) {
            try {
                injector.postEasyBeansInject(instance);
            }
            catch (Throwable t) {
                logger.error((Object)"postEasyBeansInject() for {0} failed", new Object[]{injector.getClass().getName(), t});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preDestroy(PoolType instance) {
        OperationState oldState = this.getOperationState();
        this.getOperationStateThreadLocal().set(OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR);
        try {
            instance.preDestroyEasyBeansLifeCycle();
        }
        finally {
            this.getOperationStateThreadLocal().set(oldState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postConstruct(PoolType instance) {
        OperationState oldState = this.getOperationState();
        this.getOperationStateThreadLocal().set(OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR);
        try {
            instance.postConstructEasyBeansLifeCycle();
        }
        finally {
            this.getOperationStateThreadLocal().set(oldState);
        }
    }

    protected Map<Long, Method> getHashes() {
        return this.hashes;
    }

    protected void setHashes(Map<Long, Method> hashes) {
        this.hashes = hashes;
    }

    public Context getJavaContext() {
        return this.javaContext;
    }

    public void setJavaContext(Context javaContext) {
        if (this.javaContext != null) {
            throw new IllegalStateException("The javaContext can only be set once. Already set !");
        }
        this.javaContext = javaContext;
        ENCManager.initContext(this, javaContext);
    }

    public Class<PoolType> getBeanClass() {
        return this.beanClass;
    }

    protected void setBeanClass(Class<PoolType> beanClass) {
        this.beanClass = beanClass;
    }

    protected void setPool(Pool<PoolType, Long> pool) {
        this.pool = pool;
    }

    public EZBContainer getContainer() {
        return this.container;
    }

    public String getClassName() {
        return this.className;
    }

    protected NamingManager getNamingManager() {
        return this.namingManager;
    }

    public Pool<PoolType, Long> getPool() {
        return this.pool;
    }

    public abstract EJBResponse rpcInvoke(EJBRemoteRequest var1);

    public void init() throws FactoryException {
    }

    public String getId() {
        return this.id;
    }

    public void stop() {
        EZBEventComponent eventComponent;
        ENCManager.removeContext(this);
        EZBStatisticComponent statisticComponent = this.getComponent(EZBStatisticComponent.class);
        if (statisticComponent != null) {
            statisticComponent.unregisterJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        if ((eventComponent = this.getComponent(EZBEventComponent.class)) != null) {
            eventComponent.unregisterJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        this.dispatcher = null;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public <T extends EZBComponent> T getComponent(Class<T> itf) {
        return (T)this.getContainer().getComponent(itf);
    }

    public String getJ2EEManagedObjectId() {
        return this.j2eeManagedObjectId;
    }

    public IEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }

    public List<Method> getLocalInterfaceMethods() {
        LinkedList<Method> methods = new LinkedList<Method>();
        Local localAnnotation = this.getBeanClass().getAnnotation(Local.class);
        if (localAnnotation != null) {
            for (Class localInterface : localAnnotation.value()) {
                for (Method method : localInterface.getDeclaredMethods()) {
                    methods.add(method);
                }
            }
        }
        return methods;
    }

    public List<Method> getRemoteInterfaceMethods() {
        LinkedList<Method> methods = new LinkedList<Method>();
        Remote remoteAnnotation = this.getBeanClass().getAnnotation(Remote.class);
        if (remoteAnnotation != null) {
            for (Class remoteInterface : remoteAnnotation.value()) {
                for (Method method : remoteInterface.getDeclaredMethods()) {
                    methods.add(method);
                }
            }
        }
        return methods;
    }

    public void setInvocationContextFactory(EZBInvocationContextFactory invocationContextFactory) {
        this.invocationContextFactory = invocationContextFactory;
    }

    public EZBInvocationContextFactory getInvocationContextFactory() {
        return this.invocationContextFactory;
    }

    public OperationState getOperationState() {
        return (OperationState)operationStateThreadLocal.get();
    }

    public InheritableThreadLocal<OperationState> getOperationStateThreadLocal() {
        return operationStateThreadLocal;
    }
}

