/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.jmx;

import java.io.InputStream;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ConstructorInfo;
import org.apache.commons.modeler.FieldInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.NotificationInfo;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.ParameterInfo;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class CommonsModelerExtension {
    private CommonsModelerExtension() {
    }

    public static void updateDescriptors(Registry registry, InputStream stream) throws Exception {
        try {
            Document doc = DomUtil.readXml((InputStream)stream);
            Element descriptorsN = doc.getDocumentElement();
            if (descriptorsN == null) {
                return;
            }
            Node firstMbeanN = null;
            firstMbeanN = "mbean".equals(descriptorsN.getNodeName()) ? descriptorsN : DomUtil.getChild((Node)descriptorsN, (String)"mbean");
            if (firstMbeanN == null) {
                return;
            }
            Node mbeanN = firstMbeanN;
            while (mbeanN != null) {
                CommonsModelerExtension.processMBeanNode(registry, mbeanN);
                mbeanN = DomUtil.getNext((Node)mbeanN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processMBeanNode(Registry registry, Node mbeanNode) {
        NamedNodeMap attrs = mbeanNode.getAttributes();
        Node n = attrs.getNamedItem("name");
        String mbeanName = n.getNodeValue();
        ManagedBean managed = registry.findManagedBean(mbeanName);
        DomUtil.setAttributes((Object)managed, (Node)mbeanNode);
        CommonsModelerExtension.processMBeanDescriptorNode(managed, mbeanNode);
        CommonsModelerExtension.processMBeanAttributeNode(managed, mbeanNode);
        CommonsModelerExtension.processMBeanConstructorNode(managed, mbeanNode);
        CommonsModelerExtension.processMBeanNotificationNode(managed, mbeanNode);
        CommonsModelerExtension.processMBeanOperationNode(managed, mbeanNode);
    }

    private static void processMBeanOperationNode(ManagedBean managed, Node mbeanNode) {
        Node firstN;
        Node descN = firstN = DomUtil.getChild((Node)mbeanNode, (String)"operation");
        while (descN != null) {
            Node firstParamN;
            OperationInfo oi = new OperationInfo();
            DomUtil.setAttributes((Object)oi, (Node)descN);
            Node firstDescriptorN = DomUtil.getChild((Node)descN, (String)"descriptor");
            if (firstDescriptorN != null) {
                Node firstFieldN;
                Node fieldN = firstFieldN = DomUtil.getChild((Node)firstDescriptorN, (String)"field");
                while (fieldN != null) {
                    FieldInfo fi = new FieldInfo();
                    DomUtil.setAttributes((Object)fi, (Node)fieldN);
                    oi.addField(fi);
                    fieldN = DomUtil.getNext((Node)fieldN);
                }
            }
            Node paramN = firstParamN = DomUtil.getChild((Node)descN, (String)"parameter");
            while (paramN != null) {
                ParameterInfo pi = new ParameterInfo();
                DomUtil.setAttributes((Object)pi, (Node)paramN);
                oi.addParameter(pi);
                paramN = DomUtil.getNext((Node)paramN);
            }
            managed.addOperation(oi);
            descN = DomUtil.getNext((Node)descN);
        }
    }

    private static void processMBeanNotificationNode(ManagedBean managed, Node mbeanNode) {
        Node firstN;
        Node descN = firstN = DomUtil.getChild((Node)mbeanNode, (String)"notification");
        while (descN != null) {
            Node firstParamN;
            NotificationInfo ni = new NotificationInfo();
            DomUtil.setAttributes((Object)ni, (Node)descN);
            Node firstDescriptorN = DomUtil.getChild((Node)descN, (String)"descriptor");
            if (firstDescriptorN != null) {
                Node firstFieldN;
                Node fieldN = firstFieldN = DomUtil.getChild((Node)firstDescriptorN, (String)"field");
                while (fieldN != null) {
                    FieldInfo fi = new FieldInfo();
                    DomUtil.setAttributes((Object)fi, (Node)fieldN);
                    ni.addField(fi);
                    fieldN = DomUtil.getNext((Node)fieldN);
                }
            }
            Node paramN = firstParamN = DomUtil.getChild((Node)descN, (String)"notification-type");
            while (paramN != null) {
                ni.addNotifType(DomUtil.getContent((Node)paramN));
                paramN = DomUtil.getNext((Node)paramN);
            }
            managed.addNotification(ni);
            descN = DomUtil.getNext((Node)descN);
        }
    }

    private static void processMBeanConstructorNode(ManagedBean managed, Node mbeanNode) {
        Node firstN;
        Node descN = firstN = DomUtil.getChild((Node)mbeanNode, (String)"constructor");
        while (descN != null) {
            Node firstParamN;
            ConstructorInfo ci = new ConstructorInfo();
            DomUtil.setAttributes((Object)ci, (Node)descN);
            Node firstDescriptorN = DomUtil.getChild((Node)descN, (String)"descriptor");
            if (firstDescriptorN != null) {
                Node firstFieldN;
                Node fieldN = firstFieldN = DomUtil.getChild((Node)firstDescriptorN, (String)"field");
                while (fieldN != null) {
                    FieldInfo fi = new FieldInfo();
                    DomUtil.setAttributes((Object)fi, (Node)fieldN);
                    ci.addField(fi);
                    fieldN = DomUtil.getNext((Node)fieldN);
                }
            }
            Node paramN = firstParamN = DomUtil.getChild((Node)descN, (String)"parameter");
            while (paramN != null) {
                ParameterInfo pi = new ParameterInfo();
                DomUtil.setAttributes((Object)pi, (Node)paramN);
                ci.addParameter(pi);
                paramN = DomUtil.getNext((Node)paramN);
            }
            managed.addConstructor(ci);
            descN = DomUtil.getNext((Node)descN);
        }
    }

    private static void processMBeanAttributeNode(ManagedBean managed, Node mbeanNode) {
        Node firstN;
        Node descN = firstN = DomUtil.getChild((Node)mbeanNode, (String)"attribute");
        while (descN != null) {
            AttributeInfo ai = new AttributeInfo();
            DomUtil.setAttributes((Object)ai, (Node)descN);
            Node descriptorN = DomUtil.getChild((Node)descN, (String)"descriptor");
            if (descriptorN != null) {
                Node firstFieldN;
                Node fieldN = firstFieldN = DomUtil.getChild((Node)descriptorN, (String)"field");
                while (fieldN != null) {
                    FieldInfo fi = new FieldInfo();
                    DomUtil.setAttributes((Object)fi, (Node)fieldN);
                    ai.addField(fi);
                    fieldN = DomUtil.getNext((Node)fieldN);
                }
            }
            managed.addAttribute(ai);
            descN = DomUtil.getNext((Node)descN);
        }
    }

    private static void processMBeanDescriptorNode(ManagedBean managed, Node mbeanNode) {
        Node mbeanDescriptorN = DomUtil.getChild((Node)mbeanNode, (String)"descriptor");
        if (mbeanDescriptorN != null) {
            Node firstFieldN;
            Node fieldN = firstFieldN = DomUtil.getChild((Node)mbeanDescriptorN, (String)"field");
            while (fieldN != null) {
                FieldInfo fi = new FieldInfo();
                DomUtil.setAttributes((Object)fi, (Node)fieldN);
                managed.addField(fi);
                fieldN = DomUtil.getNext((Node)fieldN);
            }
        }
    }
}

