/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.info.mapping;

import net.jcip.annotations.NotThreadSafe;
import org.ow2.cmi.info.mapping.PropertiesInfo;
import org.ow2.util.pool.api.IPoolConfiguration;

@NotThreadSafe
public final class Cluster {
    private String objectName;
    private String clusterName = "defaultCluster";
    private boolean proxyEnabled = true;
    private String policyType;
    private String strategyType;
    private PropertiesInfo propertiesInfo;
    private IPoolConfiguration poolConfiguration = null;

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }

    public PropertiesInfo getPropertiesInfo() {
        return this.propertiesInfo;
    }

    public void setPropertiesInfo(PropertiesInfo propertiesInfo) {
        this.propertiesInfo = propertiesInfo;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public String getStrategyType() {
        return this.strategyType;
    }

    public void setStrategyType(String strategyType) {
        this.strategyType = strategyType;
    }

    public IPoolConfiguration getPoolConfiguration() {
        return this.poolConfiguration;
    }

    public void setPoolConfiguration(IPoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
    }

    public String toString() {
        return "ClusteredObject[objectName:" + this.objectName + ",clusterName:" + this.clusterName + ",proxyEnabled:" + this.proxyEnabled + ",policyType:" + this.policyType + ",strategyType:" + this.strategyType + ",propertiesInfo:" + this.propertiesInfo + ",poolConfiguration:" + this.poolConfiguration + "]";
    }

    public String jonasClusterToXml() {
        StringBuffer buff = new StringBuffer();
        this.writeValue(this.clusterName, buff, "<name>", "</name>");
        this.writeValue(this.policyType, buff, "<policy>", "</policy>");
        this.writeValue(this.strategyType, buff, "<strategy>", "</strategy>");
        this.writePoolToXml(buff, 2);
        return buff.toString();
    }

    private void writePoolToXml(StringBuffer buff, int indent) {
        buff.append(indent);
        if (this.poolConfiguration != null) {
            this.writeValue(new Integer(this.poolConfiguration.getMax()).toString(), buff, "<max-size>", "</max-size>");
            this.writeValue(new Integer(this.poolConfiguration.getMaxWaiters()).toString(), buff, "<max-waiters>", "</max-waiters>");
            this.writeValue(new Long(this.poolConfiguration.getTimeout()).toString(), buff, "<timeout>", "</timeout>");
        }
    }

    private void writeValue(String value, StringBuffer buff, String openingTag, String closingTag) {
        if (value != null) {
            buff.append(openingTag);
            buff.append(value);
            buff.append(closingTag);
        }
    }

    protected String indent(int indent) {
        String txt = "";
        for (int i = 0; i < indent; ++i) {
            txt = txt + " ";
        }
        return txt;
    }
}

