/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelTest
extends ChannelTestBase {
    Channel ch;
    private static final String GROUP = "DiscardTestGroup";
    boolean receivedViewWhenDisconnected;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ch = this.createChannel();
        this.ch.connect(GROUP);
    }

    @Override
    public void tearDown() throws Exception {
        this.ch.close();
        super.tearDown();
    }

    public void testBasicOperations() throws Exception {
        String groupName = GROUP;
        JChannel c1 = this.createChannel("A");
        ((Channel)c1).connect(groupName);
        Util.sleep(1000L);
        ChannelTest.assertTrue((boolean)((Channel)c1).isOpen());
        ChannelTest.assertTrue((boolean)((Channel)c1).isConnected());
        ChannelTest.assertNotNull((Object)((Channel)c1).getLocalAddress());
        ChannelTest.assertNotNull((Object)((Channel)c1).getView());
        ChannelTest.assertTrue((boolean)((Channel)c1).getView().getMembers().contains(((Channel)c1).getLocalAddress()));
        try {
            ((Channel)c1).connect(groupName);
        }
        catch (Exception e) {
            ChannelTest.fail((String)"Should have NOT generated exception");
        }
        ((Channel)c1).disconnect();
        ChannelTest.assertFalse((boolean)((Channel)c1).isConnected());
        ChannelTest.assertTrue((boolean)((Channel)c1).isOpen());
        ChannelTest.assertNull((Object)((Channel)c1).getLocalAddress());
        ChannelTest.assertNull((Object)((Channel)c1).getView());
        ChannelTest.assertNull((Object)((Channel)c1).getClusterName());
        try {
            ((Channel)c1).connect(groupName);
        }
        catch (Exception e) {
            ChannelTest.fail((String)"Should have NOT generated exception");
        }
        ((Channel)c1).close();
        try {
            ((Channel)c1).connect(groupName);
            ChannelTest.fail((String)"Should generated exception, and it has NOT");
        }
        catch (Exception e) {
            ChannelTest.assertTrue((boolean)(e instanceof ChannelClosedException));
        }
        ChannelTest.assertFalse((boolean)((Channel)c1).isConnected());
        ChannelTest.assertFalse((boolean)((Channel)c1).isOpen());
        ChannelTest.assertNull((Object)((Channel)c1).getLocalAddress());
        ChannelTest.assertNull((Object)((Channel)c1).getView());
        ChannelTest.assertNull((Object)((Channel)c1).getClusterName());
        c1 = this.createChannel("A");
        ((Channel)c1).connect(groupName);
        JChannel c2 = this.createChannel("A");
        ((Channel)c2).connect(groupName);
        Util.sleep(1000L);
        ChannelTest.assertTrue((boolean)((Channel)c1).isOpen());
        ChannelTest.assertTrue((boolean)((Channel)c1).isConnected());
        ChannelTest.assertNotNull((Object)((Channel)c1).getLocalAddress());
        ChannelTest.assertNotNull((Object)((Channel)c1).getView());
        ChannelTest.assertTrue((boolean)((Channel)c1).getView().getMembers().contains(((Channel)c1).getLocalAddress()));
        ChannelTest.assertTrue((boolean)((Channel)c1).getView().getMembers().contains(((Channel)c2).getLocalAddress()));
        ChannelTest.assertTrue((boolean)((Channel)c2).isOpen());
        ChannelTest.assertTrue((boolean)((Channel)c2).isConnected());
        ChannelTest.assertNotNull((Object)((Channel)c2).getLocalAddress());
        ChannelTest.assertNotNull((Object)((Channel)c2).getView());
        ChannelTest.assertTrue((boolean)((Channel)c2).getView().getMembers().contains(((Channel)c2).getLocalAddress()));
        ChannelTest.assertTrue((boolean)((Channel)c2).getView().getMembers().contains(((Channel)c1).getLocalAddress()));
        ((Channel)c2).close();
        Util.sleep(1000L);
        ChannelTest.assertFalse((boolean)((Channel)c2).isOpen());
        ChannelTest.assertFalse((boolean)((Channel)c2).isConnected());
        ChannelTest.assertNull((Object)((Channel)c2).getLocalAddress());
        ChannelTest.assertNull((Object)((Channel)c2).getView());
        ChannelTest.assertTrue((boolean)((Channel)c1).isOpen());
        ChannelTest.assertTrue((boolean)((Channel)c1).isConnected());
        ChannelTest.assertNotNull((Object)((Channel)c1).getLocalAddress());
        ChannelTest.assertNotNull((Object)((Channel)c1).getView());
        ChannelTest.assertTrue((boolean)((Channel)c1).getView().getMembers().contains(((Channel)c1).getLocalAddress()));
        ChannelTest.assertFalse((boolean)((Channel)c1).getView().getMembers().contains(((Channel)c2).getLocalAddress()));
        ((Channel)c1).close();
    }

    public void testFirstView() throws Exception {
        Object obj = this.ch.receive(5000L);
        if (!(obj instanceof View)) {
            ChannelTest.fail((String)("first object returned needs to be a View (was " + obj + ")"));
        } else {
            System.out.println("view is " + obj);
        }
    }

    public void testViewChange() throws Exception {
        ViewChecker checker = new ViewChecker(this.ch);
        this.ch.setReceiver(checker);
        JChannel ch2 = this.createChannel();
        ((Channel)ch2).connect(GROUP);
        ChannelTest.assertTrue((String)checker.getReason(), (boolean)checker.isSuccess());
        ((Channel)ch2).close();
        ChannelTest.assertTrue((String)checker.getReason(), (boolean)checker.isSuccess());
    }

    public void testIsConnectedOnFirstViewChange() throws Exception {
        JChannel ch2 = this.createChannel();
        ConnectedChecker tmp = new ConnectedChecker(ch2);
        ch2.setReceiver(tmp);
        ((Channel)ch2).connect(GROUP);
        ChannelTest.assertFalse((boolean)tmp.isConnected());
        ((Channel)ch2).close();
    }

    public void testNoViewIsReceivedAferDisconnect() throws Exception {
        final JChannel ch2 = this.createChannel();
        ReceiverAdapter ra = new ReceiverAdapter(){

            public void viewAccepted(View new_view) {
                ChannelTest.this.receivedViewWhenDisconnected = !new_view.containsMember(ch2.getLocalAddress());
            }
        };
        ch2.setReceiver(ra);
        ((Channel)ch2).connect(GROUP);
        Util.sleep(1000L);
        ((Channel)ch2).disconnect();
        Util.sleep(1000L);
        ChannelTest.assertFalse((String)"Received view where not member", (boolean)this.receivedViewWhenDisconnected);
        ((Channel)ch2).close();
    }

    public void testNoViewIsReceivedAferClose() throws Exception {
        final JChannel ch2 = this.createChannel();
        ReceiverAdapter ra = new ReceiverAdapter(){

            public void viewAccepted(View new_view) {
                ChannelTest.this.receivedViewWhenDisconnected = !new_view.containsMember(ch2.getLocalAddress());
            }
        };
        ch2.setReceiver(ra);
        ((Channel)ch2).connect(GROUP);
        Util.sleep(1000L);
        ((Channel)ch2).close();
        Util.sleep(1000L);
        ChannelTest.assertFalse((String)"Received view where not member", (boolean)this.receivedViewWhenDisconnected);
    }

    public void testReceiveTimeout() throws ChannelException, TimeoutException {
        this.ch.receive(1000L);
        try {
            this.ch.receive(2000L);
        }
        catch (ChannelNotConnectedException e) {
            ChannelTest.fail((String)"channel should be connected");
        }
        catch (ChannelClosedException e) {
            ChannelTest.fail((String)"channel should not be closed");
        }
        catch (TimeoutException e) {
            System.out.println("caught a TimeoutException - this is the expected behavior");
        }
    }

    public void testNullMessage() throws ChannelClosedException, ChannelNotConnectedException {
        try {
            this.ch.send(null);
            ChannelTest.fail((String)"null message should throw an exception - we should not get here");
        }
        catch (NullPointerException e) {
            System.out.println("caught NullPointerException - this is expected");
        }
    }

    public void testOrdering() throws Exception {
        int NUM = 100;
        MyReceiver receiver = new MyReceiver(100);
        this.ch.setReceiver(receiver);
        for (int i = 1; i <= 100; ++i) {
            this.ch.send(new Message(null, null, new Integer(i)));
            System.out.println("-- sent " + i);
        }
        receiver.waitForCompletion();
        List<Integer> nums = receiver.getNums();
        ChannelTest.checkMonotonicallyIncreasingNumbers(nums);
    }

    private static void checkMonotonicallyIncreasingNumbers(List<Integer> nums) {
        int current = -1;
        for (int num : nums) {
            if (current < 0) {
                current = num;
                continue;
            }
            ChannelTest.assertEquals((String)("list is " + nums), (int)(++current), (int)num);
        }
    }

    public static Test suite() {
        return new TestSuite(ChannelTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ChannelTest.suite());
    }

    private static class ViewChecker
    extends ReceiverAdapter {
        final Channel channel;
        boolean success = true;
        String reason = "";

        public ViewChecker(Channel channel) {
            this.channel = channel;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void viewAccepted(View new_view) {
            View view = this.channel.getView();
            String str = "viewAccepted(): channel's view=" + view + "\nreceived view=" + new_view;
            System.out.println(str);
            if (!view.equals(new_view)) {
                this.success = false;
                this.reason = this.reason + str + "\n";
            }
        }
    }

    private static class ConnectedChecker
    extends ReceiverAdapter {
        boolean connected = false;
        final Channel channel;

        public ConnectedChecker(Channel channel) {
            this.channel = channel;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public void viewAccepted(View new_view) {
            this.connected = this.channel.isConnected();
            System.out.println("ConnectedChecker: channel.isConnected()=" + this.connected + ", view=" + new_view);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        final List<Integer> nums = new LinkedList<Integer>();
        final int expected;

        public MyReceiver(int expected) {
            this.expected = expected;
        }

        public List<Integer> getNums() {
            return this.nums;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() throws InterruptedException {
            List<Integer> list = this.nums;
            synchronized (list) {
                while (this.nums.size() < this.expected) {
                    this.nums.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            Util.sleepRandom(100L);
            Integer num = (Integer)msg.getObject();
            List<Integer> list = this.nums;
            synchronized (list) {
                System.out.println("-- received " + num);
                this.nums.add(num);
                if (this.nums.size() >= this.expected) {
                    this.nums.notifyAll();
                }
            }
            Util.sleepRandom(100L);
        }
    }
}

