/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.HashMap;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Session;

public class JPAQuery
extends DatabaseQuery {
    private String jpqlString;
    private Boolean flushOnExecute;
    private HashMap hints;

    public JPAQuery() {
    }

    public JPAQuery(String jpqlString) {
        this.jpqlString = jpqlString;
    }

    public JPAQuery(String name, String jpqlString, HashMap hints) {
        this.name = name;
        this.jpqlString = jpqlString;
        this.flushOnExecute = null;
        this.hints = hints;
    }

    public JPAQuery(String name, String jpqlString, Boolean flushOnExecute, HashMap hints) {
        this.name = name;
        this.jpqlString = jpqlString;
        this.flushOnExecute = flushOnExecute;
        this.hints = hints;
    }

    public String getJPQLString() {
        return this.jpqlString;
    }

    public void setJPQLString(String jpqlString) {
        this.jpqlString = jpqlString;
    }

    public HashMap getHints() {
        return this.hints;
    }

    public void setHints(HashMap hints) {
        this.hints = hints;
    }

    public DatabaseQuery processJPQLQuery(Session session) {
        ClassLoader classloader = session.getDatasourcePlatform().getConversionManager().getLoader();
        DatabaseQuery ejbquery = EJBQueryImpl.buildEJBQLDatabaseQuery(this.getName(), this.jpqlString, this.flushOnExecute, session, this.hints, classloader);
        ejbquery.setName(this.getName());
        return ejbquery;
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        DatabaseQuery ejbquery = this.processJPQLQuery(this.getSession());
        return ejbquery.executeDatabaseQuery();
    }
}

