/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.tx;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class TransactionValve
extends ValveBase {
    private Log logger = LogFactory.getLog(TransactionValve.class);
    private TransactionManager transactionmanager = null;

    public TransactionValve(TransactionManager transactionManager) {
        this.transactionmanager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Transaction txAfterMethod2;
        Transaction existingTransaction = null;
        try {
            existingTransaction = this.transactionmanager.getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Unable to check if there is a transaction", e);
        }
        try {
            this.getNext().invoke(request, response);
            Object var6_5 = null;
            if (existingTransaction != null) return;
            txAfterMethod2 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (existingTransaction != null) throw throwable;
            Transaction txAfterMethod2 = null;
            try {
                txAfterMethod2 = this.transactionmanager.getTransaction();
            }
            catch (SystemException e) {
                throw new IllegalStateException("Unable to check if there is a transaction", e);
            }
            if (txAfterMethod2 == null) throw throwable;
            int transactionStatus = 0;
            try {
                transactionStatus = txAfterMethod2.getStatus();
                if (transactionStatus == 3) throw throwable;
                String errMsg = "Transaction started in the servlet '" + request.getServletPath() + "' but not committed. Rolling back...";
                this.logger.error((Object)errMsg, new Object[0]);
                txAfterMethod2.rollback();
                throw throwable;
            }
            catch (SystemException e) {
                throw new IllegalStateException("Cannot rollback transaction", e);
            }
        }
        try {
            txAfterMethod2 = this.transactionmanager.getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Unable to check if there is a transaction", e);
        }
        if (txAfterMethod2 == null) return;
        int transactionStatus = 0;
        try {
            transactionStatus = txAfterMethod2.getStatus();
            if (transactionStatus == 3) return;
            String errMsg = "Transaction started in the servlet '" + request.getServletPath() + "' but not committed. Rolling back...";
            this.logger.error((Object)errMsg, new Object[0]);
            txAfterMethod2.rollback();
            return;
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot rollback transaction", e);
        }
    }
}

