/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

class NewStackTraceErrorHandler
implements ErrorHandler {
    protected boolean valid = true;
    private StringBuffer buffer = new StringBuffer();
    private int numErrors = 0;
    private List<SAXParseException> errors = new ArrayList<SAXParseException>();

    NewStackTraceErrorHandler() {
    }

    public void error(SAXParseException ex) throws SAXParseException {
        this.addError(ex);
    }

    public void fatalError(SAXParseException ex) {
        this.addError(ex);
    }

    public void warning(SAXParseException ex) {
    }

    boolean isValid() {
        return this.valid;
    }

    int getTotalErrors() {
        return this.numErrors;
    }

    String getErrorMessages() {
        return this.buffer.toString();
    }

    SAXParseException[] getErrors() {
        if (this.errors == null) {
            return null;
        }
        return this.errors.toArray(new SAXParseException[this.errors.size()]);
    }

    void addError(String msg, SAXParseException ex) {
        this.valid = false;
        if (this.numErrors == 0) {
            this.buffer.append("\n");
        } else {
            this.buffer.append("\n\n");
        }
        this.buffer.append(msg);
        ++this.numErrors;
        this.errors.add(ex);
    }

    private String getErrorMessage(SAXParseException ex) {
        return "line " + ex.getLineNumber() + " column " + ex.getColumnNumber() + " of " + ex.getSystemId() + ": " + ex.getMessage();
    }

    private void addError(SAXParseException ex) {
        this.addError(this.getErrorMessage(ex), ex);
    }
}

