/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.felix.dependencymanager.ConfigurationDependency;
import org.apache.felix.dependencymanager.DefaultNullObject;
import org.apache.felix.dependencymanager.Dependency;
import org.apache.felix.dependencymanager.Logger;
import org.apache.felix.dependencymanager.SerialExecutor;
import org.apache.felix.dependencymanager.Service;
import org.apache.felix.dependencymanager.ServiceDependency;
import org.apache.felix.dependencymanager.ServiceRegistrationImpl;
import org.apache.felix.dependencymanager.ServiceStateListener;
import org.apache.felix.dependencymanager.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ServiceImpl
implements Service {
    private static final Class[] VOID = new Class[0];
    private static final ServiceRegistration NULL_REGISTRATION;
    private static final ServiceStateListener[] SERVICE_STATE_LISTENER_TYPE;
    private final BundleContext m_context;
    private String m_callbackInit;
    private String m_callbackStart;
    private String m_callbackStop;
    private String m_callbackDestroy;
    private Object m_serviceName;
    private Object m_implementation;
    private Dictionary m_serviceProperties;
    private ArrayList m_dependencies = new ArrayList();
    private State m_state;
    private Object m_serviceInstance;
    private ServiceRegistration m_registration;
    private final List m_stateListeners = new ArrayList();
    private final SerialExecutor m_executor = new SerialExecutor();
    private Object m_instanceFactory;
    private String m_instanceFactoryCreateMethod;
    private Object m_compositionManager;
    private String m_compositionManagerGetMethod;
    private Object m_compositionManagerInstance;
    private final Logger m_logger;
    static /* synthetic */ Class class$org$osgi$framework$BundleContext;
    static /* synthetic */ Class class$org$osgi$framework$ServiceRegistration;
    static /* synthetic */ Class class$org$apache$felix$dependencymanager$ServiceImpl;

    public ServiceImpl(BundleContext context, Logger logger) {
        this.m_logger = logger;
        this.m_state = new State((List)this.m_dependencies.clone(), false);
        this.m_context = context;
        this.m_callbackInit = "init";
        this.m_callbackStart = "start";
        this.m_callbackStop = "stop";
        this.m_callbackDestroy = "destroy";
        this.m_implementation = null;
    }

    private void calculateStateChanges(final State oldState, final State newState) {
        if (oldState.isWaitingForRequired() && newState.isTrackingOptional()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ServiceImpl.this.activateService(newState);
                }
            });
        }
        if (oldState.isTrackingOptional() && newState.isWaitingForRequired()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ServiceImpl.this.deactivateService(oldState);
                }
            });
        }
        if (oldState.isInactive() && newState.isTrackingOptional()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ServiceImpl.this.activateService(newState);
                }
            });
        }
        if (oldState.isInactive() && newState.isWaitingForRequired()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ServiceImpl.this.startTrackingRequired(newState);
                }
            });
        }
        if (oldState.isWaitingForRequired() && newState.isInactive()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ServiceImpl.this.stopTrackingRequired(oldState);
                }
            });
        }
        if (oldState.isTrackingOptional() && newState.isInactive()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ServiceImpl.this.deactivateService(oldState);
                    ServiceImpl.this.stopTrackingRequired(oldState);
                }
            });
        }
        this.m_executor.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service add(Dependency dependency) {
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_dependencies.add(dependency);
        }
        if (oldState.isTrackingOptional() || oldState.isWaitingForRequired() && dependency.isRequired()) {
            dependency.start(this);
        }
        arrayList = this.m_dependencies;
        synchronized (arrayList) {
            State newState;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive());
            this.calculateStateChanges(oldState, newState);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service remove(Dependency dependency) {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_dependencies.remove(dependency);
        }
        if (oldState.isTrackingOptional() || oldState.isWaitingForRequired() && dependency.isRequired()) {
            dependency.stop(this);
        }
        arrayList = this.m_dependencies;
        synchronized (arrayList) {
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive());
        }
        this.calculateStateChanges(oldState, newState);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDependencies() {
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            return (List)this.m_dependencies.clone();
        }
    }

    public ServiceRegistration getServiceRegistration() {
        return this.m_registration;
    }

    public Object getService() {
        return this.m_serviceInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dependencyAvailable(final Dependency dependency) {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive());
        }
        this.calculateStateChanges(oldState, newState);
        if (newState.isTrackingOptional()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ServiceImpl.this.updateInstance(dependency);
                }
            });
            this.m_executor.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dependencyChanged(final Dependency dependency) {
        State state;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            state = this.m_state;
        }
        if (state.isTrackingOptional()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ServiceImpl.this.updateInstance(dependency);
                }
            });
            this.m_executor.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dependencyUnavailable(final Dependency dependency) {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive());
        }
        this.calculateStateChanges(oldState, newState);
        if (newState.isTrackingOptional()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ServiceImpl.this.updateInstance(dependency);
                }
            });
            this.m_executor.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), true);
        }
        this.calculateStateChanges(oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), false);
        }
        this.calculateStateChanges(oldState, newState);
    }

    public synchronized Service setInterface(String serviceName, Dictionary properties) {
        this.ensureNotActive();
        this.m_serviceName = serviceName;
        this.m_serviceProperties = properties;
        return this;
    }

    public synchronized Service setInterface(String[] serviceName, Dictionary properties) {
        this.ensureNotActive();
        this.m_serviceName = serviceName;
        this.m_serviceProperties = properties;
        return this;
    }

    public synchronized Service setCallbacks(String init, String start, String stop, String destroy) {
        this.ensureNotActive();
        this.m_callbackInit = init;
        this.m_callbackStart = start;
        this.m_callbackStop = stop;
        this.m_callbackDestroy = destroy;
        return this;
    }

    public synchronized Service setImplementation(Object implementation) {
        this.ensureNotActive();
        this.m_implementation = implementation;
        return this;
    }

    public synchronized Service setFactory(Object factory, String createMethod) {
        this.ensureNotActive();
        this.m_instanceFactory = factory;
        this.m_instanceFactoryCreateMethod = createMethod;
        return this;
    }

    public synchronized Service setFactory(String createMethod) {
        return this.setFactory(null, createMethod);
    }

    public synchronized Service setComposition(Object instance, String getMethod) {
        this.ensureNotActive();
        this.m_compositionManager = instance;
        this.m_compositionManagerGetMethod = getMethod;
        return this;
    }

    public synchronized Service setComposition(String getMethod) {
        return this.setComposition(null, getMethod);
    }

    public String toString() {
        return "ServiceImpl[" + this.m_serviceName + " " + this.m_implementation + "]";
    }

    public synchronized Dictionary getServiceProperties() {
        if (this.m_serviceProperties != null) {
            return (Dictionary)((Hashtable)this.m_serviceProperties).clone();
        }
        return null;
    }

    public synchronized void setServiceProperties(Dictionary serviceProperties) {
        this.m_serviceProperties = serviceProperties;
        if (this.isRegistered() && this.m_serviceName != null) {
            this.m_registration.setProperties(this.calculateServiceProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(ServiceStateListener listener) {
        State state;
        List list = this.m_stateListeners;
        synchronized (list) {
            this.m_stateListeners.add(listener);
        }
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            state = this.m_state;
        }
        if (state.isTrackingOptional()) {
            listener.starting(this);
            listener.started(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(ServiceStateListener listener) {
        List list = this.m_stateListeners;
        synchronized (list) {
            this.m_stateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStateListeners() {
        List list = this.m_stateListeners;
        synchronized (list) {
            this.m_stateListeners.clear();
        }
    }

    private void stateListenersStarting() {
        ServiceStateListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            try {
                list[i].starting(this);
                continue;
            }
            catch (Throwable t) {
                this.m_logger.log(1, "Error invoking listener starting method.", t);
            }
        }
    }

    private void stateListenersStarted() {
        ServiceStateListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            try {
                list[i].started(this);
                continue;
            }
            catch (Throwable t) {
                this.m_logger.log(1, "Error invoking listener started method.", t);
            }
        }
    }

    private void stateListenersStopping() {
        ServiceStateListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            try {
                list[i].stopping(this);
                continue;
            }
            catch (Throwable t) {
                this.m_logger.log(1, "Error invoking listener stopping method.", t);
            }
        }
    }

    private void stateListenersStopped() {
        ServiceStateListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            try {
                list[i].stopped(this);
                continue;
            }
            catch (Throwable t) {
                this.m_logger.log(1, "Error invoking listener stopped method.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceStateListener[] getListeners() {
        List list = this.m_stateListeners;
        synchronized (list) {
            return this.m_stateListeners.toArray(SERVICE_STATE_LISTENER_TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateService(State state) {
        String start;
        String init;
        ServiceImpl serviceImpl = this;
        synchronized (serviceImpl) {
            init = this.m_callbackInit;
            start = this.m_callbackStart;
        }
        this.initService();
        this.invoke(init);
        this.configureService(state);
        this.stateListenersStarting();
        this.startTrackingOptional(state);
        this.invoke(start);
        this.registerService();
        this.stateListenersStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateService(State state) {
        String destroy;
        String stop;
        ServiceImpl serviceImpl = this;
        synchronized (serviceImpl) {
            stop = this.m_callbackStop;
            destroy = this.m_callbackDestroy;
        }
        this.stateListenersStopping();
        this.unregisterService();
        this.invoke(stop);
        this.stopTrackingOptional(state);
        this.stateListenersStopped();
        this.invoke(destroy);
        this.destroyService(state);
    }

    private void invoke(String name) {
        if (name != null) {
            try {
                for (Class<?> clazz = this.m_serviceInstance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        Method method = clazz.getDeclaredMethod(name, null);
                        if (method == null) continue;
                        method.setAccessible(true);
                        try {
                            method.invoke(this.m_serviceInstance, null);
                        }
                        catch (InvocationTargetException e) {
                            this.m_logger.log(1, "Exception while invoking method " + method + ".", e);
                        }
                        return;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                this.m_logger.log(1, "Error trying to invoke method named " + name + ".", e);
            }
        }
    }

    private void startTrackingOptional(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (dependency.isRequired()) continue;
            dependency.start(this);
        }
    }

    private void stopTrackingOptional(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (dependency.isRequired()) continue;
            dependency.stop(this);
        }
    }

    private void startTrackingRequired(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (!dependency.isRequired()) continue;
            dependency.start(this);
        }
    }

    private void stopTrackingRequired(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (!dependency.isRequired()) continue;
            dependency.stop(this);
        }
    }

    private Object createInstance(Class clazz) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Constructor constructor = clazz.getConstructor(VOID);
        constructor.setAccessible(true);
        return clazz.newInstance();
    }

    void initService() {
        if (this.m_serviceInstance == null) {
            if (this.m_implementation instanceof Class) {
                try {
                    this.m_serviceInstance = this.createInstance((Class)this.m_implementation);
                }
                catch (Exception e) {
                    this.m_logger.log(1, "Could not create service instance of class " + this.m_implementation + ".", e);
                }
            } else {
                if (this.m_instanceFactoryCreateMethod != null) {
                    Object factory = null;
                    if (this.m_instanceFactory != null) {
                        if (this.m_instanceFactory instanceof Class) {
                            try {
                                factory = this.createInstance((Class)this.m_instanceFactory);
                            }
                            catch (Exception e) {
                                this.m_logger.log(1, "Could not create factory instance of class " + this.m_instanceFactory + ".", e);
                            }
                        } else {
                            factory = this.m_instanceFactory;
                        }
                    }
                    if (factory == null) {
                        this.m_logger.log(1, "Factory cannot be null.");
                    }
                    try {
                        Method m = factory.getClass().getDeclaredMethod(this.m_instanceFactoryCreateMethod, null);
                        this.m_serviceInstance = m.invoke(factory, null);
                    }
                    catch (Exception e) {
                        this.m_logger.log(1, "Could not create service instance using factory " + factory + " method " + this.m_instanceFactoryCreateMethod + ".", e);
                    }
                }
                if (this.m_implementation == null) {
                    this.m_logger.log(1, "Implementation cannot be null.");
                }
                if (this.m_serviceInstance == null) {
                    this.m_serviceInstance = this.m_implementation;
                }
            }
            this.configureImplementation(class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = ServiceImpl.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext, this.m_context);
            this.configureImplementation(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ServiceImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration, NULL_REGISTRATION);
        }
    }

    private void configureService(State state) {
        this.configureServices(state);
    }

    private void destroyService(State state) {
        this.unconfigureServices(state);
        this.m_serviceInstance = null;
    }

    private void registerService() {
        if (this.m_serviceName != null) {
            ServiceRegistrationImpl wrapper = new ServiceRegistrationImpl();
            this.m_registration = wrapper;
            this.configureImplementation(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ServiceImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration, wrapper);
            Dictionary properties = this.calculateServiceProperties();
            try {
                ServiceRegistration registration = this.m_serviceName instanceof String ? this.m_context.registerService((String)this.m_serviceName, this.m_serviceInstance, properties) : this.m_context.registerService((String[])this.m_serviceName, this.m_serviceInstance, properties);
                wrapper.setServiceRegistration(registration);
            }
            catch (IllegalArgumentException iae) {
                wrapper.setIllegalState();
            }
        }
    }

    private Dictionary calculateServiceProperties() {
        Properties properties = new Properties();
        this.addTo(properties, this.m_serviceProperties);
        for (int i = 0; i < this.m_dependencies.size(); ++i) {
            ConfigurationDependency cd;
            Dependency d = (Dependency)this.m_dependencies.get(i);
            if (!(d instanceof ConfigurationDependency) || !(cd = (ConfigurationDependency)d).isPropagated()) continue;
            Dictionary dict = cd.getConfiguration();
            this.addTo(properties, dict);
        }
        if (((Dictionary)properties).size() == 0) {
            properties = null;
        }
        return properties;
    }

    private void addTo(Dictionary properties, Dictionary additional) {
        if (properties == null) {
            throw new IllegalArgumentException("Dictionary to add to cannot be null.");
        }
        if (additional != null) {
            Enumeration e = additional.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                properties.put(key, additional.get(key));
            }
        }
    }

    private void unregisterService() {
        if (this.m_serviceName != null) {
            this.m_registration.unregister();
            this.configureImplementation(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ServiceImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration, NULL_REGISTRATION);
        }
    }

    private void updateInstance(Dependency dependency) {
        ConfigurationDependency cd;
        if (dependency instanceof ServiceDependency) {
            ServiceDependency sd = (ServiceDependency)dependency;
            if (sd.isAutoConfig()) {
                this.configureImplementation(sd.getInterface(), sd.getService());
            }
        } else if (dependency instanceof ConfigurationDependency && (cd = (ConfigurationDependency)dependency).isPropagated()) {
            Dictionary props = this.calculateServiceProperties();
            this.m_registration.setProperties(props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureImplementation(Class clazz, Object instance) {
        Object[] instances = null;
        if (this.m_compositionManagerGetMethod != null) {
            this.m_compositionManagerInstance = this.m_compositionManager != null ? this.m_compositionManager : this.m_serviceInstance;
            if (this.m_compositionManagerInstance != null) {
                try {
                    Method m = this.m_compositionManagerInstance.getClass().getDeclaredMethod(this.m_compositionManagerGetMethod, null);
                    m.setAccessible(true);
                    instances = (Object[])m.invoke(this.m_compositionManagerInstance, null);
                }
                catch (Exception e) {
                    this.m_logger.log(1, "Could not obtain instances from the composition manager.", e);
                    return;
                }
            }
        } else {
            instances = new Object[]{this.m_serviceInstance};
        }
        if (instances != null) {
            for (int i = 0; i < instances.length; ++i) {
                Object serviceInstance = instances[i];
                for (Class<?> serviceClazz = serviceInstance.getClass(); serviceClazz != null; serviceClazz = serviceClazz.getSuperclass()) {
                    Field[] fields = serviceClazz.getDeclaredFields();
                    for (int j = 0; j < fields.length; ++j) {
                        if (!fields[j].getType().equals(clazz)) continue;
                        try {
                            fields[j].setAccessible(true);
                            Object object = new Object();
                            synchronized (object) {
                                fields[j].set(serviceInstance, instance);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            this.m_logger.log(1, "Could not set field " + fields[j], e);
                            return;
                        }
                    }
                }
            }
        }
    }

    private void configureServices(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (!(dependency instanceof ServiceDependency)) continue;
            ServiceDependency sd = (ServiceDependency)dependency;
            if (sd.isAutoConfig()) {
                this.configureImplementation(sd.getInterface(), sd.getService());
            }
            if (!sd.isRequired()) continue;
            sd.invokeAdded();
        }
    }

    private void unconfigureServices(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            ServiceDependency sd;
            Dependency dependency = (Dependency)i.next();
            if (!(dependency instanceof ServiceDependency) || !(sd = (ServiceDependency)dependency).isRequired()) continue;
            sd.invokeRemoved();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNotActive() {
        State state;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            state = this.m_state;
        }
        if (!state.isInactive()) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRegistered() {
        State state;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            state = this.m_state;
        }
        return state.isTrackingOptional();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SERVICE_STATE_LISTENER_TYPE = new ServiceStateListener[0];
        NULL_REGISTRATION = (ServiceRegistration)Proxy.newProxyInstance((class$org$apache$felix$dependencymanager$ServiceImpl == null ? (class$org$apache$felix$dependencymanager$ServiceImpl = ServiceImpl.class$("org.apache.felix.dependencymanager.ServiceImpl")) : class$org$apache$felix$dependencymanager$ServiceImpl).getClassLoader(), new Class[]{class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ServiceImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration}, (InvocationHandler)new DefaultNullObject());
    }
}

