/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.ha;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.jndi2.distributed.ReplicationEntryPoint;
import fr.dyade.aaa.jndi2.distributed.ReplicationManager;
import fr.dyade.aaa.jndi2.ha.HAEntryPoint;
import fr.dyade.aaa.jndi2.ha.HARequestManager;
import fr.dyade.aaa.jndi2.ha.HATcpServer;
import fr.dyade.aaa.jndi2.server.AgentEntryPoint;
import fr.dyade.aaa.jndi2.server.Container;
import fr.dyade.aaa.jndi2.server.Trace;
import java.net.ServerSocket;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;

public class HADistributedJndiServer {
    private static HATcpServer tcpServer;

    public static void init(String args, boolean firstTime) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("HADistributedJndiServer.init(" + args + ',' + firstTime + ')'));
        }
        StringTokenizer st = new StringTokenizer(args);
        String portS = st.nextToken();
        int port = Integer.parseInt(portS);
        Vector<Short> list = new Vector<Short>();
        while (st.hasMoreTokens()) {
            String idS = st.nextToken();
            Short id = Short.valueOf(idS);
            list.addElement(id);
        }
        short[] serverIds = new short[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            serverIds[i] = (Short)list.elementAt(i);
        }
        ServerSocket serverSocket = new ServerSocket(port);
        tcpServer = new HATcpServer(serverSocket, 3, HADistributedJndiServer.getDefault());
        tcpServer.start();
        if (firstTime) {
            ReplicationManager manager = new ReplicationManager(serverIds);
            AgentEntryPoint agentEP = new AgentEntryPoint();
            agentEP.setRequestManager(manager);
            ReplicationEntryPoint replicationEP = new ReplicationEntryPoint();
            replicationEP.setRequestManager(manager);
            HARequestManager haManager = new HARequestManager();
            haManager.setRequestManager(manager);
            HAEntryPoint haEP = new HAEntryPoint();
            haEP.setHARequestManager(haManager);
            Container container = new Container();
            container.addEntryPoint(agentEP);
            container.addEntryPoint(replicationEP);
            container.addEntryPoint(haEP);
            container.setLifeCycleListener(haManager);
            container.setBagSerializer(haManager);
            manager.setContainer(container);
            container.deploy();
        }
    }

    public static void stopService() {
        tcpServer.stop();
    }

    public static AgentId getDefault() {
        return HADistributedJndiServer.getDefault(AgentServer.getServerId());
    }

    public static AgentId getDefault(short serverId) {
        return new AgentId(serverId, serverId, AgentId.LocalJndiServiceStamp);
    }
}

