/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.ha;

import fr.dyade.aaa.jndi2.msg.IOControl;
import fr.dyade.aaa.jndi2.msg.JndiReply;
import fr.dyade.aaa.jndi2.msg.JndiRequest;
import fr.dyade.aaa.jndi2.server.RequestContext;
import fr.dyade.aaa.jndi2.server.Trace;
import org.objectweb.util.monolog.api.BasicLevel;

public class HARequestContext
extends RequestContext {
    private static final long serialVersionUID = 1L;
    private transient IOControl ioCtrl;
    private JndiRequest request;
    private JndiReply reply;
    private int id;

    HARequestContext(IOControl ioCtrl, int id) throws Exception {
        this.ioCtrl = ioCtrl;
        this.id = id;
        this.request = (JndiRequest)ioCtrl.readObject();
    }

    public final int getId() {
        return this.id;
    }

    void recover(HARequestContext ctx) {
        this.ioCtrl = ctx.ioCtrl;
    }

    final JndiReply getReply() {
        return this.reply;
    }

    public final JndiRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(JndiReply reply) {
        this.reply = reply;
        if (this.ioCtrl != null) {
            try {
                this.ioCtrl.writeObject(reply);
            }
            catch (Exception exc) {
                Trace.logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            finally {
                this.ioCtrl.close();
            }
        }
    }

    public String toString() {
        return '(' + super.toString() + ",request=" + this.request + ')';
    }
}

