/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.MessageQueue;
import fr.dyade.aaa.agent.MessageVector;
import fr.dyade.aaa.agent.NetworkMBean;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.util.Arrays;
import java.io.IOException;
import java.io.Serializable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class Network
implements MessageConsumer,
NetworkMBean {
    long WDActivationPeriod = 1000L;
    int WDNbRetryLevel1 = 5;
    long WDRetryPeriod1 = this.WDActivationPeriod;
    int WDNbRetryLevel2 = 30;
    long WDRetryPeriod2 = 10000L;
    long WDRetryPeriod3 = 60000L;
    protected Logger logmon = null;
    protected short sid;
    protected int idxLS;
    protected short[] servers;
    protected transient String serversFN = null;
    private int[] stamp;
    private byte[] stampbuf = null;
    private int[] bootTS = null;
    protected transient String bootTSFN = null;
    protected String name;
    protected String domain;
    protected int port;
    protected MessageVector qout;
    static final int DELIVER = 0;
    static final int ALREADY_DELIVERED = 2;

    public long getWDActivationPeriod() {
        return this.WDActivationPeriod;
    }

    public void setWDActivationPeriod(long WDActivationPeriod) {
        this.WDActivationPeriod = WDActivationPeriod;
    }

    public int getWDNbRetryLevel1() {
        return this.WDNbRetryLevel1;
    }

    public void setWDNbRetryLevel1(int WDNbRetryLevel1) {
        this.WDNbRetryLevel1 = WDNbRetryLevel1;
    }

    public long getWDRetryPeriod1() {
        return this.WDRetryPeriod1;
    }

    public void setWDRetryPeriod1(long WDRetryPeriod1) {
        this.WDRetryPeriod1 = WDRetryPeriod1;
    }

    public int getWDNbRetryLevel2() {
        return this.WDNbRetryLevel2;
    }

    public void setWDNbRetryLevel2(int WDNbRetryLevel2) {
        this.WDNbRetryLevel2 = WDNbRetryLevel2;
    }

    public long getWDRetryPeriod2() {
        return this.WDRetryPeriod2;
    }

    public void setWDRetryPeriod2(long WDRetryPeriod2) {
        this.WDRetryPeriod2 = WDRetryPeriod2;
    }

    public long getWDRetryPeriod3() {
        return this.WDRetryPeriod3;
    }

    public void setWDRetryPeriod3(long WDRetryPeriod3) {
        this.WDRetryPeriod3 = WDRetryPeriod3;
    }

    public int getNbWaitingMessages() {
        return this.qout.size();
    }

    public final String getName() {
        return this.name;
    }

    public final String getDomainName() {
        return this.domain;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("(").append(super.toString());
        strbuf.append(",name=").append(this.getName());
        if (this.qout != null) {
            strbuf.append(",qout=").append(this.qout.size());
        }
        if (this.servers != null) {
            for (int i = 0; i < this.servers.length; ++i) {
                strbuf.append(",(").append(this.servers[i]).append(',');
                strbuf.append(this.stamp[i]).append(')');
            }
        }
        strbuf.append(")");
        return strbuf.toString();
    }

    public void insert(Message msg) {
        this.qout.insert(msg);
    }

    public void save() throws IOException {
    }

    public void restore() throws Exception {
        this.sid = AgentServer.getServerId();
        this.idxLS = this.index(this.sid);
        this.stampbuf = AgentServer.getTransaction().loadByteArray(this.name);
        if (this.stampbuf == null) {
            this.stampbuf = new byte[4 * this.servers.length];
            this.stamp = new int[this.servers.length];
            this.bootTS = new int[this.servers.length];
            for (int i = 0; i < this.servers.length; ++i) {
                if (i != this.idxLS) {
                    this.stamp[i] = -1;
                    this.bootTS[i] = -1;
                    continue;
                }
                this.stamp[i] = 0;
                this.bootTS[i] = (int)(System.currentTimeMillis() / 1000L);
            }
            AgentServer.getTransaction().save((Serializable)this.servers, this.serversFN);
            AgentServer.getTransaction().save((Serializable)this.bootTS, this.bootTSFN);
            AgentServer.getTransaction().saveByteArray(this.stampbuf, this.name);
        } else {
            int i;
            short[] s = (short[])AgentServer.getTransaction().load(this.serversFN);
            this.bootTS = (int[])AgentServer.getTransaction().load(this.bootTSFN);
            this.stamp = new int[s.length];
            for (i = 0; i < this.stamp.length; ++i) {
                this.stamp[i] = ((this.stampbuf[i * 4 + 0] & 0xFF) << 24) + ((this.stampbuf[i * 4 + 1] & 0xFF) << 16) + ((this.stampbuf[i * 4 + 2] & 0xFF) << 8) + (this.stampbuf[i * 4 + 3] & 0xFF);
            }
            if (this.servers != null && !Arrays.equals(this.servers, s)) {
                for (i = 0; i < this.servers.length; ++i) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)("servers[" + i + "]=" + this.servers[i]));
                }
                for (i = 0; i < s.length; ++i) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)("servers[" + i + "]=" + s[i]));
                }
                throw new IOException("Network configuration changed");
            }
        }
    }

    public void init(String name, int port, short[] servers) throws Exception {
        this.name = AgentServer.getName() + '.' + name;
        this.qout = new MessageVector(this.name, AgentServer.getTransaction().isPersistent());
        this.domain = name;
        this.port = port;
        this.logmon = Debug.getLogger("fr.dyade.aaa.agent.Network." + name);
        this.logmon.log(BasicLevel.INFO, (Object)(name + ", initialized"));
        Arrays.sort(servers);
        this.servers = servers;
        this.serversFN = name + "Servers";
        this.bootTSFN = name + "BootTS";
        this.setProperties();
        this.restore();
    }

    public void setProperties() throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.domain + ", Network.setProperties()"));
        }
        this.WDActivationPeriod = AgentServer.getLong("WDActivationPeriod", this.WDActivationPeriod);
        this.WDActivationPeriod = AgentServer.getLong(this.domain + ".WDActivationPeriod", this.WDActivationPeriod);
        this.WDNbRetryLevel1 = AgentServer.getInteger("WDNbRetryLevel1", this.WDNbRetryLevel1);
        this.WDNbRetryLevel1 = AgentServer.getInteger(this.domain + ".WDNbRetryLevel1", this.WDNbRetryLevel1);
        this.WDRetryPeriod1 = AgentServer.getLong("WDRetryPeriod1", this.WDRetryPeriod1);
        this.WDRetryPeriod1 = AgentServer.getLong(this.domain + ".WDRetryPeriod1", this.WDRetryPeriod1);
        this.WDNbRetryLevel2 = AgentServer.getInteger("WDNbRetryLevel2", this.WDNbRetryLevel2);
        this.WDNbRetryLevel2 = AgentServer.getInteger(this.domain + ".WDNbRetryLevel2", this.WDNbRetryLevel2);
        this.WDRetryPeriod2 = AgentServer.getLong("WDRetryPeriod2", this.WDRetryPeriod2);
        this.WDRetryPeriod2 = AgentServer.getLong(this.domain + ".WDRetryPeriod2", this.WDRetryPeriod2);
        this.WDRetryPeriod3 = AgentServer.getLong("WDRetryPeriod3", this.WDRetryPeriod3);
        this.WDRetryPeriod3 = AgentServer.getLong(this.domain + ".WDRetryPeriod3", this.WDRetryPeriod3);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append(" setProperties(");
            strbuf.append("WDActivationPeriod=").append(this.WDActivationPeriod);
            strbuf.append(", WDNbRetryLevel1=").append(this.WDNbRetryLevel1);
            strbuf.append(", WDRetryPeriod1=").append(this.WDRetryPeriod1);
            strbuf.append(", WDNbRetryLevel2=").append(this.WDNbRetryLevel2);
            strbuf.append(", WDRetryPeriod2=").append(this.WDRetryPeriod2);
            strbuf.append(", WDRetryPeriod3=").append(this.WDRetryPeriod3);
            strbuf.append(')');
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + strbuf.toString()));
        }
    }

    synchronized void addServer(short id) throws Exception {
        int idx = this.index(id);
        if (idx >= 0) {
            return;
        }
        idx = -idx - 1;
        int[] newStamp = new int[this.servers.length + 1];
        byte[] newStampBuf = new byte[4 * (this.servers.length + 1)];
        int[] newBootTS = new int[this.servers.length + 1];
        short[] newServers = new short[this.servers.length + 1];
        int j = 0;
        for (int i = 0; i < this.servers.length; ++i) {
            if (i == idx) {
                ++j;
            }
            newServers[j] = this.servers[i];
            newBootTS[j] = this.bootTS[i];
            newStamp[j] = this.stamp[i];
            ++j;
        }
        if (idx > 0) {
            System.arraycopy(this.stampbuf, 0, newStampBuf, 0, idx * 4);
        }
        if (idx < this.servers.length) {
            System.arraycopy(this.stampbuf, idx * 4, newStampBuf, (idx + 1) * 4, (this.servers.length - idx) * 4);
        }
        newServers[idx] = id;
        newBootTS[idx] = -1;
        newStamp[idx] = -1;
        newStampBuf[idx] = 0;
        newStampBuf[idx + 1] = 0;
        newStampBuf[idx + 2] = 0;
        newStampBuf[idx + 3] = 0;
        this.stamp = newStamp;
        this.stampbuf = newStampBuf;
        this.servers = newServers;
        this.bootTS = newBootTS;
        this.idxLS = this.index(this.sid);
        AgentServer.getTransaction().save((Serializable)this.servers, this.serversFN);
        AgentServer.getTransaction().save((Serializable)this.bootTS, this.bootTSFN);
        AgentServer.getTransaction().saveByteArray(this.stampbuf, this.name);
    }

    synchronized void delServer(short id) throws Exception {
        int idx = this.index(id);
        if (idx < 0) {
            return;
        }
        int[] newStamp = new int[this.servers.length - 1];
        byte[] newStampBuf = new byte[4 * (this.servers.length - 1)];
        int[] newBootTS = new int[this.servers.length - 1];
        short[] newServers = new short[this.servers.length - 1];
        int j = 0;
        for (int i = 0; i < this.servers.length; ++i) {
            if (id == this.servers[i]) {
                idx = i;
                continue;
            }
            newServers[j] = this.servers[i];
            newBootTS[j] = this.bootTS[i];
            newStamp[j] = this.stamp[i];
            ++j;
        }
        if (idx > 0) {
            System.arraycopy(this.stampbuf, 0, newStampBuf, 0, idx * 4);
        }
        if (idx < this.servers.length - 1) {
            System.arraycopy(this.stampbuf, (idx + 1) * 4, newStampBuf, idx * 4, (this.servers.length - idx - 1) * 4);
        }
        this.stamp = newStamp;
        this.stampbuf = newStampBuf;
        this.servers = newServers;
        this.bootTS = newBootTS;
        this.idxLS = this.index(this.sid);
        AgentServer.getTransaction().save((Serializable)this.servers, this.serversFN);
        AgentServer.getTransaction().save((Serializable)this.bootTS, this.bootTSFN);
        AgentServer.getTransaction().saveByteArray(this.stampbuf, this.name);
    }

    synchronized void resetServer(short id, int boot) throws IOException {
        int idx = this.index(id);
        if (idx < 0) {
            return;
        }
        AgentServer.getTransaction().save((Serializable)this.servers, this.serversFN);
        AgentServer.getTransaction().save((Serializable)this.bootTS, this.bootTSFN);
        AgentServer.getTransaction().saveByteArray(this.stampbuf, this.name);
    }

    public void post(Message msg) throws Exception {
        short to = AgentServer.getServerDesc((short)msg.to.to).gateway;
        msg.source = AgentServer.getServerId();
        msg.dest = to;
        msg.stamp = this.getSendUpdate(to);
        msg.save();
        this.qout.push(msg);
    }

    protected final int index(short id) {
        int idx = Arrays.binarySearch(this.servers, id);
        return idx;
    }

    protected final byte[] getStamp() {
        return this.stampbuf;
    }

    protected final void setStamp(byte[] stampbuf) {
        this.stampbuf = stampbuf;
        this.stamp = new int[this.servers.length];
        for (int i = 0; i < this.stamp.length; ++i) {
            this.stamp[i] = ((stampbuf[i * 4 + 0] & 0xFF) << 24) + ((stampbuf[i * 4 + 1] & 0xFF) << 16) + ((stampbuf[i * 4 + 2] & 0xFF) << 8) + (stampbuf[i * 4 + 3] & 0xFF);
        }
    }

    private void updateStamp(int idx, int update) throws IOException {
        this.stamp[idx] = update;
        this.stampbuf[idx * 4 + 0] = (byte)(update >>> 24 & 0xFF);
        this.stampbuf[idx * 4 + 1] = (byte)(update >>> 16 & 0xFF);
        this.stampbuf[idx * 4 + 2] = (byte)(update >>> 8 & 0xFF);
        this.stampbuf[idx * 4 + 3] = (byte)(update & 0xFF);
        AgentServer.getTransaction().saveByteArray(this.stampbuf, this.name);
    }

    private synchronized int testRecvUpdate(short source, int update) throws IOException {
        int fromIdx = this.index(source);
        if (update > this.stamp[fromIdx]) {
            this.updateStamp(fromIdx, update);
            return 0;
        }
        return 2;
    }

    private synchronized int getSendUpdate(short to) throws IOException {
        int update = this.stamp[this.idxLS] + 1;
        this.updateStamp(this.idxLS, update);
        return update;
    }

    final int getBootTS() {
        return this.bootTS[this.idxLS];
    }

    final void testBootTS(short source, int boot) throws IOException {
        int fromIdx = this.index(source);
        if (boot != this.bootTS[fromIdx]) {
            if (this.bootTS[fromIdx] != -1 && this.logmon.isLoggable(BasicLevel.WARN)) {
                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", reset stamp #" + source + ", " + this.bootTS[fromIdx] + " -> " + boot));
            }
            this.bootTS[fromIdx] = boot;
            AgentServer.getTransaction().save((Serializable)this.bootTS, this.bootTSFN);
            this.updateStamp(fromIdx, -1);
        }
    }

    protected void deliver(Message msg) throws Exception {
        short source = msg.getSource();
        short dest = msg.getDest();
        if (dest != AgentServer.getServerId()) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", recv bad msg#" + msg.getStamp() + " really to " + dest + " by " + source));
            throw new Exception("recv bad msg#" + msg.getStamp() + " really to " + dest + " by " + source);
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", recv msg#" + msg.getStamp() + " from " + msg.from + " to " + msg.to + " by " + source));
        }
        ServerDesc desc = AgentServer.getServerDesc(source);
        if (!desc.active) {
            desc.active = true;
            desc.retry = 0;
        }
        AgentServer.getTransaction().begin();
        int todo = this.testRecvUpdate(source, msg.getStamp());
        if (todo == 0) {
            Channel.post(msg);
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", deliver msg#" + msg.getStamp()));
            }
            Channel.save();
            AgentServer.getTransaction().commit(false);
            Channel.validate();
            AgentServer.getTransaction().release();
        } else {
            AgentServer.getTransaction().commit(true);
        }
    }

    public void delete() throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        AgentServer.getTransaction().delete(this.serversFN);
        AgentServer.getTransaction().delete(this.bootTSFN);
        AgentServer.getTransaction().delete(this.name);
    }

    public void validate() {
        this.qout.validate();
    }

    public MessageQueue getQueue() {
        return this.qout;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public final int getPort() {
        return this.port;
    }
}

