/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.attributes.AttributeRepositoryClass;
import org.apache.commons.attributes.CachedRepository;
import org.apache.commons.attributes.CircularDependencyError;
import org.apache.commons.attributes.DefaultCachedRepository;
import org.apache.commons.attributes.EmptyAttributeRepositoryClass;
import org.apache.commons.attributes.MultipleAttributesError;
import org.apache.commons.attributes.RepositoryError;
import org.apache.commons.attributes.RuntimeAttributeRepository;
import org.apache.commons.attributes.Util;

public class Attributes {
    private static final Map classRepositories = new WeakHashMap();
    private static List initList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized CachedRepository getCachedRepository(Class clazz) throws RepositoryError, CircularDependencyError {
        if (initList.contains(clazz)) {
            ArrayList<Class> dependencyList = new ArrayList<Class>();
            dependencyList.addAll(initList);
            dependencyList.add(clazz);
            throw new CircularDependencyError(clazz.getName(), dependencyList);
        }
        if (classRepositories.containsKey(clazz)) {
            CachedRepository cr = (CachedRepository)classRepositories.get(clazz);
            return cr;
        }
        DefaultCachedRepository cached = null;
        initList.add(clazz);
        try {
            Class<?> attributeRepo = null;
            AttributeRepositoryClass repo = EmptyAttributeRepositoryClass.INSTANCE;
            try {
                attributeRepo = Class.forName(clazz.getName() + "$__attributeRepository", true, clazz.getClassLoader());
                repo = (AttributeRepositoryClass)attributeRepo.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                repo = EmptyAttributeRepositoryClass.INSTANCE;
            }
            catch (InstantiationException ie) {
                throw new RepositoryError(ie);
            }
            catch (IllegalAccessException iae) {
                throw new RepositoryError(iae);
            }
            cached = new DefaultCachedRepository(clazz, repo);
            classRepositories.put(clazz, cached);
            if (repo != null) {
                Util.validateRepository(clazz, repo);
            }
        }
        finally {
            initList.remove(initList.size() - 1);
        }
        return cached;
    }

    private static Object getAttribute(Collection attrs, Class attributeClass) throws MultipleAttributesError {
        Object candidate = null;
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            Object attr = iter.next();
            if (attr.getClass() != attributeClass) continue;
            if (candidate == null) {
                candidate = attr;
                continue;
            }
            throw new MultipleAttributesError(attributeClass.getName());
        }
        return candidate;
    }

    public static Object getAttribute(Class clazz, Class attributeClass) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(clazz), attributeClass);
    }

    public static Object getAttribute(Field field, Class attributeClass) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(field), attributeClass);
    }

    public static Object getAttribute(Constructor constructor, Class attributeClass) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(constructor), attributeClass);
    }

    public static Object getAttribute(Method method, Class attributeClass) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(method), attributeClass);
    }

    public static Object getParameterAttribute(Method method, int parameter, Class attributeClass) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getParameterAttributes(method, parameter), attributeClass);
    }

    public static Object getParameterAttribute(Constructor constructor, int parameter, Class attributeClass) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getParameterAttributes(constructor, parameter), attributeClass);
    }

    public static Object getReturnAttribute(Method method, Class attributeClass) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getReturnAttributes(method), attributeClass);
    }

    public static Collection getAttributes(Class clazz) throws RepositoryError {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return Attributes.getCachedRepository(clazz).getAttributes();
    }

    public static Collection getAttributes(Method method) throws RepositoryError {
        if (method == null) {
            throw new NullPointerException("method");
        }
        return Attributes.getCachedRepository(method.getDeclaringClass()).getAttributes(method);
    }

    public static Collection getParameterAttributes(Method method, int parameter) throws RepositoryError {
        if (method == null) {
            throw new NullPointerException("method");
        }
        return Attributes.getCachedRepository(method.getDeclaringClass()).getParameterAttributes(method, parameter);
    }

    public static Collection getParameterAttributes(Constructor constructor, int parameter) throws RepositoryError {
        if (constructor == null) {
            throw new NullPointerException("constructor");
        }
        return Attributes.getCachedRepository(constructor.getDeclaringClass()).getParameterAttributes(constructor, parameter);
    }

    public static Collection getReturnAttributes(Method method) throws RepositoryError {
        if (method == null) {
            throw new NullPointerException("method");
        }
        return Attributes.getCachedRepository(method.getDeclaringClass()).getReturnAttributes(method);
    }

    public static Collection getAttributes(Field field) throws RepositoryError {
        if (field == null) {
            throw new NullPointerException("field");
        }
        return Attributes.getCachedRepository(field.getDeclaringClass()).getAttributes(field);
    }

    public static Collection getAttributes(Constructor constructor) throws RepositoryError {
        if (constructor == null) {
            throw new NullPointerException("constructor");
        }
        return Attributes.getCachedRepository(constructor.getDeclaringClass()).getAttributes(constructor);
    }

    private static Collection getAttributes(Collection attrs, Class attributeClass) {
        HashSet result = new HashSet();
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            Object attr = iter.next();
            if (attr.getClass() != attributeClass) continue;
            result.add(attr);
        }
        return Collections.unmodifiableCollection(result);
    }

    public static Collection getAttributes(Class clazz, Class attributeClass) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getAttributes(clazz), attributeClass);
    }

    public static Collection getAttributes(Field field, Class attributeClass) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getAttributes(field), attributeClass);
    }

    public static Collection getAttributes(Constructor constructor, Class attributeClass) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getAttributes(constructor), attributeClass);
    }

    public static Collection getAttributes(Method method, Class attributeClass) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getAttributes(method), attributeClass);
    }

    public static Collection getParameterAttributes(Method method, int parameter, Class attributeClass) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getParameterAttributes(method, parameter), attributeClass);
    }

    public static Collection getParameterAttributes(Constructor constructor, int parameter, Class attributeClass) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getParameterAttributes(constructor, parameter), attributeClass);
    }

    public static Collection getReturnAttributes(Method method, Class attributeClass) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getReturnAttributes(method), attributeClass);
    }

    private static boolean hasAttributeType(Collection attrs, Class attributeClass) {
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            Object attr = iter.next();
            if (attr.getClass() != attributeClass) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAttributeType(Class clazz, Class attributeClass) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getAttributes(clazz), attributeClass);
    }

    public static boolean hasAttributeType(Field field, Class attributeClass) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getAttributes(field), attributeClass);
    }

    public static boolean hasAttributeType(Constructor constructor, Class attributeClass) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getAttributes(constructor), attributeClass);
    }

    public static boolean hasAttributeType(Method method, Class attributeClass) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getAttributes(method), attributeClass);
    }

    public static boolean hasParameterAttributeType(Method method, int parameter, Class attributeClass) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getParameterAttributes(method, parameter), attributeClass);
    }

    public static boolean hasParameterAttributeType(Constructor constructor, int parameter, Class attributeClass) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getParameterAttributes(constructor, parameter), attributeClass);
    }

    public static boolean hasReturnAttributeType(Method method, Class attributeClass) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getReturnAttributes(method), attributeClass);
    }

    private static boolean hasAttribute(Collection attrs, Object attribute) throws RepositoryError {
        return attrs.contains(attribute);
    }

    public static boolean hasAttribute(Class clazz, Object attribute) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getAttributes(clazz), attribute);
    }

    public static boolean hasAttribute(Field field, Object attribute) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getAttributes(field), attribute);
    }

    public static boolean hasAttribute(Constructor constructor, Object attribute) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getAttributes(constructor), attribute);
    }

    public static boolean hasAttribute(Method method, Object attribute) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getAttributes(method), attribute);
    }

    public static boolean hasParameterAttribute(Method method, int parameter, Object attribute) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getParameterAttributes(method, parameter), attribute);
    }

    public static boolean hasParameterAttribute(Constructor constructor, int parameter, Object attribute) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getParameterAttributes(constructor, parameter), attribute);
    }

    public static boolean hasReturnAttribute(Method method, Object attribute) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getReturnAttributes(method), attribute);
    }

    public static synchronized void setAttributes(RuntimeAttributeRepository repo) throws IllegalStateException {
        if (repo == null) {
            throw new NullPointerException("repo");
        }
        repo.seal();
        Class clazz = repo.getDefinedClass();
        if (classRepositories.get(clazz) != null) {
            throw new IllegalStateException(clazz.getName());
        }
        Util.validateRepository(clazz, repo);
        DefaultCachedRepository cached = new DefaultCachedRepository(clazz, repo);
        classRepositories.put(clazz, cached);
    }
}

