/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.test;

import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.test.AbstractCXFTest;
import org.junit.After;
import org.junit.Before;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCXFSpringTest
extends AbstractCXFTest {
    private static GenericApplicationContext applicationContext;
    private DefaultResourceLoader resourceLoader;

    protected AbstractCXFSpringTest() {
    }

    @Before
    public void setupBeans() throws Exception {
        if (applicationContext != null) {
            return;
        }
        applicationContext = new GenericApplicationContext();
        this.resourceLoader = new DefaultResourceLoader(((Object)((Object)this)).getClass().getClassLoader());
        for (String beanDefinitionPath : this.getConfigLocations()) {
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(applicationContext);
            Resource resource = this.resourceLoader.getResource(beanDefinitionPath);
            reader.loadBeanDefinitions(resource);
        }
        this.additionalSpringConfiguration(applicationContext);
        applicationContext.refresh();
        super.setUpBus();
    }

    @Override
    @Before
    public void setUpBus() throws Exception {
    }

    @Override
    public Bus createBus() throws BusException {
        return this.getBean(Bus.class, "cxf");
    }

    @After
    public void teardownBeans() {
        applicationContext.close();
        applicationContext.destroy();
        applicationContext = null;
    }

    protected abstract String[] getConfigLocations();

    protected ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    protected void additionalSpringConfiguration(GenericApplicationContext context) throws Exception {
    }

    protected <T> T getBean(Class<T> type, String beanName) {
        return type.cast(applicationContext.getBean(beanName));
    }
}

