/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.util.Config;

class BindingCategoryTable {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$datastore$jdbc$BindingCategoryTable == null ? (class$org$apache$juddi$datastore$jdbc$BindingCategoryTable = BindingCategoryTable.class$("org.apache.juddi.datastore.jdbc.BindingCategoryTable")) : class$org$apache$juddi$datastore$jdbc$BindingCategoryTable);
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static String tablePrefix = "";
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$BindingCategoryTable;

    BindingCategoryTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String bindingKey, Vector keyRefs, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, bindingKey.toString());
            int listSize = keyRefs.size();
            for (int categoryID = 0; categoryID < listSize; ++categoryID) {
                KeyedReference keyRef = (KeyedReference)keyRefs.elementAt(categoryID);
                String tModelKeyValue = null;
                if (keyRef.getTModelKey() != null) {
                    tModelKeyValue = keyRef.getTModelKey().toString();
                }
                statement.setInt(2, categoryID);
                statement.setString(3, tModelKeyValue);
                statement.setString(4, keyRef.getKeyName());
                statement.setString(5, keyRef.getKeyValue());
                if (log.isDebugEnabled()) {
                    log.debug("insert into " + tablePrefix + "BINDING_CATEGORY table:\n\n\t" + insertSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n\t CATEGORY_ID=" + categoryID + "\n\t TMODEL_KEY_REF=" + tModelKeyValue + "\n\t KEY_NAME=" + keyRef.getKeyName() + "\n\t KEY_VALUE=" + keyRef.getKeyValue() + "\n");
                }
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String bindingKey, Connection connection) throws SQLException {
        Vector<KeyedReference> keyRefList = new Vector<KeyedReference>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, bindingKey.toString());
            if (log.isDebugEnabled()) {
                log.debug("select from " + tablePrefix + "BINDING_CATEGORY table:\n\n\t" + selectSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n");
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                KeyedReference keyRef = new KeyedReference();
                keyRef.setTModelKey(resultSet.getString(1));
                keyRef.setKeyName(resultSet.getString(2));
                keyRef.setKeyValue(resultSet.getString(3));
                keyRefList.add(keyRef);
            }
            Vector<KeyedReference> vector = keyRefList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String bindingKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, bindingKey.toString());
            if (log.isDebugEnabled()) {
                log.debug("delete from " + tablePrefix + "BINDING_CATEGORY table:\n\n\t" + deleteSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n");
            }
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO ").append(tablePrefix).append("BINDING_CATEGORY (");
        sql.append("BINDING_KEY,");
        sql.append("CATEGORY_ID,");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE, ");
        sql.append("CATEGORY_ID ");
        sql.append("FROM ").append(tablePrefix).append("BINDING_CATEGORY ");
        sql.append("WHERE BINDING_KEY=? ");
        sql.append("ORDER BY CATEGORY_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM ").append(tablePrefix).append("BINDING_CATEGORY ");
        sql.append("WHERE BINDING_KEY=?");
        deleteSQL = sql.toString();
    }
}

