/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.jdbc.AddressLineTable;
import org.apache.juddi.datastore.jdbc.AddressTable;
import org.apache.juddi.datastore.jdbc.AuthTokenTable;
import org.apache.juddi.datastore.jdbc.BindingCategoryTable;
import org.apache.juddi.datastore.jdbc.BindingDescTable;
import org.apache.juddi.datastore.jdbc.BindingTemplateTable;
import org.apache.juddi.datastore.jdbc.BusinessCategoryTable;
import org.apache.juddi.datastore.jdbc.BusinessDescTable;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.BusinessIdentifierTable;
import org.apache.juddi.datastore.jdbc.BusinessNameTable;
import org.apache.juddi.datastore.jdbc.BusinessServiceTable;
import org.apache.juddi.datastore.jdbc.ContactDescTable;
import org.apache.juddi.datastore.jdbc.ContactTable;
import org.apache.juddi.datastore.jdbc.DiscoveryURLTable;
import org.apache.juddi.datastore.jdbc.EmailTable;
import org.apache.juddi.datastore.jdbc.FindBindingByCategoryQuery;
import org.apache.juddi.datastore.jdbc.FindBindingByServiceKeyQuery;
import org.apache.juddi.datastore.jdbc.FindBindingByTModelKeyQuery;
import org.apache.juddi.datastore.jdbc.FindBusinessByCategoryQuery;
import org.apache.juddi.datastore.jdbc.FindBusinessByDiscoveryURLQuery;
import org.apache.juddi.datastore.jdbc.FindBusinessByIdentifierQuery;
import org.apache.juddi.datastore.jdbc.FindBusinessByNameQuery;
import org.apache.juddi.datastore.jdbc.FindBusinessByTModelKeyQuery;
import org.apache.juddi.datastore.jdbc.FindPublisherByNameQuery;
import org.apache.juddi.datastore.jdbc.FindRelatedBusinessQuery;
import org.apache.juddi.datastore.jdbc.FindServiceByBusinessKeyQuery;
import org.apache.juddi.datastore.jdbc.FindServiceByCategoryQuery;
import org.apache.juddi.datastore.jdbc.FindServiceByNameQuery;
import org.apache.juddi.datastore.jdbc.FindServiceByTModelKeyQuery;
import org.apache.juddi.datastore.jdbc.FindTModelByCategoryQuery;
import org.apache.juddi.datastore.jdbc.FindTModelByIdentifierQuery;
import org.apache.juddi.datastore.jdbc.FindTModelByNameQuery;
import org.apache.juddi.datastore.jdbc.InstanceDetailsDescTable;
import org.apache.juddi.datastore.jdbc.InstanceDetailsDocDescTable;
import org.apache.juddi.datastore.jdbc.PhoneTable;
import org.apache.juddi.datastore.jdbc.PublisherAssertionTable;
import org.apache.juddi.datastore.jdbc.PublisherTable;
import org.apache.juddi.datastore.jdbc.ServiceCategoryTable;
import org.apache.juddi.datastore.jdbc.ServiceDescTable;
import org.apache.juddi.datastore.jdbc.ServiceNameTable;
import org.apache.juddi.datastore.jdbc.TModelCategoryTable;
import org.apache.juddi.datastore.jdbc.TModelDescTable;
import org.apache.juddi.datastore.jdbc.TModelDocDescTable;
import org.apache.juddi.datastore.jdbc.TModelIdentifierTable;
import org.apache.juddi.datastore.jdbc.TModelInstanceInfoDescTable;
import org.apache.juddi.datastore.jdbc.TModelInstanceInfoTable;
import org.apache.juddi.datastore.jdbc.TModelTable;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.SharedRelationships;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.BindingTemplates;
import org.apache.juddi.datatype.binding.InstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.response.AssertionStatusItem;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.response.CompletionStatus;
import org.apache.juddi.datatype.response.PublisherInfo;
import org.apache.juddi.datatype.response.RelatedBusinessInfo;
import org.apache.juddi.datatype.response.ServiceInfo;
import org.apache.juddi.datatype.response.ServiceInfos;
import org.apache.juddi.datatype.response.TModelInfo;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnknownUserException;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

public class JDBCDataStore
implements DataStore {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$datastore$jdbc$JDBCDataStore == null ? (class$org$apache$juddi$datastore$jdbc$JDBCDataStore = JDBCDataStore.class$("org.apache.juddi.datastore.jdbc.JDBCDataStore")) : class$org$apache$juddi$datastore$jdbc$JDBCDataStore);
    private Connection connection = null;
    private Transaction transaction = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$JDBCDataStore;

    public JDBCDataStore() {
        try {
            this.connection = ConnectionManager.acquireConnection();
        }
        catch (SQLException sqlex) {
            log.error("Exception occured while attempting to aquire a JDBC connection: " + sqlex.getMessage(), sqlex);
        }
    }

    public void release() {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException sqlex) {
            log.error("Exception occured while attempting to close a JDBC connection: " + sqlex.getMessage());
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void beginTrans() throws RegistryException {
        try {
            this.transaction = new Transaction();
            this.transaction.begin(this.connection);
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public void commit() throws RegistryException {
        try {
            this.transaction.commit();
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public void rollback() throws RegistryException {
        try {
            this.transaction.rollback();
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public Publisher getPublisher(String publisherID) throws RegistryException {
        if (publisherID == null) {
            return null;
        }
        Publisher publisher = null;
        try {
            publisher = PublisherTable.select(publisherID, this.connection);
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return publisher;
    }

    public boolean isAdministrator(String publisherID) throws RegistryException {
        if (publisherID == null || publisherID.length() == 0) {
            throw new UnknownUserException("publisherID = " + publisherID);
        }
        try {
            Publisher publisher = PublisherTable.select(publisherID, this.connection);
            if (publisher == null) {
                throw new UnknownUserException("publisherID = " + publisherID);
            }
            return publisher.isAdmin();
        }
        catch (SQLException sqlex) {
            log.error(sqlex.getMessage());
            throw new RegistryException(sqlex);
        }
    }

    public boolean isEnabled(String publisherID) throws RegistryException {
        if (publisherID == null || publisherID.length() == 0) {
            throw new UnknownUserException("publisherID = " + publisherID);
        }
        try {
            Publisher publisher = PublisherTable.select(publisherID, this.connection);
            if (publisher == null) {
                throw new UnknownUserException("publisherID = " + publisherID);
            }
            return publisher.isEnabled();
        }
        catch (SQLException sqlex) {
            log.error(sqlex.getMessage());
            throw new RegistryException(sqlex);
        }
    }

    public String generateToken(Publisher publisher) throws RegistryException {
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        String token = "authToken:" + uuidgen.uuidgen();
        log.info("Generated token '" + token + "' for user: '" + publisher.getPublisherID() + "/" + publisher.getName() + "'");
        return token;
    }

    public void storeAuthToken(String token, Publisher publisher) throws RegistryException {
        if (token != null && publisher != null) {
            try {
                AuthTokenTable.insert(token, publisher, this.connection);
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
    }

    public void retireAuthToken(String token) throws RegistryException {
        if (token != null) {
            try {
                AuthTokenTable.invalidate(token, this.connection);
                AuthTokenTable.touch(token, this.connection);
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
    }

    public Publisher getAuthTokenPublisher(String token) throws RegistryException {
        Publisher publisher = null;
        if (token != null) {
            try {
                publisher = AuthTokenTable.selectPublisher(token, this.connection);
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
        return publisher;
    }

    public boolean isAuthTokenExpired(String token) throws RegistryException {
        boolean expired = false;
        if (token != null) {
            try {
                long tokenState = AuthTokenTable.selectTokenState(token, this.connection);
                if (tokenState <= 0L) {
                    expired = true;
                    return true;
                }
                long lastUsed = AuthTokenTable.selectLastUsed(token, this.connection);
                if (lastUsed > 0L) {
                    long timeOut = Config.getLongProperty("juddi.authTokenTimeout", 3600L) * 1000L;
                    long currTime = System.currentTimeMillis();
                    if (currTime - lastUsed >= timeOut) {
                        expired = true;
                    }
                }
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
        return expired;
    }

    public void touchAuthToken(String token) throws RegistryException {
        if (token != null) {
            try {
                AuthTokenTable.touch(token, this.connection);
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
    }

    public void saveBusiness(BusinessEntity business, String publisherID) throws RegistryException {
        try {
            if (business != null && this.connection != null) {
                BusinessServices services;
                Vector contactVector;
                Contacts contacts;
                DiscoveryURLs discURLs;
                CategoryBag catBag;
                IdentifierBag idBag;
                String businessKey = business.getBusinessKey();
                BusinessEntityTable.insert(business, publisherID, this.connection);
                if (business.getNameVector() != null) {
                    BusinessNameTable.insert(businessKey, business.getNameVector(), this.connection);
                }
                if (business.getDescriptionVector() != null) {
                    BusinessDescTable.insert(businessKey, business.getDescriptionVector(), this.connection);
                }
                if ((idBag = business.getIdentifierBag()) != null && idBag.getKeyedReferenceVector() != null) {
                    BusinessIdentifierTable.insert(businessKey, idBag.getKeyedReferenceVector(), this.connection);
                }
                if ((catBag = business.getCategoryBag()) != null && catBag.getKeyedReferenceVector() != null) {
                    BusinessCategoryTable.insert(businessKey, catBag.getKeyedReferenceVector(), this.connection);
                }
                if ((discURLs = business.getDiscoveryURLs()) != null && discURLs.getDiscoveryURLVector() != null) {
                    DiscoveryURLTable.insert(businessKey, discURLs.getDiscoveryURLVector(), this.connection);
                }
                if ((contacts = business.getContacts()) != null && (contactVector = contacts.getContactVector()) != null && contactVector.size() > 0) {
                    ContactTable.insert(businessKey, contacts.getContactVector(), this.connection);
                    int listSize = contactVector.size();
                    for (int contactID = 0; contactID < listSize; ++contactID) {
                        Contact contact = (Contact)contactVector.elementAt(contactID);
                        ContactDescTable.insert(businessKey, contactID, contact.getDescriptionVector(), this.connection);
                        EmailTable.insert(businessKey, contactID, contact.getEmailVector(), this.connection);
                        PhoneTable.insert(businessKey, contactID, contact.getPhoneVector(), this.connection);
                        Vector addrList = contact.getAddressVector();
                        if (addrList == null || addrList.size() <= 0) continue;
                        AddressTable.insert(businessKey, contactID, addrList, this.connection);
                        for (int addrID = 0; addrID < addrList.size(); ++addrID) {
                            Address address = (Address)addrList.elementAt(addrID);
                            AddressLineTable.insert(businessKey, contactID, addrID, address.getAddressLineVector(), this.connection);
                        }
                    }
                }
                if ((services = business.getBusinessServices()) != null && services.getBusinessServiceVector() != null) {
                    UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
                    Vector serviceVector = services.getBusinessServiceVector();
                    int serviceListSize = serviceVector.size();
                    for (int j = 0; j < serviceListSize; ++j) {
                        BusinessService service = (BusinessService)serviceVector.elementAt(j);
                        service.setBusinessKey(businessKey);
                        String serviceKey = service.getServiceKey();
                        if (serviceKey == null || serviceKey.length() == 0) {
                            service.setServiceKey(uuidgen.uuidgen());
                        }
                        this.saveService(service);
                    }
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public BusinessEntity fetchBusiness(String businessKey) throws RegistryException {
        BusinessEntity business = null;
        try {
            if (businessKey != null && this.connection != null) {
                Vector catVector;
                business = BusinessEntityTable.select(businessKey, this.connection);
                business.setNameVector(BusinessNameTable.select(businessKey, this.connection));
                business.setDescriptionVector(BusinessDescTable.select(businessKey, this.connection));
                Vector idVector = BusinessIdentifierTable.select(businessKey, this.connection);
                if (idVector.size() > 0) {
                    IdentifierBag identifierBag = new IdentifierBag();
                    identifierBag.setKeyedReferenceVector(idVector);
                    business.setIdentifierBag(identifierBag);
                }
                if ((catVector = BusinessCategoryTable.select(businessKey, this.connection)).size() > 0) {
                    CategoryBag categoryBag = new CategoryBag();
                    categoryBag.setKeyedReferenceVector(catVector);
                    business.setCategoryBag(categoryBag);
                }
                DiscoveryURLs discoveryURLs = new DiscoveryURLs();
                discoveryURLs.setDiscoveryURLVector(DiscoveryURLTable.select(businessKey, this.connection));
                business.setDiscoveryURLs(discoveryURLs);
                Vector contactList = ContactTable.select(businessKey, this.connection);
                for (int contactID = 0; contactID < contactList.size(); ++contactID) {
                    Contact contact = (Contact)contactList.elementAt(contactID);
                    contact.setPhoneVector(PhoneTable.select(businessKey, contactID, this.connection));
                    contact.setEmailVector(EmailTable.select(businessKey, contactID, this.connection));
                    Vector addressList = AddressTable.select(businessKey, contactID, this.connection);
                    for (int addressID = 0; addressID < addressList.size(); ++addressID) {
                        Address address = (Address)addressList.elementAt(addressID);
                        address.setAddressLineVector(AddressLineTable.select(businessKey, contactID, addressID, this.connection));
                    }
                    contact.setAddressVector(addressList);
                }
                Contacts contacts = new Contacts();
                contacts.setContactVector(contactList);
                business.setContacts(contacts);
                Vector serviceVector = this.fetchServiceByBusinessKey(businessKey);
                BusinessServices services = new BusinessServices();
                services.setBusinessServiceVector(serviceVector);
                business.setBusinessServices(services);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return business;
    }

    public void deleteBusiness(String businessKey) throws RegistryException {
        try {
            if (businessKey != null && this.connection != null) {
                this.deleteServiceByBusinessKey(businessKey);
                AddressLineTable.delete(businessKey, this.connection);
                AddressTable.delete(businessKey, this.connection);
                EmailTable.delete(businessKey, this.connection);
                PhoneTable.delete(businessKey, this.connection);
                ContactDescTable.delete(businessKey, this.connection);
                ContactTable.delete(businessKey, this.connection);
                DiscoveryURLTable.delete(businessKey, this.connection);
                BusinessIdentifierTable.delete(businessKey, this.connection);
                BusinessCategoryTable.delete(businessKey, this.connection);
                BusinessDescTable.delete(businessKey, this.connection);
                BusinessNameTable.delete(businessKey, this.connection);
                BusinessEntityTable.delete(businessKey, this.connection);
            }
        }
        catch (SQLException sqlex) {
            log.error(sqlex.getMessage(), sqlex);
            throw new RegistryException(sqlex);
        }
    }

    public boolean isBusinessPublisher(String businessKey, String publisherID) throws RegistryException {
        try {
            if (publisherID != null && businessKey != null && this.connection != null) {
                return BusinessEntityTable.verifyOwnership(businessKey, publisherID, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return false;
    }

    public boolean isValidBusinessKey(String businessKey) throws RegistryException {
        try {
            if (businessKey != null && this.connection != null && BusinessEntityTable.select(businessKey, this.connection) != null) {
                return true;
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return false;
    }

    public void saveService(BusinessService service) throws RegistryException {
        try {
            if (service != null && this.connection != null) {
                BindingTemplates bindings;
                CategoryBag catBag;
                String serviceKey = service.getServiceKey();
                BusinessServiceTable.insert(service, this.connection);
                if (service.getNameVector() != null) {
                    ServiceNameTable.insert(serviceKey, service.getNameVector(), this.connection);
                }
                if (service.getDescriptionVector() != null) {
                    ServiceDescTable.insert(serviceKey, service.getDescriptionVector(), this.connection);
                }
                if ((catBag = service.getCategoryBag()) != null && catBag.getKeyedReferenceVector() != null) {
                    ServiceCategoryTable.insert(serviceKey, catBag.getKeyedReferenceVector(), this.connection);
                }
                if ((bindings = service.getBindingTemplates()) == null) {
                    return;
                }
                Vector bindingList = bindings.getBindingTemplateVector();
                if (bindingList == null) {
                    return;
                }
                UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
                int listSize = bindingList.size();
                for (int i = 0; i < listSize; ++i) {
                    BindingTemplate binding = (BindingTemplate)bindingList.elementAt(i);
                    binding.setServiceKey(serviceKey);
                    String bindingKey = binding.getBindingKey();
                    if (bindingKey == null || bindingKey.length() == 0) {
                        binding.setBindingKey(uuidgen.uuidgen());
                    }
                    this.saveBinding(binding);
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public BusinessService fetchService(String serviceKey) throws RegistryException {
        BusinessService service = null;
        try {
            if (serviceKey != null && this.connection != null) {
                service = BusinessServiceTable.select(serviceKey, this.connection);
                service.setNameVector(ServiceNameTable.select(serviceKey, this.connection));
                service.setDescriptionVector(ServiceDescTable.select(serviceKey, this.connection));
                Vector catVector = ServiceCategoryTable.select(serviceKey, this.connection);
                if (catVector.size() > 0) {
                    CategoryBag bag = new CategoryBag();
                    bag.setKeyedReferenceVector(catVector);
                    service.setCategoryBag(bag);
                }
                Vector bindingVector = this.fetchBindingByServiceKey(serviceKey);
                BindingTemplates bindings = new BindingTemplates();
                bindings.setBindingTemplateVector(bindingVector);
                service.setBindingTemplates(bindings);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return service;
    }

    public void deleteService(String serviceKey) throws RegistryException {
        try {
            if (serviceKey != null && this.connection != null) {
                this.deleteBindingByServiceKey(serviceKey);
                ServiceNameTable.delete(serviceKey, this.connection);
                ServiceDescTable.delete(serviceKey, this.connection);
                ServiceCategoryTable.delete(serviceKey, this.connection);
                BusinessServiceTable.delete(serviceKey, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    private Vector fetchServiceByBusinessKey(String businessKey) throws RegistryException {
        Vector<BusinessService> serviceList = new Vector<BusinessService>();
        try {
            if (businessKey != null && this.connection != null) {
                Vector tempList = BusinessServiceTable.selectByBusinessKey(businessKey, this.connection);
                for (int i = 0; i < tempList.size(); ++i) {
                    BusinessService service = (BusinessService)tempList.elementAt(i);
                    serviceList.add(this.fetchService(service.getServiceKey()));
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return serviceList;
    }

    private void deleteServiceByBusinessKey(String businessKey) throws RegistryException {
        try {
            if (businessKey != null && this.connection != null) {
                Vector services = BusinessServiceTable.selectByBusinessKey(businessKey, this.connection);
                int listSize = services.size();
                for (int i = 0; i < listSize; ++i) {
                    BusinessService service = (BusinessService)services.elementAt(i);
                    this.deleteService(service.getServiceKey());
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public boolean isValidServiceKey(String serviceKey) throws RegistryException {
        try {
            if (serviceKey != null && this.connection != null && BusinessServiceTable.select(serviceKey, this.connection) != null) {
                return true;
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return false;
    }

    public boolean isServicePublisher(String serviceKey, String publisherID) throws RegistryException {
        try {
            if (publisherID != null && serviceKey != null && this.connection != null) {
                return BusinessServiceTable.verifyOwnership(serviceKey, publisherID, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return false;
    }

    public void saveBinding(BindingTemplate binding) throws RegistryException {
        try {
            if (binding != null && this.connection != null) {
                TModelInstanceDetails details;
                String bindingKey = binding.getBindingKey();
                BindingTemplateTable.insert(binding, this.connection);
                CategoryBag catBag = binding.getCategoryBag();
                if (catBag != null && catBag.getKeyedReferenceVector() != null) {
                    BindingCategoryTable.insert(bindingKey, catBag.getKeyedReferenceVector(), this.connection);
                }
                if (binding.getDescriptionVector() != null) {
                    BindingDescTable.insert(bindingKey, binding.getDescriptionVector(), this.connection);
                }
                if ((details = binding.getTModelInstanceDetails()) == null) {
                    return;
                }
                Vector detailsVector = details.getTModelInstanceInfoVector();
                if (detailsVector == null) {
                    return;
                }
                TModelInstanceInfoTable.insert(bindingKey, detailsVector, this.connection);
                Vector infoList = details.getTModelInstanceInfoVector();
                int listSize = infoList.size();
                for (int infoID = 0; infoID < listSize; ++infoID) {
                    TModelInstanceInfo info = (TModelInstanceInfo)infoList.elementAt(infoID);
                    TModelInstanceInfoDescTable.insert(binding.getBindingKey(), infoID, info.getDescriptionVector(), this.connection);
                    InstanceDetails instDetails = info.getInstanceDetails();
                    if (instDetails == null) continue;
                    InstanceDetailsDescTable.insert(binding.getBindingKey(), infoID, instDetails.getDescriptionVector(), this.connection);
                    OverviewDoc overDoc = instDetails.getOverviewDoc();
                    if (overDoc == null) continue;
                    InstanceDetailsDocDescTable.insert(binding.getBindingKey(), infoID, overDoc.getDescriptionVector(), this.connection);
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public BindingTemplate fetchBinding(String bindingKey) throws RegistryException {
        BindingTemplate binding = null;
        try {
            if (bindingKey != null && this.connection != null) {
                binding = BindingTemplateTable.select(bindingKey, this.connection);
                binding.setDescriptionVector(BindingDescTable.select(bindingKey, this.connection));
                CategoryBag bag = new CategoryBag();
                bag.setKeyedReferenceVector(BindingCategoryTable.select(bindingKey, this.connection));
                binding.setCategoryBag(bag);
                Vector infoVector = TModelInstanceInfoTable.select(bindingKey, this.connection);
                if (infoVector != null) {
                    int vectorSize = infoVector.size();
                    for (int infoID = 0; infoID < vectorSize; ++infoID) {
                        TModelInstanceInfo info = (TModelInstanceInfo)infoVector.elementAt(infoID);
                        info.setDescriptionVector(TModelInstanceInfoDescTable.select(bindingKey, infoID, this.connection));
                        InstanceDetails instDetails = info.getInstanceDetails();
                        if (instDetails == null) continue;
                        instDetails.setDescriptionVector(InstanceDetailsDescTable.select(bindingKey, infoID, this.connection));
                        OverviewDoc overDoc = instDetails.getOverviewDoc();
                        if (overDoc == null) continue;
                        overDoc.setDescriptionVector(InstanceDetailsDocDescTable.select(bindingKey, infoID, this.connection));
                        instDetails.setOverviewDoc(overDoc);
                    }
                    TModelInstanceDetails details = new TModelInstanceDetails();
                    details.setTModelInstanceInfoVector(infoVector);
                    binding.setTModelInstanceDetails(details);
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return binding;
    }

    public void deleteBinding(String bindingKey) throws RegistryException {
        try {
            if (bindingKey != null && this.connection != null) {
                BindingDescTable.delete(bindingKey, this.connection);
                BindingCategoryTable.delete(bindingKey, this.connection);
                TModelInstanceInfoDescTable.delete(bindingKey, this.connection);
                InstanceDetailsDocDescTable.delete(bindingKey, this.connection);
                InstanceDetailsDescTable.delete(bindingKey, this.connection);
                TModelInstanceInfoTable.delete(bindingKey, this.connection);
                BindingTemplateTable.delete(bindingKey, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    private Vector fetchBindingByServiceKey(String serviceKey) throws RegistryException {
        Vector<BindingTemplate> bindingList = new Vector<BindingTemplate>();
        try {
            if (serviceKey != null && this.connection != null) {
                Vector tempList = BindingTemplateTable.selectByServiceKey(serviceKey, this.connection);
                for (int i = 0; i < tempList.size(); ++i) {
                    BindingTemplate binding = (BindingTemplate)tempList.elementAt(i);
                    bindingList.add(this.fetchBinding(binding.getBindingKey()));
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return bindingList;
    }

    private void deleteBindingByServiceKey(String serviceKey) throws RegistryException {
        try {
            if (serviceKey != null && this.connection != null) {
                Vector bindings = BindingTemplateTable.selectByServiceKey(serviceKey, this.connection);
                int listSize = bindings.size();
                for (int i = 0; i < listSize; ++i) {
                    BindingTemplate binding = (BindingTemplate)bindings.elementAt(i);
                    this.deleteBinding(binding.getBindingKey());
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public boolean isValidBindingKey(String bindingKey) throws RegistryException {
        try {
            if (bindingKey != null && this.connection != null && BindingTemplateTable.select(bindingKey, this.connection) != null) {
                return true;
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return false;
    }

    public boolean isBindingPublisher(String bindingKey, String publisherID) throws RegistryException {
        try {
            if (publisherID != null && bindingKey != null && this.connection != null) {
                return BindingTemplateTable.verifyOwnership(bindingKey, publisherID, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return false;
    }

    public void saveTModel(TModel tModel, String authorizedUserID) throws RegistryException {
        try {
            if (tModel != null && this.connection != null) {
                Vector descVector;
                OverviewDoc overDoc;
                CategoryBag catBag;
                IdentifierBag idBag;
                String tModelKey = tModel.getTModelKey();
                TModelTable.insert(tModel, authorizedUserID, this.connection);
                if (tModel.getDescriptionVector() != null) {
                    TModelDescTable.insert(tModelKey, tModel.getDescriptionVector(), this.connection);
                }
                if ((idBag = tModel.getIdentifierBag()) != null && idBag.getKeyedReferenceVector() != null) {
                    TModelIdentifierTable.insert(tModelKey, idBag.getKeyedReferenceVector(), this.connection);
                }
                if ((catBag = tModel.getCategoryBag()) != null && catBag.getKeyedReferenceVector() != null) {
                    TModelCategoryTable.insert(tModelKey, catBag.getKeyedReferenceVector(), this.connection);
                }
                if ((overDoc = tModel.getOverviewDoc()) != null && overDoc.getDescriptionVector() != null && (descVector = overDoc.getDescriptionVector()) != null && descVector.size() > 0) {
                    TModelDocDescTable.insert(tModelKey, descVector, this.connection);
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public TModel fetchTModel(String tModelKey) throws RegistryException {
        TModel tModel = null;
        try {
            if (tModelKey != null && this.connection != null && (tModel = TModelTable.select(tModelKey, this.connection)) != null) {
                OverviewDoc overDoc;
                Vector idVector;
                tModel.setDescriptionVector(TModelDescTable.select(tModelKey, this.connection));
                Vector catVector = TModelCategoryTable.select(tModelKey, this.connection);
                if (catVector != null && catVector.size() != 0) {
                    CategoryBag catBag = new CategoryBag();
                    catBag.setKeyedReferenceVector(catVector);
                    tModel.setCategoryBag(catBag);
                }
                if ((idVector = TModelIdentifierTable.select(tModelKey, this.connection)) != null && idVector.size() != 0) {
                    IdentifierBag idBag = new IdentifierBag();
                    idBag.setKeyedReferenceVector(idVector);
                    tModel.setIdentifierBag(idBag);
                }
                if ((overDoc = tModel.getOverviewDoc()) != null) {
                    overDoc.setDescriptionVector(TModelDocDescTable.select(tModelKey, this.connection));
                    tModel.setOverviewDoc(overDoc);
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return tModel;
    }

    public void deleteTModel(String tModelKey) throws RegistryException {
        try {
            if (tModelKey != null && this.connection != null) {
                TModelCategoryTable.delete(tModelKey, this.connection);
                TModelDescTable.delete(tModelKey, this.connection);
                TModelDocDescTable.delete(tModelKey, this.connection);
                TModelIdentifierTable.delete(tModelKey, this.connection);
                TModelTable.delete(tModelKey, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public void markTModelAsDeleted(String tModelKey) throws RegistryException {
        try {
            if (tModelKey != null && this.connection != null) {
                TModelTable.markAsDeleted(tModelKey, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public boolean isValidTModelKey(String tModelKey) throws RegistryException {
        try {
            if (tModelKey != null && this.connection != null && TModelTable.select(tModelKey, this.connection) != null) {
                return true;
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return false;
    }

    public boolean isTModelPublisher(String tModelKey, String publisherID) throws RegistryException {
        try {
            if (publisherID != null && tModelKey != null && this.connection != null) {
                return TModelTable.verifyOwnership(tModelKey, publisherID, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return false;
    }

    public BusinessInfo fetchBusinessInfo(String businessKey) throws RegistryException {
        BusinessInfo info = null;
        if (businessKey != null && this.connection != null) {
            try {
                info = new BusinessInfo();
                info.setBusinessKey(businessKey);
                info.setNameVector(BusinessNameTable.select(businessKey, this.connection));
                info.setDescriptionVector(BusinessDescTable.select(businessKey, this.connection));
                info.setServiceInfos(this.fetchServiceInfosByBusinessKey(businessKey));
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
        return info;
    }

    private ServiceInfos fetchServiceInfosByBusinessKey(String businessKey) throws RegistryException {
        Vector<ServiceInfo> serviceInfoVector = new Vector<ServiceInfo>();
        if (businessKey != null && this.connection != null) {
            try {
                Vector services = BusinessServiceTable.selectByBusinessKey(businessKey, this.connection);
                for (int i = 0; i < services.size(); ++i) {
                    BusinessService service = (BusinessService)services.elementAt(i);
                    String serviceKey = service.getServiceKey();
                    ServiceInfo info = new ServiceInfo();
                    info.setServiceKey(serviceKey);
                    info.setBusinessKey(businessKey);
                    info.setNameVector(ServiceNameTable.select(serviceKey, this.connection));
                    serviceInfoVector.add(info);
                }
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
        ServiceInfos serviceInfos = new ServiceInfos();
        serviceInfos.setServiceInfoVector(serviceInfoVector);
        return serviceInfos;
    }

    public ServiceInfo fetchServiceInfo(String serviceKey) throws RegistryException {
        ServiceInfo info = null;
        if (serviceKey != null && this.connection != null) {
            try {
                BusinessService service = BusinessServiceTable.select(serviceKey, this.connection);
                if (service != null) {
                    info = new ServiceInfo();
                    info.setServiceKey(service.getServiceKey());
                    info.setBusinessKey(service.getBusinessKey());
                    info.setNameVector(ServiceNameTable.select(serviceKey, this.connection));
                }
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
        return info;
    }

    public TModelInfo fetchTModelInfo(String tModelKey) throws RegistryException {
        TModelInfo info = null;
        if (tModelKey != null && this.connection != null) {
            try {
                TModel tModel = TModelTable.select(tModelKey, this.connection);
                info = new TModelInfo();
                info.setTModelKey(tModelKey);
                info.setName(tModel.getName());
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
        return info;
    }

    public Vector findBusiness(Vector nameVector, DiscoveryURLs discoveryURLs, IdentifierBag identifierBag, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers) throws RegistryException {
        Vector keyVector = null;
        try {
            if (discoveryURLs != null && discoveryURLs.size() > 0) {
                keyVector = FindBusinessByDiscoveryURLQuery.select(discoveryURLs, keyVector, findQualifiers, this.connection);
            }
            if (findQualifiers != null && findQualifiers.orAllKeys) {
                if (tModelBag != null && tModelBag.size() > 0) {
                    keyVector = FindBusinessByTModelKeyQuery.select(tModelBag, keyVector, findQualifiers, this.connection);
                }
                if (categoryBag != null && categoryBag.size() > 0) {
                    keyVector = FindBusinessByCategoryQuery.select(categoryBag, keyVector, findQualifiers, this.connection);
                }
            } else {
                Vector keyedRefVector;
                int i;
                Vector tModelKeyVector;
                if (tModelBag != null && tModelBag.size() > 0 && (tModelKeyVector = tModelBag.getTModelKeyVector()) != null) {
                    for (i = 0; i < tModelKeyVector.size(); ++i) {
                        String tModelKey = (String)tModelKeyVector.elementAt(i);
                        keyVector = FindBusinessByTModelKeyQuery.select(tModelKey, keyVector, findQualifiers, this.connection);
                    }
                }
                if (categoryBag != null && categoryBag.size() > 0 && (keyedRefVector = categoryBag.getKeyedReferenceVector()) != null) {
                    for (i = 0; i < keyedRefVector.size(); ++i) {
                        KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                        keyVector = FindBusinessByCategoryQuery.select(keyedRef, keyVector, findQualifiers, this.connection);
                    }
                }
            }
            if (identifierBag != null && identifierBag.size() > 0) {
                keyVector = FindBusinessByIdentifierQuery.select(identifierBag, keyVector, findQualifiers, this.connection);
            }
            keyVector = FindBusinessByNameQuery.select(nameVector, keyVector, findQualifiers, this.connection);
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return keyVector;
    }

    public Vector findService(String businessKey, Vector nameVector, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers) throws RegistryException {
        Vector keyVector = null;
        try {
            if (businessKey != null) {
                keyVector = FindServiceByBusinessKeyQuery.select(businessKey, keyVector, findQualifiers, this.connection);
            }
            if (findQualifiers != null && findQualifiers.orAllKeys) {
                if (tModelBag != null && tModelBag.size() > 0) {
                    keyVector = FindServiceByTModelKeyQuery.select(businessKey, tModelBag, keyVector, findQualifiers, this.connection);
                }
                if (categoryBag != null && categoryBag.size() > 0) {
                    keyVector = FindServiceByCategoryQuery.select(businessKey, categoryBag, keyVector, findQualifiers, this.connection);
                }
            } else {
                Vector keyedRefVector;
                int i;
                Vector tModelKeyVector;
                if (tModelBag != null && tModelBag.size() > 0 && (tModelKeyVector = tModelBag.getTModelKeyVector()) != null) {
                    for (i = 0; i < tModelKeyVector.size(); ++i) {
                        String tModelKey = (String)tModelKeyVector.elementAt(i);
                        keyVector = FindServiceByTModelKeyQuery.select(businessKey, tModelKey, keyVector, findQualifiers, this.connection);
                    }
                }
                if (categoryBag != null && categoryBag.size() > 0 && (keyedRefVector = categoryBag.getKeyedReferenceVector()) != null) {
                    for (i = 0; i < keyedRefVector.size(); ++i) {
                        KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                        keyVector = FindServiceByCategoryQuery.select(businessKey, keyedRef, keyVector, findQualifiers, this.connection);
                    }
                }
            }
            keyVector = FindServiceByNameQuery.select(businessKey, nameVector, keyVector, findQualifiers, this.connection);
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return keyVector;
    }

    public Vector findTModel(String name, CategoryBag categoryBag, IdentifierBag identifierBag, FindQualifiers findQualifiers) throws RegistryException {
        Vector keyVector = null;
        try {
            Vector keyedRefVector;
            if (findQualifiers != null && findQualifiers.orAllKeys) {
                if (categoryBag != null && categoryBag.size() > 0) {
                    keyVector = FindTModelByCategoryQuery.select(categoryBag, keyVector, findQualifiers, this.connection);
                }
            } else if (categoryBag != null && categoryBag.size() > 0 && (keyedRefVector = categoryBag.getKeyedReferenceVector()) != null) {
                for (int i = 0; i < keyedRefVector.size(); ++i) {
                    KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                    keyVector = FindTModelByCategoryQuery.select(keyedRef, keyVector, findQualifiers, this.connection);
                }
            }
            if (identifierBag != null && identifierBag.size() > 0) {
                keyVector = FindTModelByIdentifierQuery.select(identifierBag, keyVector, findQualifiers, this.connection);
            }
            keyVector = FindTModelByNameQuery.select(name, keyVector, findQualifiers, this.connection);
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return keyVector;
    }

    public Vector findBinding(String serviceKey, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers) throws RegistryException {
        Vector keyVector = null;
        try {
            if (serviceKey != null) {
                keyVector = FindBindingByServiceKeyQuery.select(serviceKey, keyVector, findQualifiers, this.connection);
            }
            if (findQualifiers != null && findQualifiers.orAllKeys) {
                if (tModelBag != null && tModelBag.size() > 0) {
                    keyVector = FindBindingByTModelKeyQuery.select(serviceKey, tModelBag, keyVector, findQualifiers, this.connection);
                }
                if (categoryBag != null && categoryBag.size() > 0) {
                    keyVector = FindBindingByCategoryQuery.select(serviceKey, categoryBag, keyVector, findQualifiers, this.connection);
                }
            } else {
                Vector keyedRefVector;
                int i;
                Vector tModelKeyVector;
                if (tModelBag != null && tModelBag.size() > 0 && (tModelKeyVector = tModelBag.getTModelKeyVector()) != null) {
                    for (i = 0; i < tModelKeyVector.size(); ++i) {
                        String tModelKey = (String)tModelKeyVector.elementAt(i);
                        keyVector = FindBindingByTModelKeyQuery.select(serviceKey, tModelKey, keyVector, findQualifiers, this.connection);
                    }
                }
                if (categoryBag != null && categoryBag.size() > 0 && (keyedRefVector = categoryBag.getKeyedReferenceVector()) != null) {
                    for (i = 0; i < keyedRefVector.size(); ++i) {
                        KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                        keyVector = FindBindingByCategoryQuery.select(serviceKey, keyedRef, keyVector, findQualifiers, this.connection);
                    }
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return keyVector;
    }

    public Vector findRelatedBusinesses(String businessKey, KeyedReference keyedRef, FindQualifiers findQualifiers) throws RegistryException {
        Vector keyVector = null;
        Vector<RelatedBusinessInfo> infoVector = null;
        try {
            keyVector = keyedRef == null ? FindRelatedBusinessQuery.select(businessKey, this.connection) : FindRelatedBusinessQuery.selectWithKeyedRef(businessKey, keyedRef, this.connection);
            keyVector = FindBusinessByNameQuery.select(null, keyVector, findQualifiers, this.connection);
            int rowCount = keyVector.size();
            infoVector = new Vector<RelatedBusinessInfo>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                String relatedKey = (String)keyVector.elementAt(i);
                BusinessInfo bizInfo = this.fetchBusinessInfo(relatedKey);
                if (bizInfo == null) continue;
                RelatedBusinessInfo relatedBizInfo = new RelatedBusinessInfo();
                relatedBizInfo.setBusinessKey(bizInfo.getBusinessKey());
                relatedBizInfo.setNameVector(bizInfo.getNameVector());
                relatedBizInfo.setDescriptionVector(bizInfo.getDescriptionVector());
                Vector keyedReferences = PublisherAssertionTable.selectRelatedBusinesses(businessKey, relatedKey, this.connection);
                relatedBizInfo.setSharedRelationships(new SharedRelationships(keyedReferences));
                infoVector.addElement(relatedBizInfo);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return infoVector;
    }

    public Vector findRegisteredBusinesses(String publisherID) throws RegistryException {
        Vector keyVector = null;
        try {
            keyVector = BusinessEntityTable.selectByPublisherID(publisherID, this.connection);
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return keyVector;
    }

    public Vector findRegisteredTModels(String publisherID) throws RegistryException {
        Vector keyVector = null;
        try {
            keyVector = TModelTable.selectByPublisherID(publisherID, this.connection);
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return keyVector;
    }

    public void saveAssertions(String publisherID, Vector assertions) throws RegistryException {
        try {
            for (int i = 0; i < assertions.size(); ++i) {
                PublisherAssertion assertion = (PublisherAssertion)assertions.elementAt(i);
                String fromKey = assertion.getFromKey();
                String toKey = assertion.getToKey();
                boolean fromCheck = BusinessEntityTable.verifyOwnership(fromKey, publisherID, this.connection);
                boolean toCheck = BusinessEntityTable.verifyOwnership(toKey, publisherID, this.connection);
                if (PublisherAssertionTable.select(assertion, this.connection) == null) {
                    PublisherAssertionTable.insert(assertion, fromCheck, toCheck, this.connection);
                    continue;
                }
                if (fromCheck) {
                    PublisherAssertionTable.updateFromCheck(assertion, fromCheck, this.connection);
                }
                if (!toCheck) continue;
                PublisherAssertionTable.updateToCheck(assertion, toCheck, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public void deleteAssertions(String publisherID, Vector assertions) throws RegistryException {
        try {
            for (int i = 0; i < assertions.size(); ++i) {
                String toID;
                PublisherAssertion assertion = (PublisherAssertion)assertions.elementAt(i);
                String fromID = BusinessEntityTable.selectPublisherID(assertion.getFromKey(), this.connection);
                if (publisherID.equalsIgnoreCase(fromID)) {
                    PublisherAssertionTable.updateFromCheck(assertion, false, this.connection);
                }
                if (!publisherID.equalsIgnoreCase(toID = BusinessEntityTable.selectPublisherID(assertion.getToKey(), this.connection))) continue;
                PublisherAssertionTable.updateToCheck(assertion, false, this.connection);
            }
            if (assertions.size() > 0) {
                PublisherAssertionTable.deleteDeadAssertions(this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public Vector getAssertions(String publisherID) throws RegistryException {
        Vector assertions = null;
        try {
            Vector keys = BusinessEntityTable.selectByPublisherID(publisherID, this.connection);
            assertions = PublisherAssertionTable.selectAssertions(keys, this.connection);
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return assertions;
    }

    public Vector setAssertions(String publisherID, Vector newAssertions) throws RegistryException {
        Vector oldAssertions = this.getAssertions(publisherID);
        this.deleteAssertions(publisherID, oldAssertions);
        this.saveAssertions(publisherID, newAssertions);
        return newAssertions;
    }

    public Vector getAssertionStatusItems(String publisherID, String completionStatus) throws RegistryException {
        Vector<AssertionStatusItem> items = null;
        try {
            Vector keys = BusinessEntityTable.selectByPublisherID(publisherID, this.connection);
            Vector<AssertionStatusItem> allItems = new Vector<AssertionStatusItem>();
            allItems.addAll(PublisherAssertionTable.selectBothKeysOwnedAssertion(keys, this.connection));
            allItems.addAll(PublisherAssertionTable.selectFromKeyOwnedAssertion(keys, this.connection));
            allItems.addAll(PublisherAssertionTable.selectToKeyOwnedAssertion(keys, this.connection));
            if (completionStatus == null || completionStatus.length() == 0) {
                items = allItems;
            } else {
                if (allItems.size() > 0) {
                    items = new Vector();
                }
                for (int i = 0; i < allItems.size(); ++i) {
                    AssertionStatusItem item = (AssertionStatusItem)allItems.elementAt(i);
                    CompletionStatus status = item.getCompletionStatus();
                    if (!status.getValue().equalsIgnoreCase(completionStatus)) continue;
                    items.addElement(item);
                }
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return items;
    }

    public void savePublisher(Publisher publisher) throws RegistryException {
        try {
            if (publisher != null && this.connection != null) {
                PublisherTable.insert(publisher, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public void deletePublisher(String publisherID) throws RegistryException {
        try {
            if (publisherID != null && this.connection != null) {
                PublisherTable.delete(publisherID, this.connection);
            }
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
    }

    public PublisherInfo fetchPublisherInfo(String publisherID) throws RegistryException {
        PublisherInfo info = null;
        if (publisherID != null && this.connection != null) {
            try {
                Publisher publisher = PublisherTable.select(publisherID, this.connection);
                info = new PublisherInfo();
                info.setPublisherID(publisherID);
                info.setNameValue(publisher.getName());
            }
            catch (SQLException sqlex) {
                throw new RegistryException(sqlex);
            }
        }
        return info;
    }

    public Vector findPublisher(String name, FindQualifiers findQualifiers) throws RegistryException {
        Vector keyVector = null;
        try {
            keyVector = FindPublisherByNameQuery.select(name, keyVector, findQualifiers, this.connection);
        }
        catch (SQLException sqlex) {
            throw new RegistryException(sqlex);
        }
        return keyVector;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

