/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.codegen.HierarchyNode;
import org.eclipse.persistence.sessions.Project;

public class InheritanceHierarchyBuilder {
    public static HierarchyNode getNodeForClass(String className, Hashtable hierarchyTree) {
        HierarchyNode node = (HierarchyNode)hierarchyTree.get(className);
        if (node == null) {
            node = new HierarchyNode(className);
            hierarchyTree.put(className, node);
        }
        return node;
    }

    public static Hashtable buildInheritanceHierarchyTree(Project project) {
        Map descriptors = project.getDescriptors();
        Hashtable hierarchyTree = new Hashtable(descriptors.size());
        for (ClassDescriptor descriptor : descriptors.values()) {
            String className = descriptor.getJavaClassName();
            if (className == null) {
                className = descriptor.getJavaClass().getName();
            }
            HierarchyNode node = InheritanceHierarchyBuilder.getNodeForClass(className, hierarchyTree);
            if (!descriptor.hasInheritance() || descriptor.getInheritancePolicy().getParentClassName() == null) continue;
            HierarchyNode parentNode = InheritanceHierarchyBuilder.getNodeForClass(descriptor.getInheritancePolicy().getParentClassName(), hierarchyTree);
            node.setParent(parentNode);
        }
        return hierarchyTree;
    }
}

