/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.tree.FieldNode;
import org.eclipse.persistence.internal.libraries.asm.tree.InnerClassNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodNode;

public class ClassNode {
    public int version;
    public int access;
    public String name;
    public String superName;
    public final List interfaces;
    public String sourceFile;
    public final List innerClasses;
    public final List fields;
    public final List methods;
    public Attribute attrs;

    public ClassNode(int version2, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.version = version2;
        this.access = access;
        this.name = name;
        this.superName = superName;
        this.interfaces = new ArrayList();
        this.sourceFile = sourceFile;
        this.innerClasses = new ArrayList();
        this.fields = new ArrayList();
        this.methods = new ArrayList();
        if (interfaces != null) {
            this.interfaces.addAll((Collection)Arrays.asList(interfaces));
        }
    }

    public void accept(ClassVisitor cv) {
        String[] interfaces = new String[this.interfaces.size()];
        this.interfaces.toArray(interfaces);
        cv.visit(this.version, this.access, this.name, this.superName, interfaces, this.sourceFile);
        int i = 0;
        while (i < this.innerClasses.size()) {
            ((InnerClassNode)this.innerClasses.get(i)).accept(cv);
            ++i;
        }
        i = 0;
        while (i < this.fields.size()) {
            ((FieldNode)this.fields.get(i)).accept(cv);
            ++i;
        }
        i = 0;
        while (i < this.methods.size()) {
            ((MethodNode)this.methods.get(i)).accept(cv);
            ++i;
        }
        Attribute attrs = this.attrs;
        while (attrs != null) {
            cv.visitAttribute(attrs);
            attrs = attrs.next;
        }
        cv.visitEnd();
    }
}

