/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.documentpreservation.DescriptorLevelDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.documentpreservation.NoDocumentPreservationPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLBinder;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.XMLValidator;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.platform.SAXPlatform;
import org.eclipse.persistence.oxm.platform.XMLPlatform;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

public class XMLContext {
    private List sessions;
    private Map descriptorsByQName;
    private Map descriptorsByGlobalType;
    private boolean hasDocumentPreservation = false;

    public XMLContext(String sessionNames) {
        this(sessionNames, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class));
    }

    public XMLContext(String sessionNames, ClassLoader classLoader) {
        this(sessionNames, classLoader, null);
    }

    public XMLContext(String sessionNames, String xmlResource) {
        this(sessionNames, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class), xmlResource);
    }

    public XMLContext(String sessionNames, ClassLoader classLoader, String xmlResource) {
        XMLSessionConfigLoader loader = null;
        loader = xmlResource != null ? new XMLSessionConfigLoader(xmlResource) : new XMLSessionConfigLoader();
        this.descriptorsByQName = new HashMap();
        this.descriptorsByGlobalType = new HashMap();
        StringTokenizer st = new StringTokenizer(sessionNames, ":");
        this.sessions = new ArrayList(st.countTokens());
        int index = 0;
        while (st.hasMoreTokens()) {
            this.sessions.add(this.buildSession(st.nextToken(), classLoader, loader));
            ++index;
        }
        for (int x = index - 1; x >= 0; --x) {
            this.storeXMLDescriptorsByQName((DatabaseSession)this.sessions.get(x));
        }
    }

    public XMLContext(Project project) {
        this(project, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Project project, ClassLoader classLoader) {
        if (project.getDatasourceLogin() == null || !(project.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
            SAXPlatform platform = new SAXPlatform();
            platform.getConversionManager().setLoader(classLoader);
            project.setLogin(new XMLLogin(platform));
        }
        this.sessions = new ArrayList(1);
        DatabaseSession session = project.createDatabaseSession();
        session.setLogLevel(8);
        this.setupDocumentPreservationPolicy(session);
        session.login();
        this.sessions.add(session);
        this.descriptorsByQName = new HashMap();
        this.descriptorsByGlobalType = new HashMap();
        this.storeXMLDescriptorsByQName(session);
    }

    public XMLContext(Collection projects) {
        this(projects, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Collection projects, ClassLoader classLoader) {
        Iterator iterator = projects.iterator();
        this.sessions = new ArrayList(projects.size());
        this.descriptorsByQName = new HashMap();
        this.descriptorsByGlobalType = new HashMap();
        while (iterator.hasNext()) {
            Project project = (Project)iterator.next();
            if (project.getDatasourceLogin() == null || !(project.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                SAXPlatform platform = new SAXPlatform();
                platform.getConversionManager().setLoader(classLoader);
                project.setLogin(new XMLLogin(platform));
            }
            DatabaseSession session = project.createDatabaseSession();
            session.setLogLevel(8);
            this.setupDocumentPreservationPolicy(session);
            session.login();
            this.sessions.add(session);
            this.storeXMLDescriptorsByQName(session);
        }
    }

    private DatabaseSession buildSession(String sessionName, ClassLoader classLoader, XMLSessionConfigLoader sessionLoader) throws XMLMarshalException {
        DatabaseSession dbSession = classLoader != null ? (DatabaseSession)((Object)SessionManager.getManager().getSession(sessionLoader, sessionName, classLoader, false, true)) : (DatabaseSession)((Object)SessionManager.getManager().getSession(sessionLoader, sessionName, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(this.getClass()), false, false, false));
        if (dbSession.getDatasourceLogin() == null || !(dbSession.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
            SAXPlatform platform = new SAXPlatform();
            dbSession.setLogin(new XMLLogin(platform));
        }
        DatabaseSession session = dbSession.getProject().createDatabaseSession();
        if (dbSession.getEventManager().hasListeners()) {
            Vector listeners = dbSession.getEventManager().getListeners();
            int listenersSize = listeners.size();
            for (int x = 0; x < listenersSize; ++x) {
                session.getEventManager().addListener((SessionEventListener)listeners.get(x));
            }
        }
        session.setExceptionHandler(dbSession.getExceptionHandler());
        session.setLogLevel(8);
        this.setupDocumentPreservationPolicy(session);
        session.login();
        return session;
    }

    public void addSession(DatabaseSession sessionToAdd) {
        if (sessionToAdd.getDatasourceLogin() == null || !(sessionToAdd.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
            SAXPlatform platform = new SAXPlatform();
            sessionToAdd.setLogin(new XMLLogin(platform));
        }
        DatabaseSession session = sessionToAdd.getProject().createDatabaseSession();
        if (sessionToAdd.getEventManager().hasListeners()) {
            Vector listeners = sessionToAdd.getEventManager().getListeners();
            int listenersSize = listeners.size();
            for (int x = 0; x < listenersSize; ++x) {
                session.getEventManager().addListener((SessionEventListener)listeners.get(x));
            }
        }
        session.setExceptionHandler(sessionToAdd.getExceptionHandler());
        session.setLogLevel(8);
        this.setupDocumentPreservationPolicy(session);
        session.login();
        this.sessions.add(session);
        this.storeXMLDescriptorsByQName(session);
    }

    public XMLUnmarshaller createUnmarshaller() {
        XMLUnmarshaller unmarshaller = new XMLUnmarshaller(this);
        return unmarshaller;
    }

    public XMLBinder createBinder() {
        return new XMLBinder(this);
    }

    public XMLMarshaller createMarshaller() {
        XMLMarshaller marshaller = new XMLMarshaller(this);
        return marshaller;
    }

    public XMLValidator createValidator() {
        XMLValidator validator = new XMLValidator(this);
        return validator;
    }

    public AbstractSession getReadSession(Object object) {
        if (null == object) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            XMLDescriptor xmlDescriptor = (XMLDescriptor)next.getDescriptor(object);
            if (xmlDescriptor == null) continue;
            next = next.acquireUnitOfWork();
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
    }

    public AbstractSession getReadSession(Class clazz) {
        if (null == clazz) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            XMLDescriptor xmlDescriptor = (XMLDescriptor)next.getDescriptor(clazz);
            if (xmlDescriptor == null) continue;
            next = next.acquireUnitOfWork();
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
    }

    public AbstractSession getReadSession(XMLDescriptor xmlDescriptor) {
        if (null == xmlDescriptor) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            if (!next.getProject().getOrderedDescriptors().contains(xmlDescriptor)) continue;
            next = next.acquireUnitOfWork();
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(xmlDescriptor.getJavaClass().getName());
    }

    public List getSessions() {
        return this.sessions;
    }

    public DatabaseSession getSession(int index) {
        if (null == this.sessions) {
            return null;
        }
        return (DatabaseSession)this.sessions.get(index);
    }

    public AbstractSession getSession(Object object) {
        if (null == object) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            if (next.getDescriptor(object) == null) continue;
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
    }

    public AbstractSession getSession(Class clazz) {
        if (null == clazz) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            if (next.getDescriptor(clazz) == null) continue;
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
    }

    public AbstractSession getSession(XMLDescriptor xmlDescriptor) {
        if (null == xmlDescriptor) {
            return null;
        }
        int numberOfSessions = this.sessions.size();
        for (int x = 0; x < numberOfSessions; ++x) {
            AbstractSession next = (AbstractSession)this.sessions.get(x);
            if (!next.getProject().getOrderedDescriptors().contains(xmlDescriptor)) continue;
            return next;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(xmlDescriptor.getJavaClass().getName());
    }

    private void storeXMLDescriptorsByQName(DatabaseSession session) {
        for (XMLDescriptor xmlDescriptor : session.getProject().getOrderedDescriptors()) {
            this.storeXMLDescriptorByQName(xmlDescriptor);
        }
    }

    public void storeXMLDescriptorByQName(XMLDescriptor xmlDescriptor) {
        Vector tableNames = xmlDescriptor.getTableNames();
        for (int i = 0; i < tableNames.size(); ++i) {
            QName descriptorQName;
            String defaultRootName = (String)tableNames.get(i);
            if (null == defaultRootName) continue;
            int index = defaultRootName.indexOf(58);
            String defaultRootLocalName = defaultRootName.substring(index + 1);
            if (index > -1) {
                String defaultRootPrefix = defaultRootName.substring(0, index);
                String defaultRootNamespaceURI = xmlDescriptor.getNamespaceResolver().resolveNamespacePrefix(defaultRootPrefix);
                descriptorQName = new QName(defaultRootNamespaceURI, defaultRootLocalName);
            } else {
                descriptorQName = xmlDescriptor.getNamespaceResolver() != null ? new QName(xmlDescriptor.getNamespaceResolver().getDefaultNamespaceURI(), defaultRootLocalName) : new QName(defaultRootLocalName);
            }
            if (!xmlDescriptor.hasInheritance() || xmlDescriptor.getInheritancePolicy().isRootParentDescriptor()) {
                this.descriptorsByQName.put(descriptorQName, xmlDescriptor);
                continue;
            }
            XMLDescriptor existingDescriptor = (XMLDescriptor)this.descriptorsByQName.get(descriptorQName);
            if (existingDescriptor != null) continue;
            this.descriptorsByQName.put(descriptorQName, xmlDescriptor);
        }
        XMLSchemaReference xmlSchemaReference = xmlDescriptor.getSchemaReference();
        if (null != xmlSchemaReference) {
            String schemaContext = xmlSchemaReference.getSchemaContext();
            if ((xmlSchemaReference.getType() == 1 || xmlSchemaReference.getType() == 2) && null != schemaContext && schemaContext.lastIndexOf(47) == 0) {
                schemaContext = schemaContext.substring(1, schemaContext.length());
                XPathFragment typeFragment = new XPathFragment(schemaContext);
                if (null != xmlDescriptor.getNamespaceResolver()) {
                    typeFragment.setNamespaceURI(xmlDescriptor.getNamespaceResolver().resolveNamespacePrefix(typeFragment.getPrefix()));
                }
                this.descriptorsByGlobalType.put(typeFragment, xmlDescriptor);
            }
        }
    }

    public XMLDescriptor getDescriptor(QName qName) {
        return (XMLDescriptor)this.descriptorsByQName.get(qName);
    }

    public void addDescriptorByQName(QName qName, XMLDescriptor descriptor) {
        this.descriptorsByQName.put(qName, descriptor);
    }

    public XMLDescriptor getDescriptorByGlobalType(XPathFragment xPathFragment) {
        return (XMLDescriptor)this.descriptorsByGlobalType.get(xPathFragment);
    }

    public DocumentPreservationPolicy getDocumentPreservationPolicy(AbstractSession session) {
        XMLLogin login = (XMLLogin)session.getDatasourceLogin();
        return login.getDocumentPreservationPolicy();
    }

    public void setupDocumentPreservationPolicy(DatabaseSession session) {
        XMLLogin login = (XMLLogin)session.getDatasourceLogin();
        if (login.getDocumentPreservationPolicy() == null) {
            for (XMLDescriptor xmlDescriptor : session.getProject().getOrderedDescriptors()) {
                if (!xmlDescriptor.shouldPreserveDocument()) continue;
                login.setDocumentPreservationPolicy(new DescriptorLevelDocumentPreservationPolicy(this));
                break;
            }
        }
        if (login.getDocumentPreservationPolicy() == null) {
            login.setDocumentPreservationPolicy(new NoDocumentPreservationPolicy());
        }
        if (login.getDocumentPreservationPolicy().shouldPreserveDocument() && !this.hasDocumentPreservation) {
            this.hasDocumentPreservation = true;
        }
    }

    public boolean hasDocumentPreservation() {
        return this.hasDocumentPreservation;
    }
}

