/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class FlushMode
implements Serializable {
    private static final Map INSTANCES = new HashMap();
    private final int level;
    private final String name;
    public static final FlushMode NEVER = new FlushMode(0, "NEVER");
    public static final FlushMode MANUAL = new FlushMode(0, "MANUAL");
    public static final FlushMode COMMIT = new FlushMode(5, "COMMIT");
    public static final FlushMode AUTO = new FlushMode(10, "AUTO");
    public static final FlushMode ALWAYS = new FlushMode(20, "ALWAYS");

    private FlushMode(int level, String name) {
        this.level = level;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean lessThan(FlushMode other) {
        return this.level < other.level;
    }

    public static boolean isManualFlushMode(FlushMode mode) {
        return FlushMode.MANUAL.level == mode.level;
    }

    private Object readResolve() {
        return INSTANCES.get(this.name);
    }

    public static FlushMode parse(String name) {
        return (FlushMode)INSTANCES.get(name);
    }

    static {
        INSTANCES.put(FlushMode.NEVER.name, NEVER);
        INSTANCES.put(FlushMode.MANUAL.name, MANUAL);
        INSTANCES.put(FlushMode.AUTO.name, AUTO);
        INSTANCES.put(FlushMode.ALWAYS.name, ALWAYS);
        INSTANCES.put(FlushMode.COMMIT.name, COMMIT);
    }
}

