/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedAnalyzer
extends Analyzer {
    private Analyzer globalAnalyzer;
    private Map<String, Analyzer> scopedAnalyzers = new HashMap<String, Analyzer>();

    public ScopedAnalyzer() {
    }

    private ScopedAnalyzer(Analyzer globalAnalyzer, Map<String, Analyzer> scopedAnalyzers) {
        this.globalAnalyzer = globalAnalyzer;
        for (Map.Entry<String, Analyzer> entry : scopedAnalyzers.entrySet()) {
            this.addScopedAnalyzer(entry.getKey(), entry.getValue());
        }
    }

    public void setGlobalAnalyzer(Analyzer globalAnalyzer) {
        this.globalAnalyzer = globalAnalyzer;
    }

    public void addScopedAnalyzer(String scope, Analyzer scopedAnalyzer) {
        this.scopedAnalyzers.put(scope, scopedAnalyzer);
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.getAnalyzer(fieldName).tokenStream(fieldName, reader);
    }

    @Override
    public int getPositionIncrementGap(String fieldName) {
        return this.getAnalyzer(fieldName).getPositionIncrementGap(fieldName);
    }

    private Analyzer getAnalyzer(String fieldName) {
        Analyzer analyzer = this.scopedAnalyzers.get(fieldName);
        if (analyzer == null) {
            analyzer = this.globalAnalyzer;
        }
        return analyzer;
    }

    public ScopedAnalyzer clone() {
        ScopedAnalyzer clone = new ScopedAnalyzer(this.globalAnalyzer, this.scopedAnalyzers);
        return clone;
    }
}

