/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import com.scalagent.jmx.JMXServer;
import fr.dyade.aaa.agent.AgentServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.CommException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.objectweb.joram.client.connector.ActivationSpecImpl;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.InboundConsumer;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.connector.ManagedQueueConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedTopicConnectionFactoryImpl;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.XAConnectionFactory;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.JoramAdmin;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.ha.local.TopicHALocalConnectionFactory;
import org.objectweb.joram.client.jms.ha.local.XAHALocalConnectionFactory;
import org.objectweb.joram.client.jms.ha.tcp.TopicHATcpConnectionFactory;
import org.objectweb.joram.client.jms.ha.tcp.XAHATcpConnectionFactory;
import org.objectweb.joram.client.jms.local.TopicLocalConnectionFactory;
import org.objectweb.joram.client.jms.local.XALocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATcpConnectionFactory;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;

public class JoramAdapter
implements ResourceAdapter,
Serializable,
JoramAdapterMBean {
    private static final long serialVersionUID = 1L;
    private transient WorkManager workManager;
    private transient Hashtable consumers;
    private transient Vector producers;
    private transient Hashtable connections;
    private boolean started = false;
    private boolean stopped = false;
    boolean collocated = false;
    boolean isHa = false;
    String hostName = "localhost";
    int serverPort = 16010;
    String haURL = null;
    String rootName = "root";
    String rootPasswd = "root";
    String identityClass = SimpleIdentity.class.getName();
    short serverId = 0;
    short clusterId = (short)-1;
    List platformServersIds = null;
    private String platformConfigDir;
    private boolean persistentPlatform = false;
    private String adminFile = "joram-admin.cfg";
    private String adminFileXML = "joramAdmin.xml";
    private String adminFileExportXML = "joramAdminExport.xml";
    private String serverName = "s0";
    private static Vector boundNames = new Vector();
    private static MBeanServer mbs = null;
    public int connectingTimer = 0;
    public int txPendingTimer = 0;
    public int cnxPendingTimer = 0;
    public int queueMessageReadMax = 2;
    public int topicAckBufferMax = 0;
    public int topicPassivationThreshold = Integer.MAX_VALUE;
    public int topicActivationThreshold = 0;
    public boolean asyncSend = false;
    public boolean multiThreadSync = false;
    public int multiThreadSyncDelay = 1;
    public boolean deleteDurableSubscription = false;
    public JMXServer jmxServer;
    private transient JoramAdmin joramAdmin;

    public JoramAdapter() {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)"JORAM adapter instantiated.");
        }
        this.consumers = new Hashtable();
        this.producers = new Vector();
        ArrayList<MBeanServer> array = MBeanServerFactory.findMBeanServer(null);
        if (!array.isEmpty()) {
            mbs = array.get(0);
        }
        this.jmxServer = new JMXServer(mbs);
    }

    public synchronized void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        block49: {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            JoramAdmin.setHa(this.isHa);
                            if (this.started) {
                                throw new ResourceAdapterInternalException("Adapter already started.");
                            }
                            if (this.stopped) {
                                throw new ResourceAdapterInternalException("Adapter has been stopped.");
                            }
                            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)"JORAM adapter starting deployment...");
                            }
                            this.workManager = ctx.getWorkManager();
                            if (this.collocated) {
                                if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                                    AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)"  - Collocated JORAM server is starting...");
                                }
                                if (this.persistentPlatform) {
                                    System.setProperty("Transaction", "fr.dyade.aaa.util.NTransaction");
                                    System.setProperty("NTNoLockFile", "true");
                                } else {
                                    System.setProperty("Transaction", "fr.dyade.aaa.util.NullTransaction");
                                    System.setProperty("NbMaxAgents", "2147483647");
                                }
                                if (this.platformConfigDir != null) {
                                    System.setProperty("fr.dyade.aaa.agent.A3CONF_DIR", this.platformConfigDir);
                                    System.setProperty("fr.dyade.aaa.DEBUG_DIR", this.platformConfigDir);
                                }
                                try {
                                    AgentServer.init(this.serverId, this.serverName, null, this.clusterId);
                                    AgentServer.start();
                                    if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                                        AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)"  - Collocated JORAM server has successfully started.");
                                    }
                                }
                                catch (Exception exc) {
                                    AgentServer.stop();
                                    AgentServer.reset(true);
                                    throw new ResourceAdapterInternalException("Could not start collocated JORAM  instance: " + exc);
                                }
                            }
                            try {
                                if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                                    AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - Reading the provided admin file: " + this.adminFileXML));
                                }
                                JoramAdmin.executeXMLAdmin(this.platformConfigDir, this.adminFileXML);
                            }
                            catch (Exception exc) {
                                if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) break block45;
                                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)"JORAM ADMIN XML not found.");
                            }
                        }
                        try {
                            this.adminConnect();
                            this.serverId = (short)this.joramAdmin.getPlatformAdmin().getLocalServerId();
                        }
                        catch (Exception exc) {
                            if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.WARN)) break block46;
                            AdapterTracing.dbgAdapter.log(BasicLevel.WARN, (Object)("  - JORAM server not administerable: " + exc));
                        }
                    }
                    if (this.joramAdmin != null) {
                        this.joramAdmin.setAdminFileExportXML(this.adminFileExportXML);
                        try {
                            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - Reading the provided admin file: " + this.adminFileExportXML));
                            }
                            JoramAdmin.executeXMLAdmin(this.platformConfigDir, this.adminFileExportXML);
                            this.adminConnect();
                        }
                        catch (Exception exc) {
                            if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) break block47;
                            AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)(this.adminFileExportXML + " not found."));
                        }
                    }
                }
                try {
                    File file = null;
                    try {
                        if (this.platformConfigDir == null) {
                            URL url = ClassLoader.getSystemResource(this.adminFile);
                            file = new File(url.getFile());
                        } else {
                            file = new File(this.platformConfigDir, this.adminFile);
                        }
                    }
                    catch (NullPointerException e) {
                        throw new FileNotFoundException();
                    }
                    FileReader fileReader = new FileReader(file);
                    BufferedReader reader = new BufferedReader(fileReader);
                    if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                        AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - Reading the provided admin file: " + file));
                    }
                    boolean end = false;
                    String name = null;
                    while (!end) {
                        try {
                            String line = reader.readLine();
                            if (line == null) {
                                end = true;
                                continue;
                            }
                            StringTokenizer tokenizer = new StringTokenizer(line);
                            if (!tokenizer.hasMoreTokens()) continue;
                            String firstToken = tokenizer.nextToken();
                            if (firstToken.equalsIgnoreCase("Host")) {
                                if (!tokenizer.hasMoreTokens()) continue;
                                this.hostName = tokenizer.nextToken();
                                continue;
                            }
                            if (firstToken.equalsIgnoreCase("Port")) {
                                if (!tokenizer.hasMoreTokens()) continue;
                                this.serverPort = Integer.parseInt(tokenizer.nextToken());
                                continue;
                            }
                            if (firstToken.equalsIgnoreCase("Queue")) {
                                if (!tokenizer.hasMoreTokens()) continue;
                                name = tokenizer.nextToken();
                                this.createQueue(name);
                                continue;
                            }
                            if (firstToken.equalsIgnoreCase("Topic")) {
                                if (!tokenizer.hasMoreTokens()) continue;
                                name = tokenizer.nextToken();
                                this.createTopic(name);
                                continue;
                            }
                            if (firstToken.equalsIgnoreCase("User")) {
                                if (tokenizer.hasMoreTokens()) {
                                    name = tokenizer.nextToken();
                                }
                                if (tokenizer.hasMoreTokens()) {
                                    String password = tokenizer.nextToken();
                                    this.createUser(name, password);
                                    continue;
                                }
                                if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) continue;
                                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("  - Missing password for user [" + name + "]"));
                                continue;
                            }
                            if (firstToken.equalsIgnoreCase("CF")) {
                                if (!tokenizer.hasMoreTokens()) continue;
                                name = tokenizer.nextToken();
                                this.createCF(name);
                                continue;
                            }
                            if (firstToken.equalsIgnoreCase("QCF")) {
                                if (!tokenizer.hasMoreTokens()) continue;
                                name = tokenizer.nextToken();
                                this.createQCF(name);
                                continue;
                            }
                            if (!firstToken.equalsIgnoreCase("TCF") || !tokenizer.hasMoreTokens()) continue;
                            name = tokenizer.nextToken();
                            this.createTCF(name);
                        }
                        catch (IOException exc) {
                        }
                        catch (AdminException exc) {
                            AdapterTracing.dbgAdapter.log(BasicLevel.ERROR, (Object)"Creation failed", (Throwable)exc);
                        }
                    }
                }
                catch (FileNotFoundException fnfe) {
                    if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) break block48;
                    AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)"  - No administration task requested.");
                }
            }
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("Server port is " + this.serverPort));
            }
            this.started = true;
            try {
                this.jmxServer.registerMBean(this, "joramClient", "type=JoramAdapter,version=5.2.1");
            }
            catch (Exception e) {
                if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.WARN)) break block49;
                AdapterTracing.dbgAdapter.log(BasicLevel.WARN, (Object)"  - Could not register JoramAdapterMBean", (Throwable)e);
            }
        }
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)"JORAM adapter 5.2.1 successfully deployed.");
        }
    }

    public synchronized void stop() {
        block17: {
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)"JORAM adapter stopping...");
            }
            if (!this.started || this.stopped) {
                return;
            }
            while (!boundNames.isEmpty()) {
                this.unbind((String)boundNames.remove(0));
            }
            this.joramAdmin.getPlatformAdmin().disconnect();
            while (!this.producers.isEmpty()) {
                try {
                    ((ManagedConnectionImpl)this.producers.remove(0)).destroy();
                }
                catch (Exception exc) {}
            }
            Enumeration keys = this.consumers.keys();
            while (keys.hasMoreElements()) {
                ((InboundConsumer)this.consumers.get(keys.nextElement())).close();
            }
            if (this.connections != null) {
                keys = this.connections.keys();
                while (keys.hasMoreElements()) {
                    try {
                        ((XAConnection)this.connections.get(keys.nextElement())).close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.collocated) {
                try {
                    AgentServer.stop();
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            this.stopped = true;
            try {
                this.jmxServer.unregisterMBean("joramClient", "type=JoramAdapter,version=5.2.1");
            }
            catch (Exception e) {
                if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.WARN)) break block17;
                AdapterTracing.dbgAdapter.log(BasicLevel.WARN, (Object)"unregisterMBean", (Throwable)e);
            }
        }
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)"JORAM adapter successfully stopped.");
        }
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        int ackMode;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " endpointActivation(" + endpointFactory + ", " + spec + ")"));
        }
        if (!this.started) {
            throw new IllegalStateException("Non started resource adapter.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Stopped resource adapter.");
        }
        if (!(spec instanceof ActivationSpecImpl)) {
            throw new ResourceException("Provided ActivationSpec instance is not a JORAM activation spec.");
        }
        ActivationSpecImpl specImpl = (ActivationSpecImpl)spec;
        if (!specImpl.getResourceAdapter().equals(this)) {
            throw new ResourceException("Supplied ActivationSpec instance associated to an other ResourceAdapter.");
        }
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)"Activating Endpoint on JORAM adapter.");
        }
        boolean durable = specImpl.getSubscriptionDurability() != null && specImpl.getSubscriptionDurability().equalsIgnoreCase("Durable");
        boolean transacted = false;
        try {
            Class<?> listenerClass = Class.forName("javax.jms.MessageListener");
            Class[] parameters = new Class[]{Class.forName("javax.jms.Message")};
            Method meth = listenerClass.getMethod("onMessage", parameters);
            transacted = endpointFactory.isDeliveryTransacted(meth);
        }
        catch (Exception exc) {
            throw new ResourceException("Could not determine transactional context: " + exc);
        }
        int maxWorks = 10;
        try {
            maxWorks = Integer.parseInt(specImpl.getMaxNumberOfWorks());
        }
        catch (Exception exc) {
            throw new ResourceException("Invalid max number of works instances number: " + exc);
        }
        int maxMessages = 10;
        try {
            maxMessages = Integer.parseInt(specImpl.getMaxMessages());
        }
        catch (Exception exc) {
            throw new ResourceException("Invalid max messages number: " + exc);
        }
        try {
            ackMode = "Auto-acknowledge".equals(specImpl.getAcknowledgeMode()) ? 1 : ("Dups-ok-acknowledge".equals(specImpl.getAcknowledgeMode()) ? 3 : 1);
        }
        catch (Exception exc) {
            throw new ResourceException("Invalid acknowledge mode: " + exc);
        }
        String destType = specImpl.getDestinationType();
        String destName = specImpl.getDestination();
        try {
            javax.jms.Destination dest;
            if ("javax.jms.Queue".equals(destType)) {
                dest = this.createQueue(destName);
            } else if ("javax.jms.Topic".equals(destType)) {
                dest = this.createTopic(destName);
            } else {
                throw new NotSupportedException("Invalid destination type provided as activation parameter: " + destType);
            }
            String userName = specImpl.getUserName();
            String password = specImpl.getPassword();
            String identityClass = specImpl.getIdentityClass();
            this.createUser(userName, password, identityClass);
            javax.jms.XAConnectionFactory cf = null;
            XAConnectionFactory connectionFactory = null;
            cf = this.isHa ? (this.collocated ? (this.haURL != null ? XAHATcpConnectionFactory.create(this.haURL) : XAHALocalConnectionFactory.create()) : XAHATcpConnectionFactory.create("hajoram://" + this.hostName + ':' + this.serverPort)) : (this.collocated ? XALocalConnectionFactory.create() : XATcpConnectionFactory.create(this.hostName, this.serverPort));
            connectionFactory = (XAConnectionFactory)cf;
            connectionFactory.getParameters().connectingTimer = this.connectingTimer;
            connectionFactory.getParameters().cnxPendingTimer = this.cnxPendingTimer;
            connectionFactory.getParameters().txPendingTimer = this.txPendingTimer;
            if (this.queueMessageReadMax > 0) {
                connectionFactory.getParameters().queueMessageReadMax = this.queueMessageReadMax;
            }
            if (this.topicAckBufferMax > 0) {
                connectionFactory.getParameters().topicAckBufferMax = this.topicAckBufferMax;
            }
            if (this.topicPassivationThreshold > 0) {
                connectionFactory.getParameters().topicPassivationThreshold = this.topicPassivationThreshold;
            }
            if (this.topicActivationThreshold > 0) {
                connectionFactory.getParameters().topicActivationThreshold = this.topicActivationThreshold;
            }
            connectionFactory.setIdentityClassName(identityClass);
            XAConnection cnx = connectionFactory.createXAConnection(userName, password);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " endpointActivation cnx = " + cnx));
            }
            InboundConsumer consumer = new InboundConsumer(this.workManager, endpointFactory, cnx, dest, specImpl.getMessageSelector(), durable, specImpl.getSubscriptionName(), transacted, maxWorks, maxMessages, ackMode, this.deleteDurableSubscription);
            this.consumers.put(specImpl, consumer);
        }
        catch (JMSSecurityException exc) {
            throw new SecurityException("Invalid user identification: " + exc);
        }
        catch (JMSException exc) {
            throw new CommException("Could not connect to the JORAM server: " + exc);
        }
        catch (AdminException exc) {
            throw new ResourceException("Problem when handling the JORAM destinations: " + exc);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " endpointDeactivation(" + endpointFactory + ", " + spec + ")"));
        }
        if (!this.started || this.stopped) {
            return;
        }
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)"Deactivating Endpoint on JORAM adapter.");
        }
        ((InboundConsumer)this.consumers.remove(spec)).close();
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResources(" + specs + ")"));
        }
        if (!this.started) {
            throw new IllegalStateException("Non started resource adapter.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Stopped resource adapter.");
        }
        javax.jms.XAConnectionFactory connectionFactory = null;
        Vector<XAResource> resources = new Vector<XAResource>();
        if (this.connections == null) {
            this.connections = new Hashtable();
        }
        try {
            for (int i = 0; i < specs.length; ++i) {
                if (!(specs[i] instanceof ActivationSpecImpl)) {
                    throw new ResourceException("Provided ActivationSpec instance is not a JORAM activation spec.");
                }
                ActivationSpecImpl specImpl = (ActivationSpecImpl)specs[i];
                if (!specImpl.getResourceAdapter().equals(this)) {
                    throw new ResourceException("Supplied ActivationSpec instance associated to an other ResourceAdapter.");
                }
                String userName = specImpl.getUserName();
                if (!this.connections.containsKey(userName)) {
                    String password = specImpl.getPassword();
                    String identityClass = specImpl.getIdentityClass();
                    if (this.isHa) {
                        if (this.collocated) {
                            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("haURL = " + this.haURL));
                            }
                            connectionFactory = this.haURL != null ? XAHATcpConnectionFactory.create(this.haURL) : XAHALocalConnectionFactory.create();
                        } else {
                            String urlHa = "hajoram://" + this.hostName + ":" + this.serverPort;
                            connectionFactory = XAHATcpConnectionFactory.create(urlHa);
                        }
                    } else {
                        connectionFactory = this.collocated ? XALocalConnectionFactory.create() : XATcpConnectionFactory.create(this.hostName, this.serverPort);
                    }
                    ((XAConnectionFactory)connectionFactory).getParameters().connectingTimer = this.connectingTimer;
                    ((XAConnectionFactory)connectionFactory).getParameters().cnxPendingTimer = this.cnxPendingTimer;
                    ((XAConnectionFactory)connectionFactory).getParameters().txPendingTimer = this.txPendingTimer;
                    ((AbstractConnectionFactory)((Object)connectionFactory)).setIdentityClassName(identityClass);
                    XAConnection connection = connectionFactory.createXAConnection(userName, password);
                    this.connections.put(userName, connection);
                    resources.add(connection.createXASession().getXAResource());
                }
                if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) continue;
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResources resources = " + resources));
            }
        }
        catch (JMSSecurityException exc) {
            throw new SecurityException("Invalid user identification: " + exc);
        }
        catch (JMSException exc) {
            throw new CommException("Could not connect to the JORAM server: " + exc);
        }
        return resources.toArray(new XAResource[resources.size()]);
    }

    public int hashCode() {
        return (this.collocated + " " + this.hostName + " " + this.serverPort).hashCode();
    }

    public boolean equals(Object o) {
        boolean res;
        if (!(o instanceof JoramAdapter)) {
            return false;
        }
        JoramAdapter other = (JoramAdapter)o;
        boolean bl = res = this.collocated == other.collocated && this.hostName.equals(other.hostName) && this.serverPort == other.serverPort;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " equals = " + res));
        }
        return res;
    }

    public List getDestinations() {
        return this.joramAdmin.getDestinations();
    }

    public List getDestinations(int serverId) {
        return this.joramAdmin.getDestinations(serverId);
    }

    public List getUsers() {
        return this.joramAdmin.getUsers();
    }

    public List getUsers(int serverId) {
        return this.joramAdmin.getUsers(serverId);
    }

    public List getPlatformServersIds() {
        return this.joramAdmin.getPlatformAdmin().getServersIds();
    }

    public List getLocalUsers() {
        return this.joramAdmin.getUsers(this.serverId);
    }

    public void setDefaultDMQ(int serverId, DeadMQueue dmq) throws ConnectException, AdminException {
        this.joramAdmin.setDefaultDMQ(serverId, dmq);
    }

    public void setDefaultDMQId(int serverId, String dmqId) throws ConnectException, AdminException {
        this.joramAdmin.setDefaultDMQId(serverId, dmqId);
    }

    public DeadMQueue getDefaultDMQ(int serverId) throws ConnectException, AdminException {
        return this.joramAdmin.getDefaultDMQ(serverId);
    }

    public String getDefaultDMQId() throws ConnectException, AdminException {
        return this.joramAdmin.getDefaultDMQId();
    }

    public String getDefaultDMQId(int serverId) throws ConnectException, AdminException {
        return this.joramAdmin.getDefaultDMQId(serverId);
    }

    public DeadMQueue getDefaultDMQ() throws ConnectException, AdminException {
        return this.joramAdmin.getDefaultDMQ();
    }

    public void exit() {
        this.joramAdmin.exit();
    }

    public void setTimeOutToAbortRequest(long timeOut) {
        this.joramAdmin.setTimeOutToAbortRequest(timeOut);
    }

    public long getTimeOutToAbortRequest() {
        return this.joramAdmin.getTimeOutToAbortRequest();
    }

    public void createUser(String name, String password) throws AdminException {
        try {
            User.create(name, password);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - User [" + name + "] has been created."));
            }
        }
        catch (ConnectException exc) {
            throw new AdminException("createUser() failed: admin connection has been lost.");
        }
    }

    public void createUser(String name, String password, String identityClass) throws AdminException {
        try {
            User.create(name, password, AdminModule.getLocalServerId(), identityClass);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - User [" + name + "] has been created."));
            }
        }
        catch (ConnectException exc) {
            throw new AdminException("createUser() failed: admin connection has been lost.");
        }
    }

    public void createUser(String name, String password, int serverId, String identityClass) throws AdminException {
        try {
            User.create(name, password, serverId, identityClass);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - User [" + name + "] has been created."));
            }
        }
        catch (ConnectException exc) {
            throw new AdminException("createUser() failed: admin connection has been lost.");
        }
    }

    public void createUser(String name, String password, int serverId) throws AdminException {
        try {
            User.create(name, password, serverId);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - User [" + name + "] has been created."));
            }
        }
        catch (ConnectException exc) {
            throw new AdminException("createUser() failed: admin connection has been lost.");
        }
    }

    public void createCF(String name) {
        ManagedConnectionFactoryImpl mcf = new ManagedConnectionFactoryImpl();
        try {
            mcf.setResourceAdapter(this);
            mcf.setCollocated(new Boolean(false));
            Object factory = mcf.createConnectionFactory();
            this.bind(name, factory);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - ConnectionFactory [" + name + "] has been created and bound."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createQCF(String name) {
        ManagedQueueConnectionFactoryImpl mcf = new ManagedQueueConnectionFactoryImpl();
        try {
            mcf.setResourceAdapter(this);
            mcf.setCollocated(new Boolean(false));
            Object factory = ((ManagedConnectionFactoryImpl)mcf).createConnectionFactory();
            this.bind(name, factory);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - QueueConnectionFactory [" + name + "] has been created and bound."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createTCF(String name) {
        ManagedTopicConnectionFactoryImpl mcf = new ManagedTopicConnectionFactoryImpl();
        try {
            mcf.setResourceAdapter(this);
            mcf.setCollocated(new Boolean(false));
            Object factory = ((ManagedConnectionFactoryImpl)mcf).createConnectionFactory();
            this.bind(name, factory);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - TopicConnectionFactory [" + name + "] has been created and bound."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void adminConnect() throws AdminException {
        try {
            TopicConnectionFactory factory;
            if (this.isHa) {
                if (this.collocated) {
                    if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                        AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("haURL = " + this.haURL));
                    }
                    factory = this.haURL != null ? TopicHATcpConnectionFactory.create(this.haURL) : TopicHALocalConnectionFactory.create();
                } else {
                    String urlHa = "hajoram://" + this.hostName + ":" + this.serverPort;
                    factory = TopicHATcpConnectionFactory.create(urlHa);
                }
            } else {
                factory = this.collocated ? TopicLocalConnectionFactory.create() : TopicTcpConnectionFactory.create(this.hostName, this.serverPort);
            }
            ((ConnectionFactory)((Object)factory)).getParameters().connectingTimer = 60;
            this.joramAdmin = new JoramAdmin(factory, this.rootName, this.rootPasswd, this.identityClass);
        }
        catch (ConnectException exc) {
            throw new AdminException("Admin connection can't be established: " + exc.getMessage());
        }
    }

    void addProducer(ManagedConnectionImpl managedCx) {
        this.producers.add(managedCx);
    }

    void removeProducer(ManagedConnectionImpl managedCx) {
        this.producers.remove(managedCx);
    }

    private static String removePrefix(String name) {
        String PREFIX_NAME = "scn:comp/";
        try {
            if (name.startsWith(PREFIX_NAME)) {
                return name.substring(PREFIX_NAME.length());
            }
            return name;
        }
        catch (Exception e) {
            return name;
        }
    }

    public javax.jms.Destination createQueue(int serverId, String name, String className, Properties prop) throws AdminException {
        try {
            InitialContext ctx = new InitialContext();
            return (javax.jms.Destination)ctx.lookup(name);
        }
        catch (NamingException exc) {
            try {
                String shortName = JoramAdapter.removePrefix(name);
                Queue queue = Queue.create(serverId, shortName, className, prop);
                queue.setFreeReading();
                queue.setFreeWriting();
                if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                    AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - Queue [" + shortName + "] has been created."));
                }
                this.bind(name, queue);
                return queue;
            }
            catch (ConnectException exc2) {
                throw new AdminException("createQueue() failed: admin connection has been lost.");
            }
        }
    }

    public javax.jms.Destination createQueue(int serverId, String name) throws AdminException {
        return this.createQueue(serverId, name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public javax.jms.Destination createQueue(String name) throws AdminException {
        try {
            return this.createQueue(this.joramAdmin.getPlatformAdmin().getLocalServerId(), name, "org.objectweb.joram.mom.dest.Queue", null);
        }
        catch (ConnectException exc2) {
            throw new AdminException("createQueue() failed: admin connection has been lost.");
        }
    }

    public javax.jms.Destination createTopic(int serverId, String name, String className, Properties prop) throws AdminException {
        try {
            InitialContext ctx = new InitialContext();
            return (javax.jms.Destination)ctx.lookup(name);
        }
        catch (NamingException exc) {
            try {
                String shortName = JoramAdapter.removePrefix(name);
                Topic topic = Topic.create(serverId, shortName, className, prop);
                topic.setFreeReading();
                topic.setFreeWriting();
                if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.INFO)) {
                    AdapterTracing.dbgAdapter.log(BasicLevel.INFO, (Object)("  - Topic [" + shortName + "] has been created."));
                }
                this.bind(name, topic);
                return topic;
            }
            catch (ConnectException exc2) {
                throw new AdminException("createTopic() failed: admin connection has been lost.");
            }
        }
    }

    public javax.jms.Destination createTopic(int serverId, String name) throws AdminException {
        return this.createTopic(serverId, name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public javax.jms.Destination createTopic(String name) throws AdminException {
        try {
            return this.createTopic(this.joramAdmin.getPlatformAdmin().getLocalServerId(), name, "org.objectweb.joram.mom.dest.Topic", null);
        }
        catch (ConnectException exc2) {
            throw new AdminException("createTopic() failed: admin connection has been lost.");
        }
    }

    public void removeDestination(String name) throws AdminException {
        try {
            InitialContext ctx = new InitialContext();
            javax.jms.Destination dest = (javax.jms.Destination)ctx.lookup(name);
            ctx.close();
            if (dest instanceof Destination) {
                ((Destination)dest).delete();
            }
            this.unbind(name);
        }
        catch (Exception exc) {
            throw new AdminException("removeDestination(" + name + ") failed: use Destination.delete()");
        }
    }

    void bind(String name, Object obj) {
        block3: {
            try {
                InitialContext ctx = new InitialContext();
                ctx.rebind(name, obj);
                if (!boundNames.contains(name)) {
                    boundNames.add(name);
                }
            }
            catch (Exception e) {
                if (!AdapterTracing.dbgAdapter.isLoggable(BasicLevel.WARN)) break block3;
                AdapterTracing.dbgAdapter.log(BasicLevel.WARN, (Object)("Binding failed:  bind(" + name + "," + obj + ")"), (Throwable)e);
            }
        }
    }

    void unbind(String name) {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(name);
            boundNames.remove(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.consumers = new Hashtable();
        this.producers = new Vector();
    }

    public void setPlatformConfigDir(String platformConfigDir) {
        this.platformConfigDir = platformConfigDir;
    }

    public void setPersistentPlatform(Boolean persistentPlatform) {
        this.persistentPlatform = persistentPlatform;
    }

    public void setServerId(Short serverId) {
        this.serverId = serverId;
    }

    public void setRootName(String rn) {
        this.rootName = rn;
    }

    public void setRootPasswd(String rp) {
        this.rootPasswd = rp;
    }

    public void setIdentityClass(String identityClass) {
        this.identityClass = identityClass;
    }

    public void setClusterId(Short clusterId) {
        this.clusterId = clusterId;
        if (this.clusterId != -1) {
            this.isHa = true;
        }
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setAdminFile(String adminFile) {
        this.adminFile = adminFile;
    }

    public void setAdminFileXML(String adminFileXML) {
        this.adminFileXML = adminFileXML;
    }

    public void setCollocatedServer(Boolean collocatedServer) {
        this.collocated = collocatedServer;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public void setHAURL(String haURL) {
        this.haURL = haURL;
    }

    public void setConnectingTimer(Integer connectingTimer) {
        this.connectingTimer = connectingTimer;
    }

    public void setTxPendingTimer(Integer txPendingTimer) {
        this.txPendingTimer = txPendingTimer;
    }

    public void setCnxPendingTimer(Integer cnxPendingTimer) {
        this.cnxPendingTimer = cnxPendingTimer;
    }

    public void setQueueMessageReadMax(Integer queueMessageReadMax) {
        this.queueMessageReadMax = queueMessageReadMax;
    }

    public void setTopicAckBufferMax(Integer topicAckBufferMax) {
        this.topicAckBufferMax = topicAckBufferMax;
    }

    public void setTopicPassivationThreshold(Integer topicPassivationThreshold) {
        this.topicPassivationThreshold = topicPassivationThreshold;
    }

    public void setTopicActivationThreshold(Integer topicActivationThreshold) {
        this.topicActivationThreshold = topicActivationThreshold;
    }

    public void setAsyncSend(Boolean asyncSend) {
        this.asyncSend = asyncSend;
    }

    public void setMultiThreadSync(Boolean multiThreadSync) {
        this.multiThreadSync = multiThreadSync;
    }

    public void setMultiThreadSyncDelay(Integer multiThreadSyncDelay) {
        this.multiThreadSyncDelay = multiThreadSyncDelay;
    }

    public String getPlatformConfigDir() {
        return this.platformConfigDir;
    }

    public Boolean getPersistentPlatform() {
        return new Boolean(this.persistentPlatform);
    }

    public Short getServerId() {
        return new Short(this.serverId);
    }

    public String getRootName() {
        return this.rootName;
    }

    public String getRootPasswd() {
        return this.rootPasswd;
    }

    public String getIdentityClass() {
        return this.identityClass;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getAdminFile() {
        return this.adminFile;
    }

    public String getAdminFileXML() {
        return this.adminFileXML;
    }

    public String getAdminFileExportXML() {
        return this.adminFileExportXML;
    }

    public Boolean getCollocatedServer() {
        return new Boolean(this.collocated);
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getServerPort() {
        return new Integer(this.serverPort);
    }

    public String getHAURL() {
        return this.haURL;
    }

    public Integer getConnectingTimer() {
        return new Integer(this.connectingTimer);
    }

    public Integer getTxPendingTimer() {
        return new Integer(this.txPendingTimer);
    }

    public Integer getCnxPendingTimer() {
        return new Integer(this.cnxPendingTimer);
    }

    public Integer getQueueMessageReadMax() {
        return new Integer(this.queueMessageReadMax);
    }

    public Integer getTopicAckBufferMax() {
        return new Integer(this.topicAckBufferMax);
    }

    public Integer getTopicPassivationThreshold() {
        return new Integer(this.topicPassivationThreshold);
    }

    public Integer getTopicActivationThreshold() {
        return new Integer(this.topicActivationThreshold);
    }

    public Boolean getAsyncSend() {
        return new Boolean(this.asyncSend);
    }

    public Boolean getMultiThreadSync() {
        return new Boolean(this.multiThreadSync);
    }

    public Integer getMultiThreadSyncDelay() {
        return new Integer(this.multiThreadSyncDelay);
    }

    public Boolean getDeleteDurableSubscription() {
        return new Boolean(this.deleteDurableSubscription);
    }

    public void setDeleteDurableSubscription(Boolean flg) {
        this.deleteDurableSubscription = flg;
    }

    public void exportRepositoryToFile(String exportDir) throws AdminException {
        this.joramAdmin.exportRepositoryToFile(exportDir);
    }

    public boolean executeXMLAdminJMX(String path) throws Exception {
        boolean executeAdmin = JoramAdmin.executeXMLAdmin(path);
        this.adminConnect();
        return executeAdmin;
    }
}

