/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.ServerConfigHelper;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.agent.conf.A3CML;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.AdminDestinationItf;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.dest.AdminTopicImplMBean;
import org.objectweb.joram.mom.dest.ClusterAck;
import org.objectweb.joram.mom.dest.ClusterNot;
import org.objectweb.joram.mom.dest.ClusterTest;
import org.objectweb.joram.mom.dest.FatherAck;
import org.objectweb.joram.mom.dest.FatherTest;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.dest.Topic;
import org.objectweb.joram.mom.dest.TopicForwardNot;
import org.objectweb.joram.mom.dest.TopicImpl;
import org.objectweb.joram.mom.notifications.AdminReply;
import org.objectweb.joram.mom.notifications.AdminRequest;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.ClusterRequest;
import org.objectweb.joram.mom.notifications.DestinationAdminRequestNot;
import org.objectweb.joram.mom.notifications.GetProxyIdListNot;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.notifications.Monit_FreeAccess;
import org.objectweb.joram.mom.notifications.Monit_FreeAccessRep;
import org.objectweb.joram.mom.notifications.Monit_GetCluster;
import org.objectweb.joram.mom.notifications.Monit_GetClusterRep;
import org.objectweb.joram.mom.notifications.Monit_GetDMQSettings;
import org.objectweb.joram.mom.notifications.Monit_GetDMQSettingsRep;
import org.objectweb.joram.mom.notifications.Monit_GetFather;
import org.objectweb.joram.mom.notifications.Monit_GetFatherRep;
import org.objectweb.joram.mom.notifications.Monit_GetNbMaxMsg;
import org.objectweb.joram.mom.notifications.Monit_GetNbMaxMsgRep;
import org.objectweb.joram.mom.notifications.Monit_GetNumberRep;
import org.objectweb.joram.mom.notifications.Monit_GetPendingMessages;
import org.objectweb.joram.mom.notifications.Monit_GetPendingRequests;
import org.objectweb.joram.mom.notifications.Monit_GetReaders;
import org.objectweb.joram.mom.notifications.Monit_GetStat;
import org.objectweb.joram.mom.notifications.Monit_GetStatRep;
import org.objectweb.joram.mom.notifications.Monit_GetSubscriptions;
import org.objectweb.joram.mom.notifications.Monit_GetUsersRep;
import org.objectweb.joram.mom.notifications.Monit_GetWriters;
import org.objectweb.joram.mom.notifications.RegisterDestNot;
import org.objectweb.joram.mom.notifications.RegisterTmpDestNot;
import org.objectweb.joram.mom.notifications.RegisteredDestNot;
import org.objectweb.joram.mom.notifications.RequestGroupNot;
import org.objectweb.joram.mom.notifications.SetDMQRequest;
import org.objectweb.joram.mom.notifications.SetFatherRequest;
import org.objectweb.joram.mom.notifications.SetNbMaxMsgRequest;
import org.objectweb.joram.mom.notifications.SetRightRequest;
import org.objectweb.joram.mom.notifications.SetThreshRequest;
import org.objectweb.joram.mom.notifications.SpecialAdminRequest;
import org.objectweb.joram.mom.notifications.UnclusterRequest;
import org.objectweb.joram.mom.notifications.UnsetFatherRequest;
import org.objectweb.joram.mom.notifications.UserAdminRequestNot;
import org.objectweb.joram.mom.proxies.AdminNotification;
import org.objectweb.joram.mom.proxies.SendReplyNot;
import org.objectweb.joram.mom.proxies.UserAgent;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.admin.AddDomainRequest;
import org.objectweb.joram.shared.admin.AddServerRequest;
import org.objectweb.joram.shared.admin.CreateDestinationReply;
import org.objectweb.joram.shared.admin.CreateDestinationRequest;
import org.objectweb.joram.shared.admin.CreateUserReply;
import org.objectweb.joram.shared.admin.CreateUserRequest;
import org.objectweb.joram.shared.admin.DeleteDestination;
import org.objectweb.joram.shared.admin.DeleteUser;
import org.objectweb.joram.shared.admin.GetConfigRequest;
import org.objectweb.joram.shared.admin.GetDomainNames;
import org.objectweb.joram.shared.admin.GetDomainNamesRep;
import org.objectweb.joram.shared.admin.GetLocalServer;
import org.objectweb.joram.shared.admin.GetLocalServerRep;
import org.objectweb.joram.shared.admin.GetSubscriberIds;
import org.objectweb.joram.shared.admin.Monitor_GetCluster;
import org.objectweb.joram.shared.admin.Monitor_GetClusterRep;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettings;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettingsRep;
import org.objectweb.joram.shared.admin.Monitor_GetDestinations;
import org.objectweb.joram.shared.admin.Monitor_GetDestinationsRep;
import org.objectweb.joram.shared.admin.Monitor_GetFather;
import org.objectweb.joram.shared.admin.Monitor_GetFatherRep;
import org.objectweb.joram.shared.admin.Monitor_GetFreeAccess;
import org.objectweb.joram.shared.admin.Monitor_GetFreeAccessRep;
import org.objectweb.joram.shared.admin.Monitor_GetNbMaxMsg;
import org.objectweb.joram.shared.admin.Monitor_GetNbMaxMsgRep;
import org.objectweb.joram.shared.admin.Monitor_GetNumberRep;
import org.objectweb.joram.shared.admin.Monitor_GetPendingMessages;
import org.objectweb.joram.shared.admin.Monitor_GetPendingRequests;
import org.objectweb.joram.shared.admin.Monitor_GetReaders;
import org.objectweb.joram.shared.admin.Monitor_GetServersIds;
import org.objectweb.joram.shared.admin.Monitor_GetServersIdsRep;
import org.objectweb.joram.shared.admin.Monitor_GetStat;
import org.objectweb.joram.shared.admin.Monitor_GetStatRep;
import org.objectweb.joram.shared.admin.Monitor_GetSubscriptions;
import org.objectweb.joram.shared.admin.Monitor_GetUsers;
import org.objectweb.joram.shared.admin.Monitor_GetUsersRep;
import org.objectweb.joram.shared.admin.Monitor_GetWriters;
import org.objectweb.joram.shared.admin.QueueAdminRequest;
import org.objectweb.joram.shared.admin.RemoveDomainRequest;
import org.objectweb.joram.shared.admin.RemoveServerRequest;
import org.objectweb.joram.shared.admin.SetCluster;
import org.objectweb.joram.shared.admin.SetDefaultDMQ;
import org.objectweb.joram.shared.admin.SetDefaultThreshold;
import org.objectweb.joram.shared.admin.SetDestinationDMQ;
import org.objectweb.joram.shared.admin.SetFather;
import org.objectweb.joram.shared.admin.SetNbMaxMsg;
import org.objectweb.joram.shared.admin.SetQueueThreshold;
import org.objectweb.joram.shared.admin.SetReader;
import org.objectweb.joram.shared.admin.SetRight;
import org.objectweb.joram.shared.admin.SetUserDMQ;
import org.objectweb.joram.shared.admin.SetUserThreshold;
import org.objectweb.joram.shared.admin.SetWriter;
import org.objectweb.joram.shared.admin.SpecialAdmin;
import org.objectweb.joram.shared.admin.StopServerRequest;
import org.objectweb.joram.shared.admin.UnsetCluster;
import org.objectweb.joram.shared.admin.UnsetDefaultDMQ;
import org.objectweb.joram.shared.admin.UnsetDefaultThreshold;
import org.objectweb.joram.shared.admin.UnsetDestinationDMQ;
import org.objectweb.joram.shared.admin.UnsetFather;
import org.objectweb.joram.shared.admin.UnsetQueueThreshold;
import org.objectweb.joram.shared.admin.UnsetReader;
import org.objectweb.joram.shared.admin.UnsetUserDMQ;
import org.objectweb.joram.shared.admin.UnsetUserThreshold;
import org.objectweb.joram.shared.admin.UnsetWriter;
import org.objectweb.joram.shared.admin.UpdateUser;
import org.objectweb.joram.shared.admin.UserAdminRequest;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;

public final class AdminTopicImpl
extends TopicImpl
implements AdminTopicImplMBean {
    private static final long serialVersionUID = 1L;
    private static AdminTopicImpl ref;
    private int serverId = AgentServer.getServerId();
    private Hashtable destinationsTable = new Hashtable();
    private Hashtable usersTable = new Hashtable();
    private Hashtable proxiesTable = new Hashtable();
    private Hashtable requestsTable = new Hashtable();
    private long msgCounter = 0L;

    public AdminTopicImpl(AgentId topicId) {
        super(topicId, null);
    }

    public String toString() {
        return "AdminTopicImpl";
    }

    public AgentId getProxyId(Identity identity, String inaddr) throws Exception {
        AgentId userProxId = null;
        Identity userIdentity = (Identity)this.usersTable.get(identity.getUserName());
        if (userIdentity == null) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("User [" + identity.getUserName() + "] does not exist"));
            }
            throw new Exception("User [" + identity.getUserName() + "] does not exist");
        }
        if (identity instanceof Identity) {
            if (!identity.check(userIdentity)) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, (Object)"identity check failed.");
                }
                throw new Exception("identity check failed.");
            }
            userProxId = (AgentId)this.proxiesTable.get(identity.getUserName());
            if (userProxId == null) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, (Object)("No proxy deployed for user [" + identity.getUserName() + "]"));
                }
                throw new Exception("No proxy deployed for user [" + identity.getUserName() + "]");
            }
            return userProxId;
        }
        if (logger.isLoggable(BasicLevel.ERROR)) {
            logger.log(BasicLevel.ERROR, (Object)("Bad Auth must be instanceof Identity :: identity = " + identity));
        }
        throw new Exception("Bad Auth must be instanceof Identity :: identity = " + identity);
    }

    public String getName(AgentId proxyId) {
        Enumeration e = this.proxiesTable.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!proxyId.equals(this.proxiesTable.get(name))) continue;
            return name;
        }
        return null;
    }

    public Object getPassword(AgentId proxyId) {
        Enumeration e = this.proxiesTable.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!proxyId.equals(this.proxiesTable.get(name))) continue;
            return this.usersTable.get(name);
        }
        return null;
    }

    public boolean isTaken(String name) {
        return this.usersTable.containsKey(name);
    }

    public void AdminNotification(AgentId from, AdminNotification adminNot) {
        block3: {
            Identity identity = adminNot.getIdentity();
            try {
                this.usersTable.put(identity.getUserName(), identity);
                this.proxiesTable.put(identity.getUserName(), adminNot.getProxyId());
                this.clients.put(adminNot.getProxyId(), new Integer(READWRITE));
                if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)(identity.getUserName() + " successfully" + " set as admin client."));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block3;
                logger.log(BasicLevel.ERROR, (Object)"Exception:: ", (Throwable)e);
            }
        }
    }

    public void AdminRequestNot(AgentId from, AdminRequestNot adminNot) {
        this.processAdminRequests(adminNot.replyTo, adminNot.msgId, adminNot.request, from);
    }

    public void AdminReply(AgentId from, AdminReply not) {
        String requestId = not.getRequestId();
        if (requestId == null) {
            return;
        }
        AgentId replyTo = (AgentId)this.requestsTable.remove(requestId);
        if (replyTo == null) {
            return;
        }
        org.objectweb.joram.shared.admin.AdminReply reply = not instanceof Monit_GetUsersRep ? this.doProcess((Monit_GetUsersRep)not) : (not instanceof Monit_FreeAccessRep ? this.doProcess((Monit_FreeAccessRep)not) : (not instanceof Monit_GetDMQSettingsRep ? this.doProcess((Monit_GetDMQSettingsRep)not) : (not instanceof Monit_GetFatherRep ? this.doProcess((Monit_GetFatherRep)not) : (not instanceof Monit_GetClusterRep ? this.doProcess((Monit_GetClusterRep)not) : (not instanceof Monit_GetNumberRep ? this.doProcess((Monit_GetNumberRep)not) : (not instanceof Monit_GetStatRep ? this.doProcess((Monit_GetStatRep)not) : (not instanceof Monit_GetNbMaxMsgRep ? this.doProcess((Monit_GetNbMaxMsgRep)not) : new org.objectweb.joram.shared.admin.AdminReply(not.getSuccess(), not.getInfo(), not.getReplyObject()))))))));
        this.distributeReply(replyTo, requestId, reply);
    }

    public void GetProxyIdNot(GetProxyIdNot not) {
        try {
            AgentId proxyId = this.getProxyId(not.getIdentity(), not.getInAddr());
            not.Return(proxyId);
        }
        catch (Exception exc) {
            not.Throw(exc);
        }
    }

    public void GetProxyIdListNot(GetProxyIdListNot not) {
        Vector<AgentId> idList = new Vector<AgentId>();
        Enumeration ids = this.proxiesTable.elements();
        while (ids.hasMoreElements()) {
            AgentId aid = (AgentId)ids.nextElement();
            idList.addElement(aid);
        }
        Object[] res = new AgentId[idList.size()];
        idList.copyInto(res);
        not.Return((AgentId[])res);
    }

    public void RegisterTmpDestNot(RegisterTmpDestNot not) {
        String destName = not.getTmpDestId().toString();
        if (not.toAdd()) {
            String className;
            String type;
            if (not.isTopic()) {
                type = "topic.tmp";
                className = Topic.class.getName();
            } else {
                type = "queue.tmp";
                className = Queue.class.getName();
            }
            DestinationDesc destDesc = new DestinationDesc(not.getTmpDestId(), destName, className, type);
            this.destinationsTable.put(destName, destDesc);
        } else {
            this.destinationsTable.remove(destName);
        }
    }

    public void RegisterDestNot(RegisterDestNot not) {
        String name = not.getName();
        if (name == null || this.destinationsTable.contains(name)) {
            return;
        }
        DestinationDesc destDesc = new DestinationDesc(not.getId(), not.getName(), not.getClassName(), not.getType());
        this.destinationsTable.put(name, destDesc);
    }

    public void RegisteredDestNot(AgentId from, RegisteredDestNot not) {
        DestinationDesc destDesc = (DestinationDesc)this.destinationsTable.get(not.getName());
        if (destDesc != null) {
            not.setDestination(destDesc.getId());
        }
        this.forward(not.getReply(), not);
    }

    private org.objectweb.joram.shared.admin.AdminReply doProcess(Monit_GetUsersRep not) {
        Vector users = not.getUsers();
        Monitor_GetUsersRep reply = new Monitor_GetUsersRep();
        Enumeration names = this.proxiesTable.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            AgentId proxyId = (AgentId)this.proxiesTable.get(name);
            if (!users.contains(proxyId)) continue;
            reply.addUser(name, proxyId.toString());
        }
        return reply;
    }

    private org.objectweb.joram.shared.admin.AdminReply doProcess(Monit_FreeAccessRep not) {
        return new Monitor_GetFreeAccessRep(not.getFreeReading(), not.getFreeWriting());
    }

    private org.objectweb.joram.shared.admin.AdminReply doProcess(Monit_GetDMQSettingsRep not) {
        return new Monitor_GetDMQSettingsRep(not.getDMQId(), not.getThreshold());
    }

    private org.objectweb.joram.shared.admin.AdminReply doProcess(Monit_GetFatherRep not) {
        return new Monitor_GetFatherRep(not.getFatherId());
    }

    private org.objectweb.joram.shared.admin.AdminReply doProcess(Monit_GetClusterRep not) {
        return new Monitor_GetClusterRep(not.getTopics());
    }

    private org.objectweb.joram.shared.admin.AdminReply doProcess(Monit_GetNumberRep not) {
        return new Monitor_GetNumberRep(not.getNumber());
    }

    private org.objectweb.joram.shared.admin.AdminReply doProcess(Monit_GetStatRep not) {
        return new Monitor_GetStatRep(not.getStats());
    }

    private org.objectweb.joram.shared.admin.AdminReply doProcess(Monit_GetNbMaxMsgRep not) {
        return new Monitor_GetNbMaxMsgRep(not.getNbMaxMsg());
    }

    public void setRightRequest(AgentId from, SetRightRequest request) throws AccessException {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected request: " + request));
        }
    }

    public void setDMQRequest(AgentId from, SetDMQRequest request) throws AccessException {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected request: " + request));
        }
    }

    public void requestGroupNot(AgentId from, RequestGroupNot not) {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("AdminTopicImpl.requestGroupNot(" + not + ')'));
        }
        Enumeration en = not.getClientMessages();
        while (en.hasMoreElements()) {
            ClientMessages cm = (ClientMessages)en.nextElement();
            try {
                this.clientMessages(from, cm);
            }
            catch (Exception exc) {}
        }
    }

    public SetRightRequest preProcess(SetRightRequest req) {
        return req;
    }

    public void postProcess(SetRightRequest req) {
    }

    public ClientMessages preProcess(AgentId from, ClientMessages msgs) {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("AdminTopicImpl.clientMessages(" + msgs + ')'));
        }
        if (!msgs.getPersistent() && !msgs.getAsyncSend()) {
            this.forward(from, new SendReplyNot(msgs.getClientContext(), msgs.getRequestId()));
        }
        this.processAdminRequests(msgs);
        return null;
    }

    public void deleteNot(AgentId from, DeleteNot not) {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected request: " + not));
        }
    }

    public void clusterRequest(AgentId from, ClusterRequest request) throws AccessException {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected request: " + request));
        }
    }

    public void clusterTest(AgentId from, ClusterTest request) {
        this.forward(from, new ClusterAck(request, false, "Topic [" + this.getId() + "] is an admin topic"));
    }

    public void clusterAck(AgentId from, ClusterAck ack) {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected notification: " + ack));
        }
    }

    public void clusterNot(AgentId from, ClusterNot not) {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected notification: " + not));
        }
    }

    public void unclusterRequest(AgentId from, UnclusterRequest request) throws MomException {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected request: " + request));
        }
    }

    public void setFatherRequest(AgentId from, SetFatherRequest request) throws MomException {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected request: " + request));
        }
    }

    public void fatherTest(AgentId from, FatherTest not) {
        this.forward(from, new FatherAck(not, false, "Topic [" + this.getId() + "] can't accept topic [" + from + "] as a son as it is an AdminTopic"));
    }

    public void fatherAck(AgentId from, FatherAck ack) {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected notification: " + ack));
        }
    }

    public void unsetFatherRequest(AgentId from, UnsetFatherRequest request) throws MomException {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
            JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("Unexpected request: " + request));
        }
    }

    public void topicForwardNot(AgentId from, TopicForwardNot not) {
        this.processAdminRequests(not.messages);
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        AgentId agId = uA.agent;
        Notification not = uA.not;
        if (not instanceof AdminRequest) {
            String reqId = ((AdminRequest)not).getId();
            if (reqId != null) {
                AgentId replyTo = (AgentId)this.requestsTable.remove(reqId);
                String info = this.strbuf.append("Request [").append(not.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [false]: unknown agent [").append(agId).append("]").toString();
                this.strbuf.setLength(0);
                this.distributeReply(replyTo, reqId, new org.objectweb.joram.shared.admin.AdminReply(false, info));
            }
        } else {
            super.doUnknownAgent(uA);
        }
    }

    private void processAdminRequests(ClientMessages not) {
        String msgId = null;
        AgentId replyTo = null;
        String info = null;
        org.objectweb.joram.shared.admin.AdminRequest request = null;
        if (not == null) {
            return;
        }
        Enumeration messages = not.getMessages().elements();
        while (messages.hasMoreElements()) {
            ++this.nbMsgsReceiveSinceCreation;
            Message msg = (Message)messages.nextElement();
            msgId = msg.id;
            replyTo = AgentId.fromString(msg.getReplyToId());
            request = null;
            try {
                request = (org.objectweb.joram.shared.admin.AdminRequest)msg.getAdminMessage();
                if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("--- " + this + ": got " + msg.getAdminMessage()));
                }
            }
            catch (ClassCastException exc) {
                JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)("--- " + this + ": got bad AdminRequest"));
                if (request == null) {
                    info = this.strbuf.append("Unexpected request to AdminTopic on server [").append(this.serverId).append("]: ").append(exc.getMessage()).toString();
                    this.strbuf.setLength(0);
                } else {
                    info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [false]: ").append(exc.getMessage()).toString();
                    this.strbuf.setLength(0);
                }
                this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, info));
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.processAdminRequests(replyTo, msgId, request, null);
        }
    }

    private void processAdminRequests(AgentId replyTo, String msgId, org.objectweb.joram.shared.admin.AdminRequest request, AgentId from) {
        String info = null;
        this.setSave();
        try {
            if (request instanceof StopServerRequest) {
                this.doProcess((StopServerRequest)request, replyTo, msgId);
            } else if (request instanceof CreateDestinationRequest) {
                this.doProcess((CreateDestinationRequest)request, replyTo, msgId);
            } else if (request instanceof DeleteDestination) {
                this.doProcess((DeleteDestination)request, replyTo, msgId);
            } else if (request instanceof SetCluster) {
                this.doProcess((SetCluster)request, replyTo, msgId);
            } else if (request instanceof UnsetCluster) {
                this.doProcess((UnsetCluster)request, replyTo, msgId);
            } else if (request instanceof SetFather) {
                this.doProcess((SetFather)request, replyTo, msgId);
            } else if (request instanceof UnsetFather) {
                this.doProcess((UnsetFather)request, replyTo, msgId);
            } else if (request instanceof CreateUserRequest) {
                this.doProcess((CreateUserRequest)request, replyTo, msgId);
            } else if (request instanceof UpdateUser) {
                this.doProcess((UpdateUser)request, replyTo, msgId);
            } else if (request instanceof DeleteUser) {
                this.doProcess((DeleteUser)request, replyTo, msgId);
            } else if (request instanceof SetRight) {
                this.doProcess((SetRight)request, replyTo, msgId);
            } else if (request instanceof SetDefaultDMQ) {
                this.doProcess((SetDefaultDMQ)request, replyTo, msgId);
            } else if (request instanceof SetDestinationDMQ) {
                this.doProcess((SetDestinationDMQ)request, replyTo, msgId);
            } else if (request instanceof SetUserDMQ) {
                this.doProcess((SetUserDMQ)request, replyTo, msgId);
            } else if (request instanceof SetNbMaxMsg) {
                this.doProcess((SetNbMaxMsg)request, replyTo, msgId);
            } else if (request instanceof SetDefaultThreshold) {
                this.doProcess((SetDefaultThreshold)request, replyTo, msgId);
            } else if (request instanceof SetQueueThreshold) {
                this.doProcess((SetQueueThreshold)request, replyTo, msgId);
            } else if (request instanceof SetUserThreshold) {
                this.doProcess((SetUserThreshold)request, replyTo, msgId);
            } else if (request instanceof UnsetDefaultDMQ) {
                this.doProcess((UnsetDefaultDMQ)request, replyTo, msgId);
            } else if (request instanceof UnsetDestinationDMQ) {
                this.doProcess((UnsetDestinationDMQ)request, replyTo, msgId);
            } else if (request instanceof UnsetUserDMQ) {
                this.doProcess((UnsetUserDMQ)request, replyTo, msgId);
            } else if (request instanceof UnsetDefaultThreshold) {
                this.doProcess((UnsetDefaultThreshold)request, replyTo, msgId);
            } else if (request instanceof UnsetQueueThreshold) {
                this.doProcess((UnsetQueueThreshold)request, replyTo, msgId);
            } else if (request instanceof UnsetUserThreshold) {
                this.doProcess((UnsetUserThreshold)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetServersIds) {
                this.doProcess((Monitor_GetServersIds)request, replyTo, msgId);
            } else if (request instanceof GetDomainNames) {
                this.doProcess((GetDomainNames)request, replyTo, msgId);
            } else if (request instanceof GetLocalServer) {
                this.doProcess((GetLocalServer)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetDestinations) {
                this.doProcess((Monitor_GetDestinations)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetUsers) {
                this.doProcess((Monitor_GetUsers)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetReaders) {
                this.doProcess((Monitor_GetReaders)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetWriters) {
                this.doProcess((Monitor_GetWriters)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetFreeAccess) {
                this.doProcess((Monitor_GetFreeAccess)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetDMQSettings) {
                this.doProcess((Monitor_GetDMQSettings)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetFather) {
                this.doProcess((Monitor_GetFather)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetCluster) {
                this.doProcess((Monitor_GetCluster)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetPendingMessages) {
                this.doProcess((Monitor_GetPendingMessages)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetPendingRequests) {
                this.doProcess((Monitor_GetPendingRequests)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetStat) {
                this.doProcess((Monitor_GetStat)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetNbMaxMsg) {
                this.doProcess((Monitor_GetNbMaxMsg)request, replyTo, msgId);
            } else if (request instanceof Monitor_GetSubscriptions) {
                this.doProcess((Monitor_GetSubscriptions)request, replyTo, msgId);
            } else if (request instanceof SpecialAdmin) {
                this.doProcess((SpecialAdmin)request, replyTo, msgId);
            } else if (request instanceof AddServerRequest) {
                this.doProcess((AddServerRequest)request, replyTo, msgId, from);
            } else if (request instanceof AddDomainRequest) {
                this.doProcess((AddDomainRequest)request, replyTo, msgId, from);
            } else if (request instanceof RemoveServerRequest) {
                this.doProcess((RemoveServerRequest)request, replyTo, msgId, from);
            } else if (request instanceof RemoveDomainRequest) {
                this.doProcess((RemoveDomainRequest)request, replyTo, msgId, from);
            } else if (request instanceof GetConfigRequest) {
                this.doProcess((GetConfigRequest)request, replyTo, msgId);
            } else if (request instanceof UserAdminRequest) {
                this.doProcess((UserAdminRequest)request, replyTo, msgId);
            } else if (request instanceof GetSubscriberIds) {
                this.doProcess((GetSubscriberIds)request, replyTo, msgId);
            } else if (request instanceof QueueAdminRequest) {
                this.doProcess((QueueAdminRequest)request, replyTo, msgId);
            }
        }
        catch (UnknownServerException exc) {
            info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], successful [false]: ").append(exc.getMessage()).toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, info));
        }
        catch (MomException exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) {
                JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)exc);
            }
            if (request == null) {
                info = this.strbuf.append("Unexpected request to AdminTopic on server [").append(this.serverId).append("]: ").append(exc.getMessage()).toString();
                this.strbuf.setLength(0);
            } else {
                info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [false]: ").append(exc.getMessage()).toString();
                this.strbuf.setLength(0);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, info));
        }
    }

    private void doProcess(StopServerRequest request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, "Server stopped"));
            AgentServer.stop(false, 500L, true);
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(CreateDestinationRequest request, AgentId replyTo, String msgId) throws UnknownServerException, RequestException {
        if (this.checkServerId(request.getServerId())) {
            DestinationDesc destDesc = this.createDestination(request.getDestinationName(), null, request.getProperties(), request.getExpectedType(), request.getClassName(), request.getClass().getName(), this.strbuf);
            this.distributeReply(replyTo, msgId, new CreateDestinationReply(destDesc.getId().toString(), destDesc.getName(), destDesc.getType(), this.strbuf.toString()));
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)this.strbuf.toString());
            }
            this.strbuf.setLength(0);
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    public DestinationDesc createDestination(String destName, AgentId adminId, Properties properties, String type, String className, String requestClassName, StringBuffer strbuf) throws UnknownServerException, RequestException {
        DestinationDesc destDesc;
        boolean destNameActivated = destName != null && !destName.equals("");
        Agent dest = null;
        if (destNameActivated && this.destinationsTable.containsKey(destName)) {
            destDesc = (DestinationDesc)this.destinationsTable.get(destName);
            if (!destDesc.isAssignableTo(type)) {
                throw new RequestException("Destination type not compliant");
            }
            strbuf.append("Request [").append(requestClassName).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: destination [").append(destName).append("] has been retrieved");
        } else {
            String destType;
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
                dest = (Agent)clazz.newInstance();
                if (destName != null) {
                    dest.name = destName;
                }
                if (adminId == null) {
                    adminId = this.getId();
                }
                ((AdminDestinationItf)((Object)dest)).init(adminId, properties);
                Method getTypeM = clazz.getMethod("getDestinationType", new Class[0]);
                destType = (String)getTypeM.invoke(null, new Object[0]);
            }
            catch (Exception exc) {
                JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)("Could not instantiate Destination class [" + className + "]: "), (Throwable)exc);
                if (exc instanceof ClassCastException) {
                    throw new RequestException("Class [" + className + "] is not a Destination class.");
                }
                throw new RequestException("Could not instantiate Destination class [" + className + "]: " + exc);
            }
            AgentId createdDestId = dest.getId();
            if (!destNameActivated) {
                destName = createdDestId.toString();
            }
            if (!(destDesc = new DestinationDesc(createdDestId, destName, className, destType)).isAssignableTo(type)) {
                throw new RequestException("Destination type not compliant");
            }
            try {
                dest.deploy();
                this.destinationsTable.put(destName, destDesc);
                strbuf.append("Request [").append(requestClassName).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: ").append(className).append(" [").append(createdDestId.toString()).append("] has been created and deployed");
            }
            catch (Exception exc) {
                if (JoramTracing.dbgDestination.isLoggable(BasicLevel.ERROR)) {
                    JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)"xxx", (Throwable)exc);
                }
                throw new RequestException("Error while deploying Destination [" + clazz + "]: " + exc);
            }
        }
        return destDesc;
    }

    public static DestinationDesc createDestinationAndSave(String destName, AgentId adminId, Properties properties, String type, String className, String requestClassName, StringBuffer strbuf) throws UnknownServerException, RequestException, IOException {
        DestinationDesc destDesc = ref.createDestination(destName, adminId, properties, type, className, requestClassName, strbuf);
        AgentServer.getTransaction().save(AdminTopicImpl.ref.agent, ref.getId().toString());
        return destDesc;
    }

    public static boolean isDestinationTableContain(String destName) {
        return AdminTopicImpl.ref.destinationsTable.containsKey(destName);
    }

    private void doProcess(DeleteDestination request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getId());
        if (this.checkServerId(destId.getTo())) {
            Enumeration destinations = this.destinationsTable.elements();
            while (destinations.hasMoreElements()) {
                DestinationDesc destDesc = (DestinationDesc)destinations.nextElement();
                if (!destDesc.getId().equals(destId)) continue;
                this.destinationsTable.remove(destDesc.getName());
                break;
            }
            this.forward(destId, new DeleteNot());
            String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [true]: destination [").append(destId).append("], successfuly notified for deletion").toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, info));
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)info);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(SetCluster request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId initId = AgentId.fromString(request.getInitId());
        AgentId topId = AgentId.fromString(request.getTopId());
        if (this.checkServerId(initId.getTo())) {
            this.forward(initId, new ClusterRequest(msgId, topId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(initId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(UnsetCluster request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId topId = AgentId.fromString(request.getTopId());
        if (this.checkServerId(topId.getTo())) {
            this.forward(topId, new UnclusterRequest(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(topId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(SetFather request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId fatherId = AgentId.fromString(request.getFather());
        AgentId sonId = AgentId.fromString(request.getSon());
        if (this.checkServerId(sonId.getTo())) {
            this.forward(sonId, new SetFatherRequest(msgId, fatherId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(sonId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(UnsetFather request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId topId = AgentId.fromString(request.getTopId());
        if (this.checkServerId(topId.getTo())) {
            this.forward(topId, new UnsetFatherRequest(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(topId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    public void doProcess(CreateUserRequest request, AgentId replyTo, String msgId) throws UnknownServerException, RequestException {
        if (this.checkServerId(request.getServerId())) {
            String info;
            Identity identity = request.getIdentity();
            String name = identity.getUserName();
            AgentId proxId = (AgentId)this.proxiesTable.get(name);
            if (proxId != null) {
                Identity userIdentity = (Identity)this.usersTable.get(name);
                if (logger.isLoggable(BasicLevel.INFO)) {
                    logger.log(BasicLevel.INFO, (Object)("User [" + name + "] already exists : " + userIdentity));
                }
                try {
                    if (!identity.check(userIdentity)) {
                        throw new RequestException("User [" + name + "] already exists" + " but with a different password.");
                    }
                }
                catch (Exception e) {
                    throw new RequestException("User [" + name + "] already exists :: Exception :" + e.getMessage());
                }
                info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: proxy [").append(proxId.toString()).append("] of user [").append(name).append("] has been retrieved").toString();
                this.strbuf.setLength(0);
            } else {
                UserAgent proxy = new UserAgent();
                if (name != null) {
                    proxy.name = name;
                }
                proxId = proxy.getId();
                try {
                    proxy.deploy();
                    this.usersTable.put(name, identity);
                    this.proxiesTable.put(name, proxy.getId());
                    info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: proxy [").append(proxId.toString()).append("] for user [").append(name).append("] has been created and deployed").toString();
                    this.strbuf.setLength(0);
                }
                catch (Exception exc) {
                    throw new RequestException("User proxy not deployed: " + exc);
                }
            }
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)info);
            }
            this.distributeReply(replyTo, msgId, new CreateUserReply(proxId.toString(), info));
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    public static void CreateUserAndSave(CreateUserRequest request, AgentId replyTo, String msgId) throws UnknownServerException, RequestException, IOException {
        ref.doProcess(request, replyTo, msgId);
        AgentServer.getTransaction().save(AdminTopicImpl.ref.agent, ref.getId().toString());
    }

    private void doProcess(UpdateUser request, AgentId replyTo, String msgId) throws RequestException, UnknownServerException {
        String name = request.getUserName();
        AgentId proxId = AgentId.fromString(request.getProxId());
        if (this.checkServerId(proxId.getTo())) {
            if (!this.usersTable.containsKey(name)) {
                throw new RequestException("User [" + name + "] does not exist");
            }
            Identity newIdentity = request.getNewIdentity();
            if (!newIdentity.getUserName().equals(name) && this.usersTable.containsKey(newIdentity.getUserName())) {
                throw new RequestException("Name [" + newIdentity.getUserName() + "] already used");
            }
            if (this.usersTable.containsKey(name)) {
                this.usersTable.remove(name);
                this.proxiesTable.remove(name);
                this.usersTable.put(newIdentity.getUserName(), newIdentity);
                this.proxiesTable.put(newIdentity.getUserName(), proxId);
            }
            String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: user [").append(name).append("] has been updated to [").append(newIdentity.getUserName()).append("]").toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, info));
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)info);
            }
        } else {
            this.forward(AdminTopic.getDefault(proxId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(DeleteUser request, AgentId replyTo, String msgId) throws UnknownServerException {
        String name = request.getUserName();
        AgentId proxId = AgentId.fromString(request.getProxId());
        if (this.checkServerId(proxId.getTo())) {
            String info;
            if (this.usersTable.containsKey(name)) {
                this.forward(proxId, new DeleteNot());
                this.usersTable.remove(name);
                this.proxiesTable.remove(name);
                info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [true]: proxy [").append(proxId).append("], of user [").append(name).append("] has been notified of deletion").toString();
                this.strbuf.setLength(0);
            } else {
                info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [false]: user [").append(name).append(" does not exist").toString();
                this.strbuf.setLength(0);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, info));
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)info);
            }
        } else {
            this.forward(AdminTopic.getDefault(proxId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    public void doProcess(SetRight request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDestId());
        if (this.checkServerId(destId.getTo())) {
            AgentId userId = null;
            if (request.getUserProxId() != null) {
                userId = AgentId.fromString(request.getUserProxId());
            }
            int right = 0;
            if (request instanceof SetReader) {
                right = READ;
            } else if (request instanceof SetWriter) {
                right = WRITE;
            } else if (request instanceof UnsetReader) {
                right = -READ;
            } else if (request instanceof UnsetWriter) {
                right = -WRITE;
            }
            this.forward(destId, new SetRightRequest(msgId, userId, right));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    public static void setRightAndSave(SetRight request, AgentId replyTo, String msgId) throws UnknownServerException, IOException {
        ref.doProcess(request, replyTo, msgId);
        AgentServer.getTransaction().save(AdminTopicImpl.ref.agent, ref.getId().toString());
    }

    private void doProcess(SetDefaultDMQ request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            AgentId dmqId = null;
            if (request.getDmqId() != null) {
                dmqId = AgentId.fromString(request.getDmqId());
            }
            QueueImpl.defaultDMQId = dmqId;
            String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [true]: dmq [").append(dmqId.toString()).append("], has been successfuly set as the default one").toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, info));
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)info);
            }
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(SetDestinationDMQ request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDestId());
        if (this.checkServerId(destId.getTo())) {
            AgentId dmqId = AgentId.fromString(request.getDmqId());
            this.forward(destId, new SetDMQRequest(msgId, dmqId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(SetUserDMQ request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId userId = AgentId.fromString(request.getUserProxId());
        if (this.checkServerId(userId.getTo())) {
            AgentId dmqId = AgentId.fromString(request.getDmqId());
            this.forward(userId, new SetDMQRequest(msgId, dmqId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(userId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(SetDefaultThreshold request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            QueueImpl.defaultThreshold = new Integer(request.getThreshold());
            String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [true]: default threshold [").append(request.getThreshold()).append("] has been set").toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, info));
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)info);
            }
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(SetNbMaxMsg request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getId());
        if (this.checkServerId(destId.getTo())) {
            int nbMaxMsg = request.getNbMaxMsg();
            String subName = request.getSubName();
            this.forward(destId, new SetNbMaxMsgRequest(msgId, nbMaxMsg, subName));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(SetQueueThreshold request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getQueueId());
        if (this.checkServerId(destId.getTo())) {
            int thresh = request.getThreshold();
            this.forward(destId, new SetThreshRequest(msgId, new Integer(thresh)));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(SetUserThreshold request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId userId = AgentId.fromString(request.getUserProxId());
        if (this.checkServerId(userId.getTo())) {
            int thresh = request.getThreshold();
            this.forward(userId, new SetThreshRequest(msgId, new Integer(thresh)));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(userId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(UnsetDefaultDMQ request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            QueueImpl.defaultDMQId = null;
            String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [true]: default dmq has been unset").toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, info));
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)info);
            }
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(UnsetDestinationDMQ request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDestId());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new SetDMQRequest(msgId, null));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(UnsetUserDMQ request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId userId = AgentId.fromString(request.getUserProxId());
        if (this.checkServerId(userId.getTo())) {
            this.forward(userId, new SetDMQRequest(msgId, null));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(userId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(UnsetDefaultThreshold request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            QueueImpl.defaultThreshold = null;
            String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [true]: default threshold has been unset").toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, info));
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"Default threshold unset.");
            }
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(UnsetQueueThreshold request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getQueueId());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new SetThreshRequest(msgId, null));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(UnsetUserThreshold request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId userId = AgentId.fromString(request.getUserProxId());
        if (this.checkServerId(userId.getTo())) {
            this.forward(userId, new SetThreshRequest(msgId, null));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(userId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetServersIds request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            try {
                int serversCount;
                Enumeration<Object> servers;
                String domainName = request.getDomainName();
                A3CMLConfig config = AgentServer.getConfig();
                if (domainName != null) {
                    A3CMLDomain domain = config.getDomain(domainName);
                    servers = domain.servers.elements();
                    serversCount = domain.servers.size();
                } else {
                    servers = config.servers.elements();
                    serversCount = config.servers.size();
                }
                int[] ids = new int[serversCount];
                String[] names = new String[serversCount];
                String[] hostNames = new String[serversCount];
                int i = 0;
                while (servers.hasMoreElements()) {
                    A3CMLServer server = (A3CMLServer)servers.nextElement();
                    ids[i] = server.sid;
                    names[i] = server.name;
                    hostNames[i] = server.hostname;
                    ++i;
                }
                Monitor_GetServersIdsRep reply = new Monitor_GetServersIdsRep(ids, names, hostNames);
                this.distributeReply(replyTo, msgId, reply);
            }
            catch (Exception exc) {
                if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
                this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
            }
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(GetLocalServer request, AgentId replyTo, String msgId) throws UnknownServerException {
        try {
            A3CMLConfig config = AgentServer.getConfig();
            A3CMLServer a3cmlServer = config.getServer(AgentServer.getServerId());
            this.distributeReply(replyTo, msgId, new GetLocalServerRep(a3cmlServer.sid, a3cmlServer.name, a3cmlServer.hostname));
        }
        catch (Exception exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(GetDomainNames request, AgentId replyTo, String msgId) {
        try {
            A3CMLConfig config = AgentServer.getConfig();
            A3CMLServer server = config.getServer((short)request.getServerId());
            String[] domainNames = new String[server.networks.size()];
            for (int i = 0; i < server.networks.size(); ++i) {
                A3CMLNetwork nw = (A3CMLNetwork)server.networks.elementAt(i);
                domainNames[i] = nw.domain;
            }
            GetDomainNamesRep reply = new GetDomainNamesRep(domainNames);
            this.distributeReply(replyTo, msgId, reply);
        }
        catch (Exception exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(Monitor_GetDestinations request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            Enumeration destinations = this.destinationsTable.elements();
            String[] ids = new String[this.destinationsTable.size()];
            String[] names = new String[this.destinationsTable.size()];
            String[] types = new String[this.destinationsTable.size()];
            int i = 0;
            while (destinations.hasMoreElements()) {
                DestinationDesc destDesc = (DestinationDesc)destinations.nextElement();
                ids[i] = destDesc.getId().toString();
                names[i] = destDesc.getName();
                types[i] = destDesc.getType();
                ++i;
            }
            Monitor_GetDestinationsRep reply = new Monitor_GetDestinationsRep(ids, names, types);
            this.distributeReply(replyTo, msgId, reply);
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetUsers request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            Monitor_GetUsersRep reply = new Monitor_GetUsersRep();
            Enumeration names = this.proxiesTable.keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                reply.addUser(name, ((AgentId)this.proxiesTable.get(name)).toString());
            }
            this.distributeReply(replyTo, msgId, reply);
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetReaders request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDest());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new Monit_GetReaders(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetWriters request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDest());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new Monit_GetWriters(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetFreeAccess request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDest());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new Monit_FreeAccess(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetDMQSettings request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (request.getServerId() != -1) {
            if (this.checkServerId(request.getServerId())) {
                String id = null;
                if (QueueImpl.defaultDMQId != null) {
                    id = QueueImpl.defaultDMQId.toString();
                }
                Monitor_GetDMQSettingsRep reply = new Monitor_GetDMQSettingsRep(id, QueueImpl.defaultThreshold);
                this.distributeReply(replyTo, msgId, reply);
            } else {
                this.forward(AdminTopic.getDefault((short)request.getServerId()), new AdminRequestNot(replyTo, msgId, request));
            }
        } else if (request.getTarget() != null) {
            AgentId targetId = AgentId.fromString(request.getTarget());
            if (this.checkServerId(targetId.getTo())) {
                this.forward(targetId, new Monit_GetDMQSettings(msgId));
                if (replyTo != null) {
                    this.requestsTable.put(msgId, replyTo);
                }
            } else {
                this.forward(AdminTopic.getDefault(targetId.getTo()), new AdminRequestNot(replyTo, msgId, request));
            }
        }
    }

    private void doProcess(Monitor_GetFather request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId topicId = AgentId.fromString(request.getTopic());
        if (this.checkServerId(topicId.getTo())) {
            this.forward(topicId, new Monit_GetFather(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(topicId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetCluster request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId topicId = AgentId.fromString(request.getTopic());
        if (this.checkServerId(topicId.getTo())) {
            this.forward(topicId, new Monit_GetCluster(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(topicId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetPendingMessages request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDest());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new Monit_GetPendingMessages(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetPendingRequests request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDest());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new Monit_GetPendingRequests(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetStat request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDest());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new Monit_GetStat(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetNbMaxMsg request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getId());
        if (this.checkServerId(destId.getTo())) {
            String subName = request.getSubName();
            this.forward(destId, new Monit_GetNbMaxMsg(msgId, subName));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(Monitor_GetSubscriptions request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDest());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new Monit_GetSubscriptions(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(SpecialAdmin request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString(request.getDestId());
        if (this.checkServerId(destId.getTo())) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("AdminTopicImpl.doProcess SpecialAdminRequest destId=" + destId));
            }
            if (this.getId().equals(destId)) {
                this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, "destId mustn't be TopicAdmin."));
                return;
            }
            this.forward(destId, new SpecialAdminRequest(msgId, request));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new AdminRequestNot(replyTo, msgId, request));
        }
    }

    private void doProcess(AddDomainRequest request, AgentId replyTo, String msgId, AgentId from) {
        try {
            ServerConfigHelper helper = new ServerConfigHelper(true);
            if (helper.addDomain(request.getDomainName(), request.getNetwork(), request.getServerId(), request.getPort())) {
                this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, "Domain added"));
            }
            if (from == null) {
                this.broadcastRequest(request, -1, replyTo, msgId);
            }
        }
        catch (ServerConfigHelper.NameAlreadyUsedException exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, 0, exc.getMessage(), null));
        }
        catch (ServerConfigHelper.StartFailureException exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, 1, exc.getMessage(), null));
        }
        catch (Exception exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(RemoveDomainRequest request, AgentId replyTo, String msgId, AgentId from) {
        try {
            ServerConfigHelper helper = new ServerConfigHelper(true);
            if (helper.removeDomain(request.getDomainName())) {
                this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, "Domain removed"));
            }
            if (from == null) {
                this.broadcastRequest(request, -1, replyTo, msgId);
            }
        }
        catch (Exception exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(AddServerRequest request, AgentId replyTo, String msgId, AgentId from) {
        try {
            ServerConfigHelper helper = new ServerConfigHelper(false);
            helper.addServer(request.getServerId(), request.getHostName(), request.getDomainName(), request.getPort(), request.getServerName());
            helper.addService(request.getServerId(), "org.objectweb.joram.mom.proxies.ConnectionManager", "root root");
            String[] serviceNames = request.getServiceNames();
            String[] serviceArgs = request.getServiceArgs();
            for (int i = 0; i < serviceNames.length; ++i) {
                helper.addService(request.getServerId(), serviceNames[i], serviceArgs[i]);
            }
            helper.commit();
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, "Server added"));
            if (from == null) {
                this.broadcastRequest(request, request.getServerId(), replyTo, msgId);
            }
        }
        catch (ServerConfigHelper.ServerIdAlreadyUsedException exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, 2, exc.getMessage(), null));
        }
        catch (Exception exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(RemoveServerRequest request, AgentId replyTo, String msgId, AgentId from) {
        try {
            ServerConfigHelper helper = new ServerConfigHelper(true);
            helper.removeServer(request.getServerId());
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, "Server removed"));
            if (from == null) {
                this.broadcastRequest(request, request.getServerId(), replyTo, msgId);
            }
        }
        catch (UnknownServerException exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, 3, exc.getMessage(), null));
        }
        catch (Exception exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
        }
    }

    private void broadcastRequest(org.objectweb.joram.shared.admin.AdminRequest req, int avoidServerId, AgentId replyTo, String msgId) {
        AdminRequestNot not = new AdminRequestNot(replyTo, msgId, req);
        Enumeration ids = AgentServer.getServersIds();
        while (ids.hasMoreElements()) {
            short id = (Short)ids.nextElement();
            if (id == AgentServer.getServerId() || id == avoidServerId) continue;
            this.forward(AdminTopic.getDefault(id), not);
        }
    }

    private void doProcess(GetConfigRequest request, AgentId replyTo, String msgId) {
        try {
            A3CMLConfig a3cmlConfig = AgentServer.getConfig();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(baos);
            A3CML.toXML(a3cmlConfig, out);
            out.flush();
            baos.flush();
            baos.close();
            String config = baos.toString();
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(true, config));
        }
        catch (Exception exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(UserAdminRequest request, AgentId replyTo, String requestMsgId) throws UnknownServerException {
        AgentId userId = AgentId.fromString(request.getUserId());
        if (this.checkServerId(userId.getTo())) {
            this.forward(userId, new UserAdminRequestNot(request, replyTo, requestMsgId, this.createMessageId()));
        } else {
            this.forward(AdminTopic.getDefault(userId.getTo()), new AdminRequestNot(replyTo, requestMsgId, request));
        }
    }

    private void doProcess(GetSubscriberIds request, AgentId replyTo, String requestMsgId) throws UnknownServerException {
        try {
            AgentId topicId = AgentId.fromString(request.getTopicId());
            this.forward(topicId, new DestinationAdminRequestNot(request, replyTo, requestMsgId, this.createMessageId()));
        }
        catch (Exception exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, requestMsgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(QueueAdminRequest request, AgentId replyTo, String requestMsgId) throws UnknownServerException {
        try {
            AgentId queueId = AgentId.fromString(request.getQueueId());
            this.forward(queueId, new DestinationAdminRequestNot(request, replyTo, requestMsgId, this.createMessageId()));
        }
        catch (Exception exc) {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, requestMsgId, new org.objectweb.joram.shared.admin.AdminReply(false, exc.toString()));
        }
    }

    private boolean checkServerId(int serverId) throws UnknownServerException {
        if (serverId == this.serverId) {
            return true;
        }
        Enumeration ids = AgentServer.getServersIds();
        while (ids.hasMoreElements()) {
            if (((Short)ids.nextElement()).intValue() != serverId) continue;
            return false;
        }
        throw new UnknownServerException("server#" + serverId + " is unknow.");
    }

    private String createMessageId() {
        ++this.msgCounter;
        return "ID:" + this.getId().toString() + '_' + this.msgCounter;
    }

    private void distributeReply(AgentId to, String msgId, org.objectweb.joram.shared.admin.AdminReply reply) {
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("AdminTopicImpl.distributeReply(" + to + ',' + msgId + ',' + reply + ')'));
        }
        if (to == null) {
            return;
        }
        Message message = new Message();
        message.id = this.createMessageId();
        message.correlationId = msgId;
        message.timestamp = System.currentTimeMillis();
        message.setDestination(this.getId().toString(), "topic");
        try {
            message.setAdminMessage(reply);
            ClientMessages clientMessages = new ClientMessages(-1, -1, message);
            this.forward(to, clientMessages);
            ++this.nbMsgsDeliverSinceCreation;
        }
        catch (Exception exc) {
            JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(QueueImpl.defaultDMQId);
        out.writeObject(QueueImpl.defaultThreshold);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        QueueImpl.defaultDMQId = (AgentId)in.readObject();
        QueueImpl.defaultThreshold = (Integer)in.readObject();
        in.defaultReadObject();
        ref = this;
    }

    public static class DestinationDesc
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AgentId id;
        private String name;
        private String className;
        private String type;

        public DestinationDesc(AgentId id, String name, String className, String type) {
            this.id = id;
            this.name = name;
            this.className = className.intern();
            this.type = type.intern();
        }

        public final AgentId getId() {
            return this.id;
        }

        public final String getName() {
            return this.name;
        }

        public final String getClassName() {
            return this.className;
        }

        public final String getType() {
            return this.type;
        }

        public boolean isAssignableTo(String assignedType) {
            return this.type.startsWith(assignedType);
        }

        public String toString() {
            return '(' + super.toString() + ",id=" + this.id + ",name=" + this.name + ",className=" + this.className + ",type=" + this.type + ')';
        }
    }

    static class AdminRequestNot
    extends Notification {
        private static final long serialVersionUID = 1L;
        String msgId = null;
        AgentId replyTo = null;
        org.objectweb.joram.shared.admin.AdminRequest request = null;

        AdminRequestNot(AgentId replyTo, String msgId, org.objectweb.joram.shared.admin.AdminRequest request) {
            this.msgId = msgId;
            this.replyTo = replyTo;
            this.request = request;
        }
    }
}

