/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenColumn;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenInfos;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbExternalTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbPrimitiveElementMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.ScalarField;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.type.api.PTypeSpace;

public class RdbGenTable {
    public RdbGenInfos genInfos = null;
    public String tableName = null;
    public String aliasTableName = null;
    public List columns = new ArrayList();
    public List inheritedColumns = new ArrayList();
    public List colocatedColumns = null;
    public boolean colocatedTable = false;
    public List joins = null;
    public Map jn2join = null;
    public boolean readOnly = false;
    public boolean mustGenerateUpdate = true;
    public boolean isMainTable;
    private Boolean psMand = null;

    public RdbGenTable() {
    }

    public RdbGenTable(RdbExternalTable extTable, RdbGenTable mainTable, Class constantHolderClass, RdbGenInfos genInfos) throws PException {
        this.constructFromTable(extTable, constantHolderClass, genInfos);
        this.tableName = extTable.getName();
        this.aliasTableName = extTable.getAliasName();
        this.isMainTable = false;
        this.readOnly = extTable.isReadOnly();
        this.joins = new ArrayList();
        this.jn2join = new HashMap();
        int joinIdx = 0;
        Iterator itj = extTable.getRdbJoins().iterator();
        while (itj.hasNext()) {
            RdbJoin j = (RdbJoin)itj.next();
            RdbGenJoin rgj = new RdbGenJoin(mainTable, this, j, joinIdx);
            ++joinIdx;
            this.jn2join.put(j.getName(), rgj);
            this.joins.add(rgj);
        }
        if (extTable.getPrimitiveElementMappings() != null) {
            Iterator it = extTable.getPrimitiveElementMappings().iterator();
            while (it.hasNext()) {
                RdbPrimitiveElementMapping rpem = (RdbPrimitiveElementMapping)it.next();
                Iterator entryIt = rpem.getPrimitiveElementByRdbJoin().entrySet().iterator();
                if (!entryIt.hasNext()) continue;
                if (rpem.getName() == null) {
                    throw new PException("Primitive element " + ((PrimitiveElement)rpem.getLinkedMO()).getName() + " has a null column name");
                }
                RdbGenColumn rgc = this.getColumn(rpem.getName());
                rgc.pes = new ArrayList();
                rgc.joins = new ArrayList();
                TypedElement pe = null;
                while (entryIt.hasNext()) {
                    Map.Entry me = entryIt.next();
                    RdbJoin j = (RdbJoin)me.getKey();
                    pe = (PrimitiveElement)me.getValue();
                    rgc.pes.add(pe);
                    rgc.joins.add(this.jn2join.get(j.getName()));
                }
                rgc.hiddenField = pe instanceof ScalarField;
                rgc.columnType = pe.getType();
            }
        }
    }

    public RdbGenTable(RdbTable mainTable, Class constantHolderClass, RdbGenInfos genInfos) throws PException {
        this.constructFromTable(mainTable, constantHolderClass, genInfos);
        this.tableName = mainTable.getName();
        this.aliasTableName = mainTable.getAliasName();
        this.isMainTable = true;
    }

    public void constructFromTable(RdbTable table, Class constantHolderClass, RdbGenInfos genInfos) throws PException {
        this.genInfos = genInfos;
        this.colocatedTable |= table.isColocated() && !table.isColocatedMaster();
        Iterator it = table.getPrimitiveElementMappings().iterator();
        while (it.hasNext()) {
            RdbPrimitiveElementMapping rpem = (RdbPrimitiveElementMapping)it.next();
            RdbGenColumn rgc = new RdbGenColumn();
            rgc.columnName = rpem.getName();
            if (rgc.columnName == null) {
                throw new PException("Primitive element " + ((PrimitiveElement)rpem.getLinkedMO()).getName() + " has a null column name");
            }
            rgc.columnNotNull = rpem.isNotNull();
            rgc.table = this;
            PrimitiveElement pe = (PrimitiveElement)rpem.getLinkedMO();
            if (pe != null) {
                rgc.columnType = pe.getType();
                rgc.columnSize = pe.getSize();
                rgc.columnScale = pe.getScale();
                rgc.hiddenField = pe instanceof ScalarField;
                if (pe.isConstant()) {
                    rgc.constant = constantHolderClass.getConstantValue(pe.getName());
                }
                rgc.fieldName = pe.getName();
            }
            rgc.columnSqlType = rpem.getType();
            if (rgc.columnSqlType != null && rgc.columnSqlType.length() == 0) {
                rgc.columnSqlType = null;
            }
            this.columns.add(rgc);
        }
    }

    public void fixMustGenerateUpdate() {
        RdbGenColumn rgc;
        int i;
        this.mustGenerateUpdate = false;
        for (i = 0; i < this.columns.size() && !this.mustGenerateUpdate; ++i) {
            rgc = (RdbGenColumn)this.columns.get(i);
            this.mustGenerateUpdate |= this.isUpdatableColumn(rgc);
        }
        for (i = 0; i < this.inheritedColumns.size() && !this.mustGenerateUpdate; ++i) {
            rgc = (RdbGenColumn)this.inheritedColumns.get(i);
            this.mustGenerateUpdate |= this.isUpdatableColumn(rgc);
        }
    }

    private boolean isUpdatableColumn(RdbGenColumn rgc) {
        if (rgc.joinCol != null) {
            return false;
        }
        return this.joins != null || !this.genInfos.colInGenId(rgc);
    }

    public boolean getMustGenerateUpdate() {
        return this.mustGenerateUpdate;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public List getJoins() {
        return this.joins;
    }

    public RdbGenInfos getGenInfos() {
        return this.genInfos;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableNameNoDot() {
        return this.tableName.replace('.', '_');
    }

    public String getAliasTableName() {
        return this.aliasTableName;
    }

    public String getAliasTableNameNoDot() {
        return this.aliasTableName.replace('.', '_');
    }

    public List getColumns() {
        return this.columns;
    }

    public List getInheritedColumns() {
        return this.inheritedColumns;
    }

    public List getColocatedColumns() {
        return this.colocatedColumns;
    }

    public boolean getColocatedTable() {
        return this.colocatedTable;
    }

    public boolean isMainTable() {
        return this.isMainTable;
    }

    public boolean preparedStatementMandatory() {
        if (this.psMand == null) {
            for (int i = 0; i < this.columns.size(); ++i) {
                if (((RdbGenColumn)this.columns.get((int)i)).columnType != PTypeSpace.SERIALIZED) continue;
                this.psMand = new Boolean(true);
                return true;
            }
            this.psMand = new Boolean(false);
        }
        return this.psMand;
    }

    boolean colocatedColumn(RdbGenColumn rgc) {
        if (this.colocatedColumns != null) {
            for (int i = 0; i < this.colocatedColumns.size(); ++i) {
                if (this.colocatedColumns.get(i) != rgc) continue;
                return true;
            }
        }
        return false;
    }

    public RdbGenColumn getColumn(String columnName) {
        int i;
        RdbGenColumn rgc = null;
        for (i = 0; i < this.columns.size(); ++i) {
            rgc = (RdbGenColumn)this.columns.get(i);
            if (!rgc.columnName.equals(columnName)) continue;
            return rgc;
        }
        for (i = 0; i < this.inheritedColumns.size(); ++i) {
            rgc = (RdbGenColumn)this.inheritedColumns.get(i);
            if (!rgc.columnName.equals(columnName)) continue;
            return rgc;
        }
        return null;
    }
}

