/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.parser.string;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.Comparator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.BasicBinaryLogicalOperator;
import org.objectweb.medor.expression.lib.BasicBinaryOperator;
import org.objectweb.medor.expression.lib.BasicComparator;
import org.objectweb.medor.expression.lib.BasicOperand;
import org.objectweb.medor.expression.lib.BasicParameterOperand;
import org.objectweb.medor.expression.lib.ConditionalAnd;
import org.objectweb.medor.expression.lib.ConditionalOr;
import org.objectweb.medor.expression.lib.DivideBy;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.Greater;
import org.objectweb.medor.expression.lib.GreaterEqual;
import org.objectweb.medor.expression.lib.Lower;
import org.objectweb.medor.expression.lib.LowerEqual;
import org.objectweb.medor.expression.lib.Minus;
import org.objectweb.medor.expression.lib.Mod;
import org.objectweb.medor.expression.lib.Mult;
import org.objectweb.medor.expression.lib.NotEqual;
import org.objectweb.medor.expression.lib.Or;
import org.objectweb.medor.expression.lib.Plus;
import org.objectweb.medor.expression.parser.api.ParameterTypeProvider;
import org.objectweb.medor.expression.parser.lib.ReplaceStringPlusByConcat;

public class ExpressionParser {
    private static final String STRCONSTTOK = "$";
    private static final String DELIMITERS = "$()+-=!<>&|/%*";
    private static final int TOKENPOS = 0;
    private static final int STRCONSTPOS = 1;

    public Expression parse(String exprstr, ParameterTypeProvider ptp) throws ExpressionException {
        ArrayList stringConst = new ArrayList();
        String exprwithoutstrconst = this.extractStringConst(exprstr, stringConst);
        Expression res = this.buildExpr(this.toStringArray(exprwithoutstrconst), new int[]{0, 0}, stringConst, ptp);
        res = new ReplaceStringPlusByConcat().rewrite(res);
        res.compileExpression();
        return res;
    }

    String extractStringConst(String expr, ArrayList stringConst) throws MalformedExpressionException {
        int startsc;
        StringBuffer res = new StringBuffer();
        int curpos = 0;
        while ((startsc = expr.indexOf(34, curpos)) != -1) {
            int endsc = expr.indexOf(34, startsc + 1);
            if (endsc == -1) {
                throw new MalformedExpressionException("Constant string starting at position" + startsc + " never ended.");
            }
            res.append(expr.substring(curpos, startsc).replaceAll(" ", ""));
            res.append(STRCONSTTOK);
            stringConst.add(expr.substring(startsc + 1, endsc));
            curpos = endsc + 1;
        }
        res.append(expr.substring(curpos).replaceAll(" ", ""));
        return res.toString();
    }

    private String[] toStringArray(String str) {
        String token;
        StringTokenizer tokenizer = new StringTokenizer(str, DELIMITERS, true);
        ArrayList<String> tokens = new ArrayList<String>();
        String[] nextToken = new String[]{null};
        while ((token = this.getNextToken(tokenizer, nextToken)) != null) {
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private Expression buildExpr(String[] tokens, int[] indexes, ArrayList stringConst, ParameterTypeProvider ptp) throws MalformedExpressionException {
        if (indexes[0] == tokens.length) {
            return null;
        }
        Expression firstnode = tokens[indexes[0]].equals("(") ? this.buildParenthesExpr(tokens, indexes, stringConst, ptp) : this.buildAtomicOperandExpr(tokens, indexes, stringConst, ptp);
        if (indexes[0] == tokens.length || tokens[indexes[0]].equals(")")) {
            return firstnode;
        }
        Operator operator = this.buildNextExpr(tokens, indexes, stringConst, firstnode, ptp);
        if (operator == null) {
            throw new MalformedExpressionException("Wrong token found in token position " + indexes[0] + ": " + tokens[indexes[0]] + " (should be an operator)");
        }
        return operator;
    }

    private Operator buildNextExpr(String[] tokens, int[] indexes, ArrayList stringConst, Expression left, ParameterTypeProvider ptp) throws MalformedExpressionException {
        if (indexes[0] == tokens.length) {
            return null;
        }
        if (tokens[indexes[0]].equals(")")) {
            return null;
        }
        Operator operator = this.buildPri1OperatorExpr(tokens, indexes);
        if (operator != null) {
            Expression secondnode = tokens[indexes[0]].equals("(") ? this.buildParenthesExpr(tokens, indexes, stringConst, ptp) : this.buildAtomicOperandExpr(tokens, indexes, stringConst, ptp);
            Operator next = this.buildNextExpr(tokens, indexes, stringConst, operator, ptp);
            operator.setExpression(0, left);
            if (next != null) {
                if (this.priorTo(operator, next)) {
                    operator.setExpression(1, secondnode);
                    return next;
                }
                operator.setExpression(1, next);
                next.setExpression(0, secondnode);
                return operator;
            }
            operator.setExpression(1, secondnode);
            return operator;
        }
        operator = this.buildPri2OperatorExpr(tokens, indexes);
        if (operator != null) {
            Expression secondnode = tokens[indexes[0]].equals("(") ? this.buildParenthesExpr(tokens, indexes, stringConst, ptp) : this.buildAtomicOperandExpr(tokens, indexes, stringConst, ptp);
            Operator next = this.buildNextExpr(tokens, indexes, stringConst, operator, ptp);
            operator.setExpression(0, left);
            if (next != null) {
                if (this.priorTo(operator, next)) {
                    operator.setExpression(1, secondnode);
                    return next;
                }
                operator.setExpression(1, next);
                next.setExpression(0, secondnode);
                return operator;
            }
            operator.setExpression(1, secondnode);
            return operator;
        }
        operator = this.buildCompOperatorExpr(tokens, indexes);
        if (operator != null) {
            Expression secondnode = tokens[indexes[0]].equals("(") ? this.buildParenthesExpr(tokens, indexes, stringConst, ptp) : this.buildExpr(tokens, indexes, stringConst, ptp);
            Operator next = this.buildNextExpr(tokens, indexes, stringConst, operator, ptp);
            operator.setExpression(0, left);
            if (next != null) {
                if (this.priorTo(operator, next)) {
                    operator.setExpression(1, secondnode);
                    return next;
                }
                operator.setExpression(1, next);
                next.setExpression(0, secondnode);
                return operator;
            }
            operator.setExpression(1, secondnode);
            return operator;
        }
        operator = this.buildLogicalOperatorExpr(tokens, indexes);
        if (operator != null) {
            Expression secondnode = tokens[indexes[0]].equals("(") ? this.buildParenthesExpr(tokens, indexes, stringConst, ptp) : this.buildExpr(tokens, indexes, stringConst, ptp);
            Operator next = this.buildNextExpr(tokens, indexes, stringConst, operator, ptp);
            operator.setExpression(0, left);
            if (next != null) {
                if (this.priorTo(operator, next)) {
                    operator.setExpression(1, secondnode);
                    return next;
                }
                operator.setExpression(1, next);
                next.setExpression(0, secondnode);
                return operator;
            }
            operator.setExpression(1, secondnode);
            return operator;
        }
        throw new MalformedExpressionException("Wrong token found in token position " + indexes[0] + ": " + tokens[indexes[0]] + " (should be an operator)");
    }

    private Expression buildParenthesExpr(String[] tokens, int[] indexes, ArrayList stringConst, ParameterTypeProvider ptp) throws MalformedExpressionException {
        indexes[0] = indexes[0] + 1;
        Expression res = this.buildExpr(tokens, indexes, stringConst, ptp);
        if (!tokens[indexes[0]].equals(")")) {
            throw new MalformedExpressionException("Wrong token found in token position " + indexes[0] + ": " + tokens[indexes[0]]);
        }
        indexes[0] = indexes[0] + 1;
        return res;
    }

    private Expression buildAtomicOperandExpr(String[] tokens, int[] indexes, ArrayList stringConst, ParameterTypeProvider ptp) throws MalformedExpressionException {
        BasicOperand res = null;
        String operand = tokens[indexes[0]];
        if (operand.equals(STRCONSTTOK)) {
            res = new BasicOperand((String)stringConst.get(indexes[1]));
            indexes[1] = indexes[1] + 1;
        }
        if (res == null) {
            if (operand.equalsIgnoreCase("true")) {
                res = new BasicOperand(true);
            } else if (operand.equalsIgnoreCase("false")) {
                res = new BasicOperand(false);
            }
        }
        if (res == null) {
            try {
                long l = Long.parseLong(operand);
                res = l <= 127L && l >= -128L ? new BasicOperand((byte)l) : (l <= 32767L && l >= -32768L ? new BasicOperand((short)l) : (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE ? new BasicOperand((int)l) : new BasicOperand(l)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (res == null) {
            try {
                double d = Double.parseDouble(operand);
                res = d <= 3.4028234663852886E38 && d >= (double)1.4E-45f ? new BasicOperand((float)d) : new BasicOperand(d);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (res == null && Character.isJavaIdentifierStart(operand.charAt(0))) {
            String paramName = tokens[indexes[0]];
            if (ptp == null) {
                throw new MalformedExpressionException("ParameterTypeProvider required, but was null, for parameter " + paramName);
            }
            PType paramType = ptp.getParameterPType(paramName);
            if (paramType == null) {
                throw new MalformedExpressionException("Unknown type for parameter " + paramName);
            }
            res = new BasicParameterOperand(paramType, paramName);
        }
        if (res != null) {
            indexes[0] = indexes[0] + 1;
            return res;
        }
        throw new MalformedExpressionException("Wrong token found in token position " + indexes[0] + ": " + tokens[indexes[0]] + " (should be a constant or a variable)");
    }

    /*
     * WARNING - void declaration
     */
    private Operator buildLogicalOperatorExpr(String[] tokens, int[] indexes) {
        void var3_3;
        BasicBinaryLogicalOperator res;
        if (tokens[indexes[0]].equals("&&")) {
            res = new ConditionalAnd();
        } else if (tokens[indexes[0]].equals("||")) {
            res = new ConditionalOr();
        } else {
            return null;
        }
        indexes[0] = indexes[0] + 1;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Operator buildCompOperatorExpr(String[] tokens, int[] indexes) {
        void var3_3;
        BasicComparator res;
        if (tokens[indexes[0]].equals("==")) {
            res = new Equal();
        } else if (tokens[indexes[0]].equals("!=")) {
            res = new NotEqual();
        } else if (tokens[indexes[0]].equals("<")) {
            res = new Lower();
        } else if (tokens[indexes[0]].equals("<=")) {
            res = new LowerEqual();
        } else if (tokens[indexes[0]].equals(">")) {
            res = new Greater();
        } else if (tokens[indexes[0]].equals(">=")) {
            res = new GreaterEqual();
        } else {
            return null;
        }
        indexes[0] = indexes[0] + 1;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Operator buildPri2OperatorExpr(String[] tokens, int[] indexes) {
        void var3_3;
        BasicBinaryOperator res;
        if (tokens[indexes[0]].equals("+")) {
            res = new Plus();
        } else if (tokens[indexes[0]].equals("-")) {
            res = new Minus();
        } else if (tokens[indexes[0]].equals("|")) {
            res = new Or();
        } else {
            return null;
        }
        indexes[0] = indexes[0] + 1;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Operator buildPri1OperatorExpr(String[] tokens, int[] indexes) {
        void var3_3;
        BasicBinaryOperator res;
        if (tokens[indexes[0]].equals("*")) {
            res = new Mult();
        } else if (tokens[indexes[0]].equals("/")) {
            res = new DivideBy();
        } else if (tokens[indexes[0]].equals("%")) {
            res = new Mod();
        } else if (tokens[indexes[0]].equals("&")) {
            res = new And();
        } else {
            return null;
        }
        indexes[0] = indexes[0] + 1;
        return var3_3;
    }

    private String getNextToken(StringTokenizer tokenizer, String[] nexttoken) {
        if (nexttoken[0] != null) {
            String res = nexttoken[0];
            nexttoken[0] = null;
            return res;
        }
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String res = tokenizer.nextToken();
        if (res.equals("=") || res.equals("<") || res.equals(">") || res.equals("!")) {
            if (!tokenizer.hasMoreTokens()) {
                return res;
            }
            nexttoken[0] = tokenizer.nextToken();
            if (nexttoken[0].equals("=")) {
                nexttoken[0] = null;
                return res + "=";
            }
            return res;
        }
        if (res.equals("&")) {
            if (!tokenizer.hasMoreTokens()) {
                return res;
            }
            nexttoken[0] = tokenizer.nextToken();
            if (nexttoken[0].equals("&")) {
                nexttoken[0] = null;
                return "&&";
            }
            return res;
        }
        if (res.equals("|")) {
            if (!tokenizer.hasMoreTokens()) {
                return res;
            }
            nexttoken[0] = tokenizer.nextToken();
            if (nexttoken[0].equals("|")) {
                nexttoken[0] = null;
                return "||";
            }
            return res;
        }
        return res;
    }

    private boolean isLog(Operator token) {
        return token instanceof ConditionalAnd || token instanceof ConditionalOr;
    }

    private boolean isComp(Operator token) {
        return token instanceof Comparator;
    }

    private boolean isPri2(Operator token) {
        return token instanceof Plus || token instanceof Minus || token instanceof Or;
    }

    private boolean priorTo(Operator tok1, Operator tok2) {
        if (this.isLog(tok1)) {
            return false;
        }
        if (this.isComp(tok1)) {
            return this.isLog(tok2);
        }
        if (this.isPri2(tok1)) {
            return this.isLog(tok2) || this.isComp(tok2);
        }
        return this.isLog(tok2) || this.isComp(tok2) || this.isPri2(tok2);
    }
}

