/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.client;

import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.client.xml.ApplicationClient;
import org.ow2.jonas.deployment.client.xml.JonasClient;
import org.ow2.jonas.deployment.client.xml.JonasSecurity;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.JndiEnvRefsGroupDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.PersistenceUnitRefDesc;
import org.ow2.util.ee.metadata.car.api.ICarDeployableMetadata;

public class ClientContainerDeploymentDesc
extends JndiEnvRefsGroupDesc {
    private String callbackHandler = null;
    private String jaasFile = null;
    private String jaasEntry = null;
    private String username = null;
    private String password = null;
    private String xmlContent = "";
    private String jonasXmlContent = "";
    private ICarDeployableMetadata carDeployableMetadata;

    public ClientContainerDeploymentDesc(ClassLoader classLoader, ApplicationClient applicationClient, JonasClient jonasClient) throws DeploymentDescException {
        super(classLoader, applicationClient, jonasClient, null);
        JonasSecurity jonasSecurity;
        if (applicationClient.getCallbackHandler() != null) {
            this.callbackHandler = applicationClient.getCallbackHandler();
        }
        if ((jonasSecurity = jonasClient.getJonasSecurity()) != null) {
            this.jaasFile = null;
            if (jonasSecurity.getJaasfile() != null) {
                this.jaasFile = jonasSecurity.getJaasfile();
            }
            this.jaasEntry = null;
            if (jonasSecurity.getJaasentry() != null) {
                this.jaasEntry = jonasSecurity.getJaasentry();
            }
            this.username = null;
            if (jonasSecurity.getUsername() != null) {
                this.username = jonasSecurity.getUsername();
            }
            this.password = null;
            if (jonasSecurity.getPassword() != null) {
                this.password = jonasSecurity.getPassword();
            }
        }
    }

    public String getJaasFile() {
        return this.jaasFile;
    }

    public String getJaasEntry() {
        return this.jaasEntry;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCallbackHandler() {
        return this.callbackHandler;
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public String getJOnASXmlContent() {
        return this.jonasXmlContent;
    }

    public void setXmlContent(String xmlContent) {
        this.xmlContent = xmlContent;
    }

    public void setJOnASXmlContent(String jonasXmlContent) {
        this.jonasXmlContent = jonasXmlContent;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetDisplayName()=" + this.getDisplayName());
        IResourceEnvRefDesc[] rer = this.getResourceEnvRefDesc();
        for (int i = 0; i < rer.length; ++i) {
            ret.append("\ngetResourceEnvRefDesc(" + i + ")=" + rer[i].getClass().getName());
            ret.append(rer[i].toString());
        }
        IResourceRefDesc[] resourceRefDesc = this.getResourceRefDesc();
        for (int i = 0; i < resourceRefDesc.length; ++i) {
            ret.append("\ngetResourceRefDesc(" + i + ")=" + resourceRefDesc[i].getClass().getName());
            ret.append(resourceRefDesc[i].toString());
        }
        IEnvEntryDesc[] envEntries = this.getEnvEntryDesc();
        for (int i = 0; i < envEntries.length; ++i) {
            ret.append("\ngetEnvEntryDesc(" + i + ")=" + envEntries[i].getClass().getName());
            ret.append(envEntries[i].toString());
        }
        EjbRefDesc[] ejbRefDesc = this.getEjbRefDesc();
        for (int i = 0; i < ejbRefDesc.length; ++i) {
            ret.append("\ngetEjbRefDesc(" + i + ")=" + ejbRefDesc[i].getClass().getName());
            ret.append(((Object)ejbRefDesc[i]).toString());
        }
        MessageDestinationRefDesc[] mdRefDesc = this.getMessageDestinationRefDesc();
        for (int i = 0; i < mdRefDesc.length; ++i) {
            ret.append("\ngetMessageDestinationRefDesc(" + i + ")=" + mdRefDesc[i].getClass().getName());
            ret.append(((Object)mdRefDesc[i]).toString());
        }
        PersistenceUnitRefDesc[] persistUnitRefDesc = this.getPersistenceUnitRefs();
        for (int i = 0; i < persistUnitRefDesc.length; ++i) {
            ret.append("\ngetPersistenceUnitRefs(" + i + ")=" + persistUnitRefDesc[i].getClass().getName());
            ret.append(persistUnitRefDesc[i].toString());
        }
        ret.append("\ngetCallbackHandler()=" + this.getCallbackHandler());
        return ret.toString();
    }

    public void setCarMetadata(ICarDeployableMetadata carDeployableMetadata) {
        this.carDeployableMetadata = carDeployableMetadata;
    }

    public ICarDeployableMetadata getCarDeployableMetadata() {
        return this.carDeployableMetadata;
    }
}

