/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ear.internal.mbean;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.management.javaee.J2EEDeployedObject;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;

public class Ear
extends J2EEDeployedObject {
    private URL[] ejbJars = null;
    private URL[] wars = null;
    private URL[] rars = null;
    private URL earUrl = null;
    private String name = null;
    private String unpackName = null;
    private String[] modules = null;
    private String[] webModules = null;
    private MBeanServer localMBeanServer = null;

    public Ear(String objectName, String pName, String pUnpackName, URL earUrl, String deploymentDescriptor, URL[] ejbJars, URL[] wars, URL[] rars, JmxService jmx) {
        super(objectName);
        this.earUrl = earUrl;
        this.name = pName;
        this.unpackName = pUnpackName;
        this.setDeploymentDescriptor(deploymentDescriptor);
        this.ejbJars = ejbJars;
        this.wars = wars;
        this.rars = rars;
        this.localMBeanServer = jmx.getJmxServer();
        if (this.localMBeanServer == null) {
            throw new RuntimeException("could not get a reference on the MBean Server");
        }
        this.setModules();
        this.setWebModules();
    }

    public URL getEarUrl() {
        return this.earUrl;
    }

    public URL[] getEjbJars() {
        return this.ejbJars;
    }

    public URL[] getWars() {
        return this.wars;
    }

    public URL[] getRars() {
        return this.rars;
    }

    public String getName() {
        return this.name;
    }

    public String getUnpackName() {
        return this.unpackName;
    }

    private void setModules() {
        ArrayList al = new ArrayList();
        try {
            ObjectName on = ObjectName.getInstance(this.getObjectName());
            String domain = on.getDomain();
            String serverName = on.getKeyProperty("J2EEServer");
            String appName = on.getKeyProperty("name");
            ObjectName modulesOn = null;
            modulesOn = J2eeObjectName.getEJBModules(domain, serverName, appName);
            this.addModuleObjectNames(al, modulesOn);
            modulesOn = J2eeObjectName.getWebModules(domain, serverName, appName);
            this.addModuleObjectNames(al, modulesOn);
            modulesOn = J2eeObjectName.getResourceAdapterModules(domain, serverName, appName);
            this.addModuleObjectNames(al, modulesOn);
            modulesOn = J2eeObjectName.getAppClientModules(domain, serverName, appName);
            this.addModuleObjectNames(al, modulesOn);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while using an objectname", e);
        }
        this.modules = new String[al.size()];
        for (int i = 0; i < this.modules.length; ++i) {
            this.modules[i] = al.get(i).toString();
        }
    }

    public String[] getModules() {
        return this.modules;
    }

    public String[] getWebModules() {
        return this.webModules;
    }

    public void setWebModules() {
        ArrayList al = new ArrayList();
        try {
            ObjectName on = ObjectName.getInstance(this.getObjectName());
            String domain = on.getDomain();
            String serverName = on.getKeyProperty("J2EEServer");
            String appName = on.getKeyProperty("name");
            ObjectName modulesOn = J2eeObjectName.getWebModules(domain, serverName, appName);
            this.addModuleObjectNames(al, modulesOn);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while using an objectname", e);
        }
        this.webModules = new String[al.size()];
        for (int i = 0; i < this.webModules.length; ++i) {
            this.webModules[i] = al.get(i).toString();
        }
    }

    private void addModuleObjectNames(ArrayList al, ObjectName modulesOn) {
        Iterator<ObjectName> itNames = this.localMBeanServer.queryNames(modulesOn, null).iterator();
        while (itNames.hasNext()) {
            al.add(itNames.next());
        }
    }
}

