/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.axis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

public class JVelocity {
    private static I18n i18n = I18n.getInstance(JVelocity.class);
    private static Logger logger = Log.getLogger("org.ow2.jonas.generators.wsgen");
    private VelocityEngine vEngine;
    private Template template;

    public JVelocity(String tmplName) throws WsGenException {
        String jonasRoot = System.getProperty("jonas.root");
        if (jonasRoot == null) {
            String err = i18n.getMessage("JVelocity.constr.notset");
            throw new WsGenException(err);
        }
        this.vEngine = new VelocityEngine();
        this.vEngine.setProperty("resource.loader", "class");
        try {
            this.vEngine.init();
        }
        catch (Exception e) {
            String err = i18n.getMessage("JVelocity.constr.initFailure");
            throw new WsGenException(err, e);
        }
        try {
            this.template = this.vEngine.getTemplate(tmplName);
        }
        catch (Exception e) {
            String err = i18n.getMessage("JVelocity.constr.tmplError", tmplName);
            throw new WsGenException(err, e);
        }
    }

    public void generate(File fs, VelocityContext context) throws WsGenException {
        FileWriter fwriter = null;
        try {
            File fdir = fs.getParentFile();
            if (fdir != null && !fdir.exists() && !fdir.mkdirs()) {
                String err = i18n.getMessage("JVelocity.generate.directories", fdir.getPath());
                throw new WsGenException(err);
            }
            fwriter = new FileWriter(fs);
        }
        catch (IOException e) {
            String err = i18n.getMessage("JVelocity.generate.file", fs);
            throw new WsGenException(err, e);
        }
        try {
            this.template.merge(context, fwriter);
        }
        catch (Exception e) {
            String err = i18n.getMessage("JVelocity.generate.cannot", fs);
            throw new WsGenException(err, e);
        }
        try {
            fwriter.flush();
            fwriter.close();
        }
        catch (IOException e) {
            String err = i18n.getMessage("JVelocity.generate.close", fs);
            logger.log(BasicLevel.WARN, (Object)err);
        }
    }
}

