/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans.log;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.jonas.lib.management.javaee.ManagedObject;
import org.ow2.jonas.lib.reconfig.PropertiesConfigurationData;
import org.ow2.jonas.lib.util.Log;

public class LogManagement
extends ManagedObject {
    private long sequenceNumber = 0L;
    public static final String SERVICE_NAME = "log";
    private Properties props = null;
    private String configFile = null;
    private static LogManagement unique = null;

    public String[] getTopics() {
        Logger[] logs = Log.getLoggerFactory().getLoggers();
        TreeSet<String> tset = new TreeSet<String>();
        for (int i = 0; i < logs.length; ++i) {
            tset.add(logs[i].getName());
        }
        return tset.toArray(new String[0]);
    }

    public String getTopicLevel(String topic) {
        Logger topicLogger = Log.getLoggerFactory().getLogger(topic);
        Level lev = topicLogger.getCurrentLevel();
        return lev.getName();
    }

    public void setTopicLevel(String topic, String level) {
        Logger topicLogger = Log.getLoggerFactory().getLogger(topic);
        Level lev = Log.getLevelFactory().getLevel(level);
        if (lev == null) {
            throw new RuntimeException("Unknown level " + level);
        }
        topicLogger.setLevel(lev);
        String propName = "logger." + topic + ".level";
        this.sendReconfigNotification(++this.sequenceNumber, SERVICE_NAME, new PropertiesConfigurationData(propName, level));
    }

    public Properties getProperties() {
        Properties props = Log.getProperties();
        if (props == null) {
            Log.getLoggerFactory();
            props = Log.getProperties();
        }
        return props;
    }

    public void saveConfig() {
        this.sendSaveNotification(++this.sequenceNumber, SERVICE_NAME);
    }

    public String[] getHandlerNames() {
        LoggerFactory lf = Log.getLoggerFactory();
        if (lf instanceof HandlerFactory) {
            HandlerFactory mf = (HandlerFactory)((Object)lf);
            Handler[] hs = mf.getHandlers();
            String[] hns = new String[hs.length];
            for (int i = 0; i < hs.length; ++i) {
                hns[i] = hs[i].getName();
            }
            return hns;
        }
        return null;
    }

    public Map getHandlerAttributes(String handlername) {
        LoggerFactory lf = Log.getLoggerFactory();
        if (lf instanceof HandlerFactory) {
            HandlerFactory mf = (HandlerFactory)((Object)lf);
            Handler h = mf.getHandler(handlername);
            String[] ans = h.getAttributeNames();
            HashMap<String, Object> m = new HashMap<String, Object>(ans.length);
            for (int i = 0; i < ans.length; ++i) {
                m.put(ans[i], h.getAttribute(ans[i]));
            }
            return m;
        }
        return null;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

