/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.tomcat;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.cluster.ClusterMember;
import org.ow2.jonas.lib.management.domain.cluster.tomcat.TomcatClusterMemberMBean;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;

public class TomcatClusterMember
extends ClusterMember
implements TomcatClusterMemberMBean {
    private String tcpListenAddress = null;
    private int tcpListenPort;
    private boolean compress;
    private boolean doReceivedProcessingStats;
    private String receiverInfo;
    private boolean sendAck;
    private long tcpSelectorTimeout;
    private double avgReceivedProcessingTime;
    private long maxReceivedProcessingTime;
    private long minReceivedProcessingTime;
    private long nrOfMsgsReceived;
    private long receivedProcessingTime;
    private long receivedTime;
    private int tcpThreadCount;
    private long totalReceivedBytes;
    private boolean doListen;
    private String senderInfo;
    private long ackTimeout;
    private boolean autoConnect;
    private boolean doTransmitterProcessingStats;
    private String replicationMode;
    private boolean waitForAck;
    private String hostName;
    private String domainName;

    public TomcatClusterMember(String name, String hostName, ServerProxy proxy) {
        super(name, proxy);
        this.hostName = hostName;
        this.domainName = proxy.getDomain();
    }

    public void setInfo() {
        ObjectName crOn = null;
        try {
            crOn = ObjectName.getInstance(this.domainName + ":type=ClusterMembership,host=" + this.hostName);
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.WARN, (Object)e);
            return;
        }
        String[] attNames = new String[]{"avgReceivedProcessingTime", "compress", "doReceivedProcessingStats", "maxReceivedProcessingTime", "minReceivedProcessingTime", "nrOfMsgsReceived", "receivedProcessingTime", "receivedTime", "info", "sendAck", "tcpListenAddress", "tcpListenPort", "tcpSelectorTimeout", "tcpThreadCount", "totalReceivedBytes"};
        AttributeList attList = this.proxy.getAttributes(crOn, attNames);
        for (int i = 0; i < attList.size(); ++i) {
            Attribute att = (Attribute)attList.get(i);
            String attName = att.getName();
            Object attValue = att.getValue();
            if ("avgReceivedProcessingTime".equals(attName)) {
                this.setAvgReceivedProcessingTime((Double)attValue);
            }
            if ("compress".equals(attName)) {
                this.setCompress((Boolean)attValue);
            }
            if ("doReceivedProcessingStats".equals(attName)) {
                this.setDoReceivedProcessingStats((Boolean)attValue);
            }
            if ("maxReceivedProcessingTime".equals(attName)) {
                this.setMaxReceivedProcessingTime((Long)attValue);
            }
            if ("minReceivedProcessingTime".equals(attName)) {
                this.setMinReceivedProcessingTime((Long)attValue);
            }
            if ("nrOfMsgsReceived".equals(attName)) {
                this.setNrOfMsgsReceived((Long)attValue);
            }
            if ("receivedProcessingTime".equals(attName)) {
                this.setReceivedProcessingTime((Long)attValue);
            }
            if ("receivedTime".equals(attName)) {
                this.setReceivedTime((Long)attValue);
            }
            if ("info".equals(attName)) {
                this.setReceiverInfo((String)attValue);
            }
            if ("sendAck".equals(attName)) {
                this.setSendAck((Boolean)attValue);
            }
            if ("tcpListenAddress".equals(attName)) {
                this.setTcpListenAddress((String)attValue);
            }
            if ("tcpListenPort".equals(attName)) {
                this.setTcpListenPort((Integer)attValue);
            }
            if ("tcpSelectorTimeout".equals(attName)) {
                this.setTcpSelectorTimeout((Long)attValue);
            }
            if ("tcpThreadCount".equals(attName)) {
                int threadCount = (Integer)attValue;
                this.setTcpThreadCount(threadCount);
            }
            if (!"totalReceivedBytes".equals(attName)) continue;
            this.setTotalReceivedBytes((Long)attValue);
        }
        ObjectName csOn = null;
        try {
            csOn = ObjectName.getInstance(this.domainName + ":type=ClusterSender,host=" + this.hostName);
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.WARN, (Object)e);
            return;
        }
        attNames = new String[]{"ackTimeout", "autoConnect", "avgProcessingTime", "doTransmitterProcessingStats", "failureCounter", "info", "maxProcessingTime", "minProcessingTime", "nrOfRequests", "processingTime", "replicationMode", "totalBytes", "waitForAck"};
        attList = this.proxy.getAttributes(csOn, attNames);
        for (int i = 0; i < attList.size(); ++i) {
            Attribute att = (Attribute)attList.get(i);
            String attName = att.getName();
            Object attValue = att.getValue();
            if ("ackTimeout".equals(attName)) {
                this.setAckTimeout((Long)attValue);
            }
            if ("autoConnect".equals(attName)) {
                this.setAutoConnect((Boolean)attValue);
            }
            if ("doTransmitterProcessingStats".equals(attName)) {
                this.setDoTransmitterProcessingStats((Boolean)attValue);
            }
            if ("info".equals(attName)) {
                this.setSenderInfo((String)attValue);
            }
            if ("replicationMode".equals(attName)) {
                this.setReplicationMode((String)attValue);
            }
            if (!"waitForAck".equals(attName)) continue;
            this.setWaitForAck((Boolean)attValue);
        }
    }

    public String getTcpListenAddress() {
        return this.tcpListenAddress;
    }

    public void setTcpListenAddress(String tcpListenAddress) {
        this.tcpListenAddress = tcpListenAddress;
    }

    public int getTcpListenPort() {
        return this.tcpListenPort;
    }

    public void setTcpListenPort(int tcpListenPort) {
        this.tcpListenPort = tcpListenPort;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public boolean isDoReceivedProcessingStats() {
        return this.doReceivedProcessingStats;
    }

    public String getReceiverInfo() {
        return this.receiverInfo;
    }

    public boolean isSendAck() {
        return this.sendAck;
    }

    public long getTcpSelectorTimeout() {
        return this.tcpSelectorTimeout;
    }

    public String getHostName() {
        return this.hostName;
    }

    public double getAvgReceivedProcessingTime() {
        return this.avgReceivedProcessingTime;
    }

    public long getMaxReceivedProcessingTime() {
        return this.maxReceivedProcessingTime;
    }

    public void setAvgReceivedProcessingTime(double avgReceivedProcessingTime) {
        this.avgReceivedProcessingTime = avgReceivedProcessingTime;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setDoListen(boolean doListen) {
        this.doListen = doListen;
    }

    public void setDoReceivedProcessingStats(boolean doReceivedProcessingStats) {
        this.doReceivedProcessingStats = doReceivedProcessingStats;
    }

    public void setMaxReceivedProcessingTime(long maxReceivedProcessingTime) {
        this.maxReceivedProcessingTime = maxReceivedProcessingTime;
    }

    public void setMinReceivedProcessingTime(long minReceivedProcessingTime) {
        this.minReceivedProcessingTime = minReceivedProcessingTime;
    }

    public void setNrOfMsgsReceived(long nrOfMsgsReceived) {
        this.nrOfMsgsReceived = nrOfMsgsReceived;
    }

    public void setReceivedProcessingTime(long receivedProcessingTime) {
        this.receivedProcessingTime = receivedProcessingTime;
    }

    public void setReceivedTime(long receivedTime) {
        this.receivedTime = receivedTime;
    }

    public void setReceiverInfo(String receiverInfo) {
        this.receiverInfo = receiverInfo;
    }

    public void setSendAck(boolean sendAck) {
        this.sendAck = sendAck;
    }

    public void setTcpSelectorTimeout(long tcpSelectorTimeout) {
        this.tcpSelectorTimeout = tcpSelectorTimeout;
    }

    public void setTcpThreadCount(int tcpThreadCount) {
        this.tcpThreadCount = tcpThreadCount;
    }

    public void setTotalReceivedBytes(long totalReceivedBytes) {
        this.totalReceivedBytes = totalReceivedBytes;
    }

    public long getMinReceivedProcessingTime() {
        return this.minReceivedProcessingTime;
    }

    public long getNrOfMsgsReceived() {
        return this.nrOfMsgsReceived;
    }

    public long getReceivedProcessingTime() {
        return this.receivedProcessingTime;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public boolean isDoListen() {
        return this.doListen;
    }

    public int getTcpThreadCount() {
        return this.tcpThreadCount;
    }

    public long getTotalReceivedBytes() {
        return this.totalReceivedBytes;
    }

    public String getSenderInfo() {
        return this.senderInfo;
    }

    public void setSenderInfo(String senderInfo) {
        this.senderInfo = senderInfo;
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public void setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    public boolean isDoTransmitterProcessingStats() {
        return this.doTransmitterProcessingStats;
    }

    public void setDoTransmitterProcessingStats(boolean doTransmitterProcessingStats) {
        this.doTransmitterProcessingStats = doTransmitterProcessingStats;
    }

    public String getReplicationMode() {
        return this.replicationMode;
    }

    public void setReplicationMode(String replicationMode) {
        this.replicationMode = replicationMode;
    }

    public boolean isWaitForAck() {
        return this.waitForAck;
    }

    public void setWaitForAck(boolean waitForAck) {
        this.waitForAck = waitForAck;
    }
}

