/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.proxy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.omg.CORBA.ORB;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.Protocol;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.loader.OSGiClassLoader;
import org.ow2.jonas.lib.management.domain.proxy.JMXProxy;

public class ConnectorUtils {
    private ConnectorUtils() {
    }

    public static String getProtocolFromJmxConnectorUrl(String url) {
        int proIndMax;
        int proIndMin = url.indexOf("/jndi/") + "/jndi/".length();
        String protocol = url.substring(proIndMin, proIndMax = url.indexOf("://"));
        if (protocol.equals("rmi")) {
            String subUrl = url.substring(proIndMax + "://".length());
            int subProIndMin = subUrl.indexOf("/") + "/".length();
            int subProIndMax = subUrl.indexOf("connector_");
            protocol = subUrl.substring(subProIndMin, subProIndMax);
        }
        return protocol;
    }

    public static String getProviderUrlFromJmxConnectorUrl(String url) {
        int proIndMin = url.indexOf("/jndi/") + "/jndi/".length();
        String protocol = ConnectorUtils.getProtocolFromJmxConnectorUrl(url);
        int urlIndMax = url.indexOf("/" + protocol + "connector");
        return url.substring(proIndMin, urlIndMax);
    }

    public static JMXConnector getConnector(String urlString, String username, String password, Logger logger) throws IOException, SecurityException, MalformedURLException {
        JMXServiceURL url = null;
        try {
            url = new JMXServiceURL(urlString);
            return ConnectorUtils.getConnector(url, username, password, logger);
        }
        catch (MalformedURLException me) {
            logger.log(BasicLevel.ERROR, (Object)("Malformed URL:" + urlString));
            throw me;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static JMXConnector getConnector(JMXServiceURL url, String username, String password, Logger logger) throws IOException, SecurityException {
        JMXConnector connector = null;
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (url.getProtocol().equals("iiop")) {
            try {
                ORB orb = null;
                IExecution<ORB> exec = new IExecution<ORB>(){

                    @Override
                    public ORB execute() throws Exception {
                        ORB obj = (ORB)new InitialContext().lookup("java:comp/ORB");
                        return obj;
                    }
                };
                OSGiClassLoader cl = new OSGiClassLoader();
                ExecutionResult<ORB> res = RunnableHelper.execute(cl, exec);
                if (res.hasException()) {
                    throw res.getException();
                }
                orb = res.getResult();
                env.put("java.naming.corba.orb", orb);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot get ORB: : " + e));
                return null;
            }
        }
        String initCtxClass = null;
        String providerUrl = null;
        try {
            String urlPath = url.getURLPath();
            String protocol = ConnectorUtils.getProtocolFromJmxConnectorUrl(urlPath);
            Protocol p = ConfigurationRepository.getProtocol(protocol);
            initCtxClass = p.getInitialContextFactoryClassName();
            providerUrl = ConnectorUtils.getProviderUrlFromJmxConnectorUrl(urlPath);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to get the InitialContext from the protocol '" + url.getProtocol() + "'"));
            return null;
        }
        if (initCtxClass != null) {
            env.put("java.naming.factory.initial", initCtxClass);
            env.put("java.naming.provider.url", providerUrl);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Setting the InitialContext to " + initCtxClass));
            }
        }
        if (username != null && password != null) {
            String[] creds = new String[]{username, password};
            env.put("jmx.remote.credentials", creds);
        }
        try {
            final JMXServiceURL myUrl = url;
            final HashMap<String, Object> myEnv = env;
            IExecution<JMXConnector> exec = new IExecution<JMXConnector>(){

                @Override
                public JMXConnector execute() throws Exception {
                    return JMXConnectorFactory.connect(myUrl, myEnv);
                }
            };
            ClassLoader cl = JMXProxy.class.getClassLoader();
            ExecutionResult<JMXConnector> res = RunnableHelper.execute(cl, exec);
            if (res.hasException()) {
                throw res.getException();
            }
            connector = res.getResult();
        }
        catch (IOException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("JMXConnectorFactory error: " + e));
        }
        return connector;
    }
}

