/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.PropDump;
import org.ow2.jonas.mail.MailService;
import org.ow2.jonas.mail.MailServiceException;
import org.ow2.jonas.mail.factory.JavaMail;
import org.ow2.jonas.mail.internal.factory.AbstractJavaMail;
import org.ow2.jonas.mail.internal.factory.JavaMailMimePartDS;
import org.ow2.jonas.mail.internal.factory.JavaMailSession;
import org.ow2.jonas.mail.internal.factory.mbean.JavaMailMimePartDSResource;
import org.ow2.jonas.mail.internal.factory.mbean.JavaMailSessionResource;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASMailService
extends AbsServiceImpl
implements MailService {
    private static Logger logger = Log.getLogger("org.ow2.jonas.mail");
    private JmxService jmxService = null;
    private Context ictx = null;
    private RegistryService registryService;
    private List<String> factoryNames = new Vector<String>();
    private Map<String, JavaMailSession> jMailSessionFactories = new Hashtable<String, JavaMailSession>();
    private Map<String, JavaMailMimePartDS> jMailMimePartDSFactories = new Hashtable<String, JavaMailMimePartDS>();
    private Map<String, String> boundFactories = new Hashtable<String, String>();
    private static final int JAVAX_MAIL_SESSION_FACTORY = 1;
    private static final int JAVAX_MAIL_INTERNET_MIMEPARTDATASOURCE = 2;
    public static final String FACTORIES = "jonas.service.mail.factories";
    public static final String CLASS = "jonas.service.mail.class";

    public void setFactories(String factories) {
        this.factoryNames = JOnASMailService.convertToList(factories);
    }

    @Override
    protected void doStart() throws ServiceException {
        super.initLogger(Log.getLogger("org.ow2.jonas.management"));
        IExecution<InitialContext> ictxGetter = new IExecution<InitialContext>(){

            @Override
            public InitialContext execute() throws Exception {
                return JOnASMailService.this.getRegistryService().getRegistryContext();
            }
        };
        ExecutionResult<InitialContext> ictxResult = RunnableHelper.execute(this.getClass().getClassLoader(), ictxGetter);
        if (ictxResult.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when Mail service initializing");
            throw new ServiceException("Cannot create initial context when Mail service initializing", ictxResult.getException());
        }
        this.ictx = ictxResult.getResult();
        this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        String factoryName = null;
        for (int i = 0; i < this.factoryNames.size(); ++i) {
            factoryName = this.factoryNames.get(i);
            try {
                JProp prop = JProp.getInstance(factoryName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Creating mail factory " + factoryName));
                }
                this.createMailFactory(factoryName, prop.getConfigFileEnv());
                continue;
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                logger.log(BasicLevel.ERROR, (Object)("JOnAS: Cannot create mail factory " + factoryName + " : " + e));
                logger.log(BasicLevel.ERROR, (Object)("Please check the " + factoryName + ".properties file"));
            }
        }
        try {
            this.jmxService.registerModelMBean((Object)this, JonasObjectName.mailService(this.getDomainName()));
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Cannot register 'mail' service MBean", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)"Mail Service started");
    }

    @Override
    protected void doStop() throws ServiceException {
        try {
            this.unbindMailFactories();
        }
        catch (MailServiceException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot unbind mail factories " + e));
            throw new ServiceException("Cannot unbind mail factories ", e);
        }
        if (this.jmxService != null) {
            this.jmxService.unregisterModelMBean(JonasObjectName.mailService(this.getDomainName()));
        }
        logger.log(BasicLevel.INFO, (Object)"mail service stopped");
    }

    @Override
    public void recreateJavaMailFactory(JavaMail factory) throws MailServiceException {
        String jndiName = factory.getName();
        try {
            this.ictx.rebind(jndiName, (Object)factory);
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot bind mail factory '" + jndiName + "'  :" + e.getMessage()));
            throw new MailServiceException("Cannot bind mail factory " + jndiName + ".", e);
        }
    }

    @Override
    public void renameJavaMailFactory(String oldName, JavaMail factory) throws MailServiceException {
        block7: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("In renameMailFactory, old name = " + oldName));
            }
            try {
                this.ictx.unbind(oldName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(oldName + " unbound"));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block7;
                logger.log(BasicLevel.DEBUG, (Object)("Warning: cannot unbind mail factory object named " + oldName));
            }
        }
        String jndiName = factory.getName();
        try {
            this.ictx.rebind(jndiName, (Object)factory);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("factory rebound under the name " + jndiName));
            }
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot bind mail factory '" + jndiName + "'  :" + e.getMessage()));
            throw new MailServiceException("Cannot bind mail factory " + jndiName + ".", e);
        }
        this.boundFactories.put(jndiName, factory.getFactoryName());
        this.boundFactories.remove(oldName);
    }

    @Override
    public void createMailFactory(String factoryName, Properties props) throws MailServiceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            PropDump.print("These are the properties from which the MailService picks to construct Mail Factories", props, logger, BasicLevel.DEBUG);
        }
        AbstractJavaMail factory = null;
        String factoryType = props.getProperty("mail.factory.type");
        String jndiName = props.getProperty("mail.factory.name");
        if (jndiName == null) {
            logger.log(BasicLevel.ERROR, (Object)"The property 'mail.factory.name' is a required property.");
            throw new MailServiceException("The property 'mail.factory.name' is a required property for this factory.");
        }
        if (factoryType == null) {
            logger.log(BasicLevel.ERROR, (Object)"The property 'mail.factory.type' is a required property.");
            throw new MailServiceException("The property 'mail.factory.type' is a required property for this factory.");
        }
        if (this.boundFactories.containsKey(jndiName)) {
            logger.log(BasicLevel.ERROR, (Object)("There is already a factory bound with the name " + jndiName));
            throw new MailServiceException("There is already a factory bound with the name '" + jndiName + "', please correct the provided configuration properties");
        }
        int typeOfFactory = factoryType.equalsIgnoreCase("javax.mail.Session") ? 1 : (factoryType.equalsIgnoreCase("javax.mail.internet.MimePartDataSource") ? 2 : 0);
        switch (typeOfFactory) {
            case 1: {
                JavaMailSession sessionFactory = new JavaMailSession(factoryName, jndiName, props, this);
                this.jMailSessionFactories.put(factoryName, sessionFactory);
                factory = sessionFactory;
                break;
            }
            case 2: {
                JavaMailMimePartDS mimeFactory = new JavaMailMimePartDS(factoryName, jndiName, props, this);
                this.jMailMimePartDSFactories.put(factoryName, mimeFactory);
                factory = mimeFactory;
                break;
            }
            default: {
                throw new MailServiceException("Can not create a factory of the type '" + factoryType + "'. This type is incorrect.");
            }
        }
        try {
            this.ictx.rebind(jndiName, (Object)factory);
            this.boundFactories.put(jndiName, factoryName);
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot bind mail factory '" + jndiName + "'  :" + e.getMessage()));
            throw new MailServiceException("Cannot bind mail factory " + jndiName + ".", e);
        }
        logger.log(BasicLevel.INFO, (Object)("Mapping Mail Factory " + factoryType + " on " + jndiName));
        try {
            ObjectName on = null;
            switch (typeOfFactory) {
                case 1: {
                    on = J2eeObjectName.JavaMailResource(this.getDomainName(), factoryName, this.getJonasServerName(), "javax.mail.Session");
                    JavaMailSessionResource javaMailSessionResource = null;
                    javaMailSessionResource = new JavaMailSessionResource(on.toString(), false, false, false, (JavaMailSession)factory);
                    this.jmxService.registerModelMBean((Object)javaMailSessionResource, on);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break;
                    logger.log(BasicLevel.DEBUG, (Object)("Register session mail factory with name " + factoryName));
                    break;
                }
                case 2: {
                    on = J2eeObjectName.JavaMailResource(this.getDomainName(), factoryName, this.getJonasServerName(), "javax.mail.internet.MimePartDataSource");
                    JavaMailMimePartDSResource javaMailMimePartDSResource = null;
                    javaMailMimePartDSResource = new JavaMailMimePartDSResource(on.toString(), false, false, false, (JavaMailMimePartDS)factory);
                    this.jmxService.registerModelMBean((Object)javaMailMimePartDSResource, on);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break;
                    logger.log(BasicLevel.DEBUG, (Object)("Register mime mail factory with name " + factoryName));
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register JavaMailResource MBean");
        }
    }

    public void createMailFactoryMBean(String name, Properties props, Boolean loadFromFile) throws MailServiceException {
        boolean fromFile = loadFromFile;
        if (!fromFile) {
            try {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Call getInstance on JProp in order to create the properties file");
                }
                JProp.getInstance(name, props);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create mail factory " + name + " as cannot create properties file : " + e.toString()));
                throw new ServiceException("MailService: Cannot create mail factory " + name + ",\n" + e.toString());
            }
        }
        try {
            this.createMailFactory(name, props);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot create mail factory: " + name));
            throw new ServiceException("MailService: Cannot create mail factory: " + name + ",\n" + e.toString());
        }
    }

    @Override
    public void unbindMailFactories() throws MailServiceException {
        String factoryName;
        int i;
        String[] factories = new String[this.jMailSessionFactories.size()];
        factories = this.jMailSessionFactories.keySet().toArray(factories);
        for (i = 0; i < factories.length; ++i) {
            factoryName = factories[i];
            this.unbindMailFactoryMBean(factoryName);
        }
        factories = new String[this.jMailMimePartDSFactories.size()];
        factories = this.jMailMimePartDSFactories.keySet().toArray(factories);
        for (i = 0; i < factories.length; ++i) {
            factoryName = factories[i];
            this.unbindMailFactoryMBean(factoryName);
        }
    }

    public void unbindMailFactoryMBean(String factoryName) throws MailServiceException {
        int typeOfFactory;
        String name = null;
        JavaMailSession jmailSession = this.jMailSessionFactories.get(factoryName);
        JavaMailMimePartDS jMailMimePartDS = this.jMailMimePartDSFactories.get(factoryName);
        if (jmailSession != null) {
            name = jmailSession.getName();
            typeOfFactory = 1;
        } else if (jMailMimePartDS != null) {
            name = jMailMimePartDS.getName();
            typeOfFactory = 2;
        } else {
            throw new MailServiceException("Can not unload the mail factory '" + factoryName + "' (this is not a known factory name)");
        }
        try {
            this.ictx.unbind(name);
            this.boundFactories.remove(name);
        }
        catch (NamingException e) {
            throw new MailServiceException("Can not unbind the factory '" + name + "'.", e);
        }
        JProp.removeInstance(name);
        if (this.jmxService != null) {
            ObjectName on = null;
            switch (typeOfFactory) {
                case 1: {
                    on = J2eeObjectName.JavaMailResource(this.getDomainName(), factoryName, this.getJonasServerName(), "javax.mail.Session");
                    this.jmxService.unregisterModelMBean(on);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Unregister session mail factory with name " + factoryName));
                    }
                    this.jMailSessionFactories.remove(factoryName);
                    break;
                }
                case 2: {
                    on = J2eeObjectName.JavaMailResource(this.getDomainName(), factoryName, this.getJonasServerName(), "javax.mail.internet.MimePartDataSource");
                    this.jmxService.unregisterModelMBean(on);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Unregister mime mail factory with name " + factoryName));
                    }
                    this.jMailMimePartDSFactories.remove(factoryName);
                }
            }
        }
    }

    public String getFactoryName(String jndiName) {
        return this.boundFactories.get(jndiName);
    }

    public Integer getCurrentNumberOfMailFactories() {
        return this.jMailSessionFactories.size() + this.jMailMimePartDSFactories.size();
    }

    public Integer getCurrentNumberOfSessionMailFactories() {
        return this.jMailSessionFactories.size();
    }

    public Integer getCurrentNumberOfMimeMailFactories() {
        return this.jMailMimePartDSFactories.size();
    }

    public Properties getMailFactoryPropertiesFile(String configFile) throws Exception {
        try {
            return JProp.getInstance(configFile).getConfigFileEnv();
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Error occured when reading file " + configFile));
            throw e;
        }
    }

    public List<String> getMailFactoryPropertiesFiles() throws Exception {
        return JModule.getMailFactoryPropsInDir();
    }

    public List<String> getMimePartMailFactoryPropertiesFiles() throws Exception {
        return JModule.getMailFactoryPropsInDir("javax.mail.internet.MimePartDataSource");
    }

    public List<String> getSessionMailFactoryPropertiesFiles() throws Exception {
        return JModule.getMailFactoryPropsInDir("javax.mail.Session");
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setRegistryService(RegistryService registry) {
        this.registryService = registry;
    }

    private RegistryService getRegistryService() {
        return this.registryService;
    }
}

