/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap.deploymentplan;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.services.bootstrap.deploymentplan.JOnASDeploymentPlanMBean;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deployer.api.IDeploymentPlanDeployer;

public class JOnASDeploymentPlan
implements JOnASDeploymentPlanMBean {
    private Log logger = LogFactory.getLog(JOnASDeploymentPlan.class);
    private MBeanServer mbeanServer = null;
    private ServerProperties serverProperties = null;
    private IDeploymentPlanDeployer deploymentPlanDeployer = null;

    public void start() throws Exception {
        try {
            ObjectName objectName = JonasObjectName.deploymentPlan(this.serverProperties.getDomainName());
            this.mbeanServer.registerMBean(this, objectName);
        }
        catch (Exception e) {
            this.logger.error("MBean registration error, {0}", e);
        }
    }

    public void stop() throws ServiceException {
        if (this.mbeanServer != null) {
            try {
                ObjectName objectName = JonasObjectName.deploymentPlan(this.serverProperties.getDomainName());
                this.mbeanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {
                this.logger.error("MBean unregistration error, {0}", e);
            }
        }
    }

    public void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setDeploymentPlanDeployer(IDeploymentPlanDeployer deploymentPlanDeployer) {
        this.deploymentPlanDeployer = deploymentPlanDeployer;
    }

    public Integer getDeploymentPlansCount() {
        return this.deploymentPlanDeployer.getDeploymentPlansCount();
    }
}

