/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl.xml.parsing;

import java.net.URL;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.CommonDeploymentDescLoader;
import org.ow2.util.ee.metadata.war.impl.xml.struct.Filter;
import org.ow2.util.ee.metadata.war.impl.xml.struct.Listener;
import org.ow2.util.ee.metadata.war.impl.xml.struct.Servlet;
import org.ow2.util.ee.metadata.war.impl.xml.struct.WAR;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AbsWebLoader
extends CommonDeploymentDescLoader {
    private WAR war = null;
    public static final String JSPCONFIGNAME = "jsp-config";
    public static final String LOGINCONFIGNAME = "login-config";
    public static final String SESSIONCONFIGNAME = "session-config";
    public static final String URLPATTERNNAME = "url-pattern";

    protected AbsWebLoader(URL url) {
        this(url, new WAR());
    }

    protected AbsWebLoader(URL url, WAR war) {
        super(url);
        this.war = war;
    }

    protected void analyzeServlet(Element servletElement, Servlet servlet) {
        String name = XMLUtils.getStringValueElement(servletElement, "servlet-name");
        servlet.setName(name);
        String className = XMLUtils.getStringValueElement(servletElement, "servlet-class");
        servlet.setClassName(className);
    }

    protected void analyzeListeners(Element rootElement) {
        NodeList listenerList = rootElement.getElementsByTagName("listener");
        for (int i = 0; i < listenerList.getLength(); ++i) {
            Element listenerElement = (Element)listenerList.item(i);
            Listener listener = new Listener();
            this.war.addListener(listener);
            this.analyzeListener(listenerElement, listener);
        }
    }

    protected void analyzeFilters(Element rootElement) {
        NodeList filterList = rootElement.getElementsByTagName("filter");
        for (int i = 0; i < filterList.getLength(); ++i) {
            Element filterElement = (Element)filterList.item(i);
            Filter filter = new Filter();
            this.war.addFilter(filter);
            this.analyzeFilter(filterElement, filter);
        }
    }

    protected void analyzeServlets(Element rootElement) {
        NodeList servletList = rootElement.getElementsByTagName("servlet");
        for (int i = 0; i < servletList.getLength(); ++i) {
            Element servletElement = (Element)servletList.item(i);
            Servlet servlet = new Servlet();
            this.getWAR().addServlet(servlet);
            this.analyzeServlet(servletElement, servlet);
        }
    }

    protected void analyzeListener(Element listenerElement, Listener listener) {
        String listenerClassName = XMLUtils.getStringValueElement(listenerElement, "listener-class");
        listener.setListenerClassName(listenerClassName);
    }

    protected void analyzeFilter(Element filterElement, Filter filter) {
        String filterClassName = XMLUtils.getStringValueElement(filterElement, "filter-class");
        filter.setFilterClassName(filterClassName);
    }

    protected boolean analyzeJspConfig(Element webAppRootElement) {
        NodeList servletList = webAppRootElement.getElementsByTagName(JSPCONFIGNAME);
        int nbelem = 0;
        for (int i = 0; i < servletList.getLength(); ++i) {
            if (++nbelem <= 1) continue;
            return false;
        }
        return true;
    }

    protected boolean analyzeSessionConfig(Element webAppRootElement) {
        NodeList elementList = webAppRootElement.getElementsByTagName(SESSIONCONFIGNAME);
        int nbelem = 0;
        for (int i = 0; i < elementList.getLength(); ++i) {
            if (++nbelem <= 1) continue;
            return false;
        }
        return true;
    }

    protected boolean analyzeLoginConfig(Element webAppRootElement) {
        NodeList elementList = webAppRootElement.getElementsByTagName(LOGINCONFIGNAME);
        int nbelem = 0;
        for (int i = 0; i < elementList.getLength(); ++i) {
            if (++nbelem <= 1) continue;
            return false;
        }
        return true;
    }

    protected boolean analyzeUrlPattern(Element webAppRootElement) {
        NodeList elementList = webAppRootElement.getElementsByTagName(URLPATTERNNAME);
        for (int i = 0; i < elementList.getLength(); ++i) {
            Element urlpatternElement = (Element)elementList.item(i);
            String pattern = urlpatternElement.getFirstChild().getNodeValue();
            if (pattern == null || pattern.indexOf(10) == -1) continue;
            return false;
        }
        return true;
    }

    public WAR getWAR() {
        return this.war;
    }
}

