/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import org.springframework.asm.commons.EmptyVisitor;
import org.springframework.core.type.ClassMetadata;
import org.springframework.util.ClassUtils;

class ClassMetadataReadingVisitor
extends EmptyVisitor
implements ClassMetadata {
    private String className;
    private boolean isInterface;
    private boolean isAbstract;
    private String superClassName;
    private String[] interfaces;

    ClassMetadataReadingVisitor() {
    }

    public void visit(int version2, int access, String name, String signature, String supername, String[] interfaces) {
        this.className = ClassUtils.convertResourcePathToClassName(name);
        this.isInterface = (access & 0x200) != 0;
        boolean bl = this.isAbstract = (access & 0x400) != 0;
        if (supername != null) {
            this.superClassName = ClassUtils.convertResourcePathToClassName(supername);
        }
        this.interfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            this.interfaces[i] = ClassUtils.convertResourcePathToClassName(interfaces[i]);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isConcrete() {
        return !this.isInterface && !this.isAbstract;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    public String[] getInterfaceNames() {
        return this.interfaces;
    }
}

