/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.message.WSSAddSAMLToken;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.SAMLIssuerFactory;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Document;
import wssec.SOAPUtil;

public class TestWSSecurityST1
extends TestCase
implements CallbackHandler {
    private static Log log = LogFactory.getLog(class$wssec$TestWSSecurityST1 == null ? (class$wssec$TestWSSecurityST1 = TestWSSecurityST1.class$("wssec.TestWSSecurityST1")) : class$wssec$TestWSSecurityST1);
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"uri:LogTestService2\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    MessageContext msgContext;
    Message message;
    static /* synthetic */ Class class$wssec$TestWSSecurityST1;

    public TestWSSecurityST1(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$wssec$TestWSSecurityST1 == null ? (class$wssec$TestWSSecurityST1 = TestWSSecurityST1.class$("wssec.TestWSSecurityST1")) : class$wssec$TestWSSecurityST1);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestWSSecurityST1.suite());
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient(new NullProvider());
        this.msgContext = new MessageContext(tmpEngine);
        this.message = this.getSOAPMessage();
    }

    protected Message getSOAPMessage() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message(in);
        msg.setMessageContext(this.msgContext);
        return msg;
    }

    public void testSAMLUnsignedSenderVouches() throws Exception {
        SOAPEnvelope unsignedEnvelope = this.message.getSOAPEnvelope();
        Object envelope = null;
        SAMLIssuer saml = SAMLIssuerFactory.getInstance("saml.properties");
        SAMLAssertion assertion = saml.newAssertion();
        WSSAddSAMLToken wsSign = new WSSAddSAMLToken();
        Document doc = unsignedEnvelope.getAsDocument();
        log.info("Before SAMLUnsignedSenderVouches....");
        Document signedDoc = wsSign.build(doc, assertion);
        log.info("After SAMLUnsignedSenderVouches....");
        Message signedMsg = (Message)SOAPUtil.toSOAPMessage(signedDoc);
        if (log.isDebugEnabled()) {
            log.debug("Unsigned SAML message (sender vouches):");
            XMLUtils.PrettyElementToWriter(signedMsg.getSOAPEnvelope().getAsDOM(), new PrintWriter(System.out));
        }
        String encryptedString = signedMsg.getSOAPPartAsString();
        signedDoc = signedMsg.getSOAPEnvelope().getAsDocument();
        this.verify(signedDoc);
    }

    private void verify(Document doc) throws Exception {
        secEngine.processSecurityHeader(doc, null, this, null);
        SOAPUtil.updateSOAPMessage(doc, this.message);
        String decryptedString = this.message.getSOAPPartAsString();
        TestWSSecurityST1.assertTrue((decryptedString.indexOf("LogTestService2") > 0 ? (byte)1 : 0) != 0);
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("security");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

