/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class DeployTask
extends BaseTask {
    List<FileSet> filesets = new ArrayList<FileSet>();

    public void execute() throws BuildException {
        try {
            Project project = Workspace.getProject(this.getProject().getBaseDir());
            for (FileSet fileset : this.filesets) {
                DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
                String[] files = ds.getIncludedFiles();
                if (files.length == 0) {
                    System.out.println("No files included");
                }
                int i = 0;
                while (i < files.length) {
                    File file = new File(ds.getBasedir(), files[i]);
                    try {
                        if (file.isFile() && file.getName().endsWith(".jar")) {
                            project.deploy(file);
                        } else {
                            this.error("Not a jar file: " + file);
                        }
                    }
                    catch (Exception e) {
                        this.error("Failed to deploy " + file + " : " + e);
                    }
                    ++i;
                }
            }
            this.report(project);
            if (project.getErrors().size() > 0) {
                throw new BuildException("Deploy failed");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException(t);
        }
    }

    public void addFileset(FileSet files) {
        this.filesets.add(files);
    }
}

