/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.jaxws;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.WSDLQueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.ow2.jonas.ws.cxf.http.JOnASDestination;
import org.ow2.jonas.ws.cxf.http.JOnASWSDLQueryHandler;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.jaxws.IWSRequest;
import org.ow2.jonas.ws.jaxws.IWSResponse;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortIdentifier;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.http.servlet.JOnASServletRequestWrapper;
import org.ow2.jonas.ws.jaxws.http.servlet.JOnASServletResponseWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CXFWSEndpoint
implements IWebServiceEndpoint {
    private static Log logger = LogFactory.getLog(CXFWSEndpoint.class);
    private EndpointImpl endpoint = null;
    private JOnASDestination destination = null;
    private PortMetaData portMetaData;
    private IWebServiceEndpoint.EndpointType type;
    private WebservicesContainer container;
    private PortIdentifier identifier;

    public CXFWSEndpoint(EndpointImpl endpoint, IWebServiceEndpoint.EndpointType type, PortMetaData pmd, WebservicesContainer container) {
        this.endpoint = endpoint;
        this.type = type;
        this.portMetaData = pmd;
        this.destination = (JOnASDestination)endpoint.getServer().getDestination();
        this.container = container;
        this.identifier = new PortIdentifier(endpoint.getServiceName(), endpoint.getEndpointName().getLocalPart());
    }

    public IWebServiceEndpoint.EndpointType getType() {
        return this.type;
    }

    public PortIdentifier getIdentifier() {
        return this.identifier;
    }

    public void invoke(IWSRequest request, IWSResponse response) throws WSException {
        logger.debug((Object)"Receiving request on the thread ''{0}''", new Object[]{Thread.currentThread()});
        Bus old = BusFactory.getThreadDefaultBus();
        try {
            Bus bus = this.destination.getBus();
            BusFactory.setThreadDefaultBus((Bus)bus);
            JOnASServletRequestWrapper httpRequest = (JOnASServletRequestWrapper)request.getAttribute(JOnASServletRequestWrapper.class);
            JOnASServletResponseWrapper httpResponse = (JOnASServletResponseWrapper)request.getAttribute(JOnASServletResponseWrapper.class);
            ServletContext servletContext = (ServletContext)request.getAttribute(ServletContext.class);
            if ("GET".equals(httpRequest.getMethod())) {
                this.processGetMethod(bus, httpRequest.getRequest(), httpResponse.getResponse());
            } else {
                this.destination.invoke(servletContext, httpRequest.getRequest(), httpResponse.getResponse());
            }
        }
        catch (IOException ioe) {
            throw new WSException((Throwable)ioe);
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)old);
        }
    }

    private void processGetMethod(Bus bus, HttpServletRequest request, HttpServletResponse response) throws WSException {
        EndpointInfo ei = this.destination.getEndpointInfo();
        if (null != request.getQueryString() && request.getQueryString().length() > 0 && bus.getExtension(QueryHandlerRegistry.class) != null) {
            String ctxUri = request.getPathInfo();
            String address = request.getRequestURL().toString();
            String baseUri = address + "?" + request.getQueryString();
            ei.setAddress(address);
            for (Object qh : ((QueryHandlerRegistry)bus.getExtension(QueryHandlerRegistry.class)).getHandlers()) {
                if (!qh.isRecognizedQuery(baseUri, ctxUri, ei)) continue;
                if (qh instanceof WSDLQueryHandler) {
                    String url = request.getRequestURL().toString();
                    qh = new JOnASWSDLQueryHandler(bus, url, ei, this.container);
                }
                response.setContentType(qh.getResponseContentType(baseUri, ctxUri));
                try {
                    ServletOutputStream out = response.getOutputStream();
                    qh.writeResponse(baseUri, ctxUri, ei, (OutputStream)out);
                    out.flush();
                    return;
                }
                catch (Exception e) {
                    throw new WSException((Throwable)e);
                }
            }
        }
    }

    public void start() {
        logger.debug((Object)"Start CXFWSEndpoint[{0}]", new Object[]{this.endpoint.getEndpointName()});
        this.endpoint.publish();
    }

    public void stop() {
        logger.debug((Object)"Stop CXFWSEndpoint[{0}]", new Object[]{this.endpoint.getEndpointName()});
        this.endpoint.stop();
    }

    public PortMetaData getPortMetaData() {
        return this.portMetaData;
    }

    public JOnASDestination getDestination() {
        return this.destination;
    }

    public void displayInfos() {
        String endpointURL = "not yet available";
        String name = this.endpoint.getImplementorClass().getName();
        if (this.portMetaData != null && this.portMetaData.getEndpointURL() != null) {
            endpointURL = this.portMetaData.getEndpointURL();
        }
        logger.info((Object)"{0} endpoint ''{1}'' available at ''{2}''", new Object[]{this.type, name, endpointURL});
    }
}

