/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import java.util.StringTokenizer;
import org.ow2.carol.util.configuration.ConfigurationException;

public class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static int getPortOfUrl(String url) throws ConfigurationException {
        int portNumber = 0;
        try {
            StringTokenizer st = new StringTokenizer(url, ":");
            st.nextToken();
            st.nextToken();
            if (st.hasMoreTokens()) {
                StringTokenizer lastst = new StringTokenizer(st.nextToken(), "/");
                String pts = lastst.nextToken().trim();
                int i = pts.indexOf(44);
                if (i > 0) {
                    pts = pts.substring(0, i);
                }
                portNumber = new Integer(pts);
            }
            return portNumber;
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid URL '" + url + "'. It should be on the format <protocol>://<hostname>:<port>");
        }
    }

    public static String getHostOfUrl(String url) throws ConfigurationException {
        String host = null;
        try {
            String[] tmpSplitStr = url.split(":");
            String tmpHost = tmpSplitStr[1];
            String[] tmpSplitHost = tmpHost.split("/");
            host = tmpSplitHost[tmpSplitHost.length - 1];
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid URL '" + url + "'. It should be on the format <protocol>://<hostname>:<port>");
        }
        return host;
    }
}

