/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.MemoryStore;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FifoMemoryStore
extends MemoryStore {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$store$FifoMemoryStore == null ? (class$net$sf$ehcache$store$FifoMemoryStore = FifoMemoryStore.class$("net.sf.ehcache.store.FifoMemoryStore")) : class$net$sf$ehcache$store$FifoMemoryStore).getName());
    private static final int SEQUENCED_HASH_MAP = 1;
    private static final int LINKED_HASH_MAP = 2;
    private int collectionType;
    static /* synthetic */ Class class$net$sf$ehcache$store$FifoMemoryStore;

    public FifoMemoryStore(Ehcache cache, DiskStore diskStore) {
        super(cache, diskStore);
        try {
            Class.forName("java.util.LinkedHashMap");
            this.map = new LinkedHashMap();
            this.collectionType = 2;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("org.apache.commons.collections.SequencedHashMap");
                this.map = new SequencedHashMap();
                this.collectionType = 1;
            }
            catch (ClassNotFoundException ee) {
                LOG.error((Object)ee.getMessage());
            }
        }
    }

    protected final void doPut(Element element) throws CacheException {
        if (this.isFull()) {
            this.removeFirstElement();
        }
    }

    Element getFirstElement() {
        if (this.map.size() == 0) {
            return null;
        }
        Element element = null;
        if (this.collectionType == 2) {
            Set keySet = this.map.keySet();
            Iterator itr = keySet.iterator();
            if (itr.hasNext()) {
                Serializable key = (Serializable)itr.next();
                element = (Element)this.map.get(key);
            }
        } else if (this.collectionType == 1) {
            Serializable key = (Serializable)((SequencedHashMap)this.map).getFirstKey();
            element = (Element)this.map.get(key);
        }
        return element;
    }

    private void removeFirstElement() throws CacheException {
        Element element = this.getFirstElement();
        if (element.isExpired()) {
            this.remove(element.getObjectKey());
            this.notifyExpiry(element);
            return;
        }
        this.remove(element.getObjectKey());
        this.evict(element);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

